/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.CacheTime;
import org.apache.geode.internal.SystemTimer;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.logging.DateFormatter;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class DSClock
implements CacheTime {
    private static final Logger logger = LogService.getLogger();
    private final int MAX_TIME_OFFSET_DIFF = 100;
    private final long MAX_CACHE_TIME_MILLIS = 0xFFFFFFFFFFFFFFL;
    private static final long MINIMUM_TIME_DIFF = 5000L;
    private volatile long cacheTimeDelta;
    private SystemTimer.SystemTimerTask cacheTimeTask = null;
    private final AtomicLong suspendedTime = new AtomicLong(0L);
    private final boolean isLoner;
    private DSClockTestHook testHook;

    protected DSClock(boolean lonerDS) {
        this.isLoner = lonerDS;
    }

    @Override
    public long cacheTimeMillis() {
        long result;
        long offset = this.getCacheTimeOffset();
        long st = this.getStopTime();
        if (st != 0L) {
            result = st + offset;
            if (result < 0L || result > 0xFFFFFFFFFFFFFFL) {
                throw new IllegalStateException("Expected cacheTimeMillis " + result + " to be >= 0 and <= 72057594037927935 stopTime=" + st + " offset=" + offset);
            }
        } else {
            long ct = System.currentTimeMillis();
            result = ct + offset;
            if (result < 0L || result > 0xFFFFFFFFFFFFFFL) {
                throw new IllegalStateException("Expected cacheTimeMillis " + result + " to be >= 0 and <= 72057594037927935 curTime=" + ct + " offset=" + offset);
            }
        }
        return result;
    }

    public long getCacheTimeOffset() {
        return this.cacheTimeDelta;
    }

    public void setCacheTimeOffset(DistributedMember coord, long offset, boolean isJoin) {
        if (Boolean.getBoolean("gemfire.disable-distributed-clock")) {
            return;
        }
        if (this.isLoner) {
            this.setLonerCacheTimeOffset(offset);
        } else {
            this.setServerCacheTimeOffset(coord, offset, isJoin);
        }
    }

    private void setLonerCacheTimeOffset(long offset) {
        if (offset > this.cacheTimeDelta + 5000L) {
            long theTime = System.currentTimeMillis();
            this.cacheTimeDelta = offset;
            String cacheTime = DateFormatter.formatDate(new Date(theTime + offset));
            logger.info("The current cache time is {}.  Delta from the system clock is {} milliseconds.", new Object[]{cacheTime, this.cacheTimeDelta});
        } else if (offset < this.cacheTimeDelta - 5000L) {
            this.cacheTimeDelta = offset;
            this.cancelAndScheduleNewCacheTimerTask(offset);
        }
    }

    private void setServerCacheTimeOffset(DistributedMember coord, long offset, boolean isJoin) {
        if (isJoin || offset > this.cacheTimeDelta) {
            long theTime = System.currentTimeMillis();
            this.cacheTimeDelta = offset;
            if (this.cacheTimeDelta <= -300000L || 300000L <= this.cacheTimeDelta) {
                logger.warn("The clock for this machine may be more than 5 minutes different than the negotiated cache time received from {}", (Object)coord);
            }
            String cacheTime = DateFormatter.formatDate(new Date(theTime + offset));
            if (Math.abs(this.cacheTimeDelta) > 1000L) {
                Object src = coord;
                if (src == null) {
                    src = "local clock adjustment";
                }
                logger.info("The negotiated cache time from {} is {}.  Delta from the system clock is {} milliseconds.", new Object[]{src, cacheTime, this.cacheTimeDelta});
            }
        } else if (!isJoin && offset < this.cacheTimeDelta) {
            if (this.cacheTimeDelta - offset >= 100L) {
                logger.warn("New cache time offset calculated is off more than {} ms from earlier offset.", (Object)(this.cacheTimeDelta - offset));
            }
            this.cancelAndScheduleNewCacheTimerTask(offset);
        }
    }

    private void suspendCacheTimeMillis(boolean stw) {
        if (stw) {
            long newSt;
            long oldSt;
            while (!this.suspendedTime.compareAndSet(oldSt, newSt = (oldSt = this.suspendedTime.get()) == 0L ? System.currentTimeMillis() : oldSt + 1L)) {
            }
        } else {
            this.suspendedTime.set(0L);
        }
    }

    private void cancelAndScheduleNewCacheTimerTask(long offset) {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache != null && !cache.isClosed()) {
            if (this.cacheTimeTask != null) {
                this.cacheTimeTask.cancel();
            }
            this.cacheTimeTask = new CacheTimeTask(offset);
            SystemTimer timer = cache.getCCPTimer();
            timer.scheduleAtFixedRate(this.cacheTimeTask, 1L, 2L);
            if (logger.isDebugEnabled()) {
                logger.debug("Started a timer task to suspend cache time for new lower offset of {}ms and current offset is: {}", (Object)offset, (Object)this.cacheTimeDelta);
            }
        }
    }

    public long getStopTime() {
        return this.suspendedTime.get();
    }

    public DSClockTestHook getTestHook() {
        return this.testHook;
    }

    public void setTestHook(DSClockTestHook th) {
        this.testHook = th;
    }

    private class CacheTimeTask
    extends SystemTimer.SystemTimerTask {
        private long lowerCacheTimeOffset = 0L;

        public CacheTimeTask(long cacheTimeOffset) {
            this.lowerCacheTimeOffset = cacheTimeOffset;
        }

        @Override
        public void run2() {
            long systemTime;
            boolean isCancelled = false;
            DSClock.this.suspendCacheTimeMillis(true);
            long currTime = System.currentTimeMillis();
            long cacheTime = DSClock.this.cacheTimeMillis();
            if (DSClock.this.testHook != null) {
                DSClock.this.testHook.suspendAtBreakPoint(1);
                DSClock.this.testHook.addInformation("CacheTime", cacheTime);
                DSClock.this.testHook.addInformation("AwaitedTime", currTime + this.lowerCacheTimeOffset);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("CacheTime: {}ms and currTime with offset: {}", (Object)cacheTime, (Object)(currTime + this.lowerCacheTimeOffset + "ms"));
            }
            if (cacheTime <= (systemTime = currTime + this.lowerCacheTimeOffset)) {
                DSClock.this.setCacheTimeOffset(null, this.lowerCacheTimeOffset, true);
                DSClock.this.suspendCacheTimeMillis(false);
                this.cancel();
                isCancelled = true;
                if (DSClock.this.testHook != null) {
                    DSClock.this.testHook.suspendAtBreakPoint(2);
                    DSClock.this.testHook.addInformation("FinalCacheTime", DSClock.this.cacheTimeMillis());
                }
            }
            if (DSClock.this.testHook != null && isCancelled) {
                DSClock.this.testHook.suspendAtBreakPoint(3);
                DSClock.this.testHook.addInformation("TimerTaskCancelled", true);
            }
        }

        @Override
        public boolean cancel() {
            GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
            if (cache != null && !cache.isClosed()) {
                DSClock.this.suspendCacheTimeMillis(false);
            }
            return super.cancel();
        }
    }

    public static interface DSClockTestHook {
        public void suspendAtBreakPoint(int var1);

        public void addInformation(Object var1, Object var2);

        public Object getInformation(Object var1);
    }
}

