/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.Index;
import org.apache.geode.cache.query.IndexExistsException;
import org.apache.geode.cache.query.IndexNameConflictException;
import org.apache.geode.cache.query.IndexStatistics;
import org.apache.geode.cache.query.IndexType;
import org.apache.geode.cache.query.QueryException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.RuntimeIterator;
import org.apache.geode.cache.query.internal.index.AbstractIndex;
import org.apache.geode.cache.query.internal.index.IMQException;
import org.apache.geode.cache.query.internal.index.IndexCreationHelper;
import org.apache.geode.cache.query.internal.index.IndexManager;
import org.apache.geode.cache.query.internal.index.IndexStats;
import org.apache.geode.cache.query.internal.index.IndexUtils;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionDataStore;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.execute.BucketMovedException;

public class PartitionedIndex
extends AbstractIndex {
    private final Map<Region, List<Index>> bucketIndexes = Collections.synchronizedMap(new HashMap());
    private volatile Index arbitraryBucketIndex;
    private final IndexType type;
    private int numRemoteBucektsIndexed;
    private final String imports;
    protected Set mapIndexKeys = Collections.newSetFromMap(new ConcurrentHashMap());
    private volatile boolean populateInProgress;

    public PartitionedIndex(InternalCache cache, IndexType iType, String indexName, Region r, String indexedExpression, String fromClause, String imports) {
        super(cache, indexName, r, fromClause, indexedExpression, null, fromClause, indexedExpression, null, null);
        this.type = iType;
        this.imports = imports;
        if (iType == IndexType.HASH && !this.getRegion().getAttributes().getIndexMaintenanceSynchronous()) {
            throw new UnsupportedOperationException("Hash index is currently not supported for regions with Asynchronous index maintenance.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToBucketIndexes(Region r, Index index) {
        Map<Region, List<Index>> map = this.bucketIndexes;
        synchronized (map) {
            this.setArbitraryBucketIndex(index);
            List<Index> indexes = this.bucketIndexes.get(r);
            if (indexes == null) {
                indexes = new ArrayList<Index>();
            }
            indexes.add(index);
            this.bucketIndexes.put(r, indexes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromBucketIndexes(Region r, Index index) {
        Map<Region, List<Index>> map = this.bucketIndexes;
        synchronized (map) {
            List<Index> indexes = this.bucketIndexes.get(r);
            if (indexes != null) {
                indexes.remove(index);
                if (indexes.isEmpty()) {
                    this.bucketIndexes.remove(r);
                }
            }
            if (index == this.arbitraryBucketIndex) {
                this.resetArbitraryBucketIndex(this.retrieveArbitraryBucketIndex());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfIndexedBuckets() {
        Map<Region, List<Index>> map = this.bucketIndexes;
        synchronized (map) {
            int size = 0;
            for (List<Index> indexList : this.bucketIndexes.values()) {
                size += indexList.size();
            }
            return size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getBucketIndexes() {
        Map<Region, List<Index>> map = this.bucketIndexes;
        synchronized (map) {
            ArrayList<Index> indexes = new ArrayList<Index>();
            for (List<Index> indexList : this.bucketIndexes.values()) {
                indexes.addAll(indexList);
            }
            return indexes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Index> getBucketIndexes(Region r) {
        Map<Region, List<Index>> map = this.bucketIndexes;
        synchronized (map) {
            ArrayList<Index> indexes = new ArrayList<Index>();
            List<Index> indexList = this.bucketIndexes.get(r);
            if (indexList != null) {
                indexes.addAll(indexList);
            }
            return indexes;
        }
    }

    public void setArbitraryBucketIndex(Index index) {
        if (this.arbitraryBucketIndex == null) {
            this.arbitraryBucketIndex = index;
        }
    }

    private void resetArbitraryBucketIndex(Index index) {
        this.arbitraryBucketIndex = index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Index retrieveArbitraryBucketIndex() {
        Index index = null;
        Map<Region, List<Index>> map = this.bucketIndexes;
        synchronized (map) {
            List<Index> indexList;
            if (this.bucketIndexes.size() > 0 && (indexList = this.bucketIndexes.values().iterator().next()) != null && indexList.size() > 0) {
                index = indexList.get(0);
            }
        }
        return index;
    }

    public Index getBucketIndex() {
        return this.arbitraryBucketIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map.Entry<Region, List<Index>> getFirstBucketIndex() {
        Map.Entry<Region, List<Index>> firstIndexEntry = null;
        Map<Region, List<Index>> map = this.bucketIndexes;
        synchronized (map) {
            if (this.bucketIndexes.size() > 0) {
                firstIndexEntry = this.bucketIndexes.entrySet().iterator().next();
            }
        }
        return firstIndexEntry;
    }

    @Override
    public IndexType getType() {
        return this.type;
    }

    public static AbstractIndex getBucketIndex(PartitionedRegion pr, String indexName, Integer bId) throws QueryInvocationTargetException {
        try {
            pr.checkReadiness();
        }
        catch (Exception ex) {
            throw new QueryInvocationTargetException(ex.getMessage());
        }
        PartitionedRegionDataStore prds = pr.getDataStore();
        BucketRegion bukRegion = prds.getLocalBucketById(bId);
        if (bukRegion == null) {
            throw new BucketMovedException("Bucket not found for the id :" + bId);
        }
        AbstractIndex index = null;
        if (bukRegion.getIndexManager() == null) {
            if (pr.getCache().getLogger().fineEnabled()) {
                pr.getCache().getLogger().fine("Index Manager not found for the bucket region " + bukRegion.getFullPath() + " unable to fetch the index " + indexName);
            }
            throw new QueryInvocationTargetException("Index Manager not found,  unable to fetch the index " + indexName);
        }
        index = (AbstractIndex)bukRegion.getIndexManager().getIndex(indexName);
        return index;
    }

    public void verifyAndCreateMissingIndex(List buckets) throws QueryInvocationTargetException {
        PartitionedRegion pr = (PartitionedRegion)this.getRegion();
        PartitionedRegionDataStore prds = pr.getDataStore();
        for (Object bId : buckets) {
            BucketRegion bukRegion = prds.getLocalBucketById((Integer)bId);
            if (bukRegion == null) {
                throw new QueryInvocationTargetException("Bucket not found for the id :" + String.valueOf(bId));
            }
            IndexManager im = IndexUtils.getIndexManager(this.cache, bukRegion, true);
            if (im == null || im.getIndex(this.indexName) != null) continue;
            try {
                if (pr.getCache().getLogger().fineEnabled()) {
                    pr.getCache().getLogger().fine("Verifying index presence on bucket region.  Found index " + this.indexName + " not present on the bucket region " + bukRegion.getFullPath() + ", index will be created on this region.");
                }
                ExecutionContext externalContext = new ExecutionContext(null, bukRegion.getCache());
                externalContext.setBucketRegion(pr, bukRegion);
                im.createIndex(this.indexName, this.type, this.originalIndexedExpression, this.fromClause, this.imports, externalContext, this, true);
            }
            catch (IndexExistsException indexExistsException) {
            }
            catch (IndexNameConflictException indexNameConflictException) {}
        }
    }

    @Override
    protected boolean isCompactRangeIndex() {
        return false;
    }

    public void setRemoteBucketesIndexed(int remoteBucketsIndexed) {
        this.numRemoteBucektsIndexed = remoteBucketsIndexed;
    }

    public int getNumRemoteBucketsIndexed() {
        return this.numRemoteBucektsIndexed;
    }

    @Override
    public Region getRegion() {
        return super.getRegion();
    }

    @Override
    void addMapping(RegionEntry entry) throws IMQException {
        throw new RuntimeException("Not supported on partitioned index");
    }

    @Override
    public void initializeIndex(boolean loadEntries) throws IMQException {
        throw new RuntimeException("Not supported on partitioned index");
    }

    @Override
    void lockedQuery(Object key, int operator, Collection results, CompiledValue iterOps, RuntimeIterator indpndntItr, ExecutionContext context, List projAttrib, SelectResults intermediateResults, boolean isIntersection) {
        throw new RuntimeException("Not supported on partitioned index");
    }

    @Override
    void recreateIndexData() throws IMQException {
        throw new RuntimeException("Not supported on partitioned index");
    }

    @Override
    void removeMapping(RegionEntry entry, int opCode) {
        throw new RuntimeException("Not supported on partitioned index");
    }

    @Override
    public boolean clear() throws QueryException {
        return false;
    }

    @Override
    public IndexStatistics getStatistics() {
        return this.internalIndexStats;
    }

    public String getImports() {
        return this.imports;
    }

    @Override
    public String toString() {
        return super.toString() + "imports : " + this.imports;
    }

    @Override
    protected AbstractIndex.InternalIndexStatistics createStats(String indexName) {
        if (this.internalIndexStats == null) {
            this.internalIndexStats = new PartitionedIndexStatistics(this.indexName);
        }
        return this.internalIndexStats;
    }

    protected AbstractIndex.InternalIndexStatistics createExplicitStats(String indexName) {
        return new PartitionedIndexStatistics(indexName);
    }

    @Override
    void instantiateEvaluator(IndexCreationHelper indexCreationHelper) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ObjectType getResultSetType() {
        throw new UnsupportedOperationException();
    }

    @Override
    void lockedQuery(Object lowerBoundKey, int lowerBoundOperator, Object upperBoundKey, int upperBoundOperator, Collection results, Set keysToRemove, ExecutionContext context) throws TypeMismatchException {
        throw new RuntimeException("Not supported on partitioned index");
    }

    @Override
    public int getSizeEstimate(Object key, int op, int matchLevel) {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    void lockedQuery(Object key, int operator, Collection results, Set keysToRemove, ExecutionContext context) throws TypeMismatchException {
        throw new RuntimeException("Not supported on partitioned index");
    }

    @Override
    void addMapping(Object key, Object value, RegionEntry entry) throws IMQException {
        throw new RuntimeException("Not supported on partitioned index");
    }

    @Override
    void saveMapping(Object key, Object value, RegionEntry entry) throws IMQException {
        throw new RuntimeException("Not supported on partitioned index");
    }

    public void incNumMapKeysStats(Object mapKey) {
        if (this.internalIndexStats != null && !this.mapIndexKeys.contains(mapKey)) {
            this.mapIndexKeys.add(mapKey);
            this.internalIndexStats.incNumMapIndexKeys(1L);
        }
    }

    public void incNumBucketIndexes() {
        if (this.internalIndexStats != null) {
            this.internalIndexStats.incNumBucketIndexes(1);
        }
    }

    @Override
    public boolean isEmpty() {
        boolean empty = true;
        for (Object index : this.getBucketIndexes()) {
            empty = ((AbstractIndex)index).isEmpty();
            if (empty) continue;
            return false;
        }
        return empty;
    }

    public boolean isPopulateInProgress() {
        return this.populateInProgress;
    }

    public void setPopulateInProgress(boolean populateInProgress) {
        this.populateInProgress = populateInProgress;
    }

    class PartitionedIndexStatistics
    extends AbstractIndex.InternalIndexStatistics {
        private final IndexStats vsdStats;

        public PartitionedIndexStatistics(String indexName) {
            this.vsdStats = new IndexStats(PartitionedIndex.this.getRegion().getCache().getDistributedSystem(), indexName);
        }

        @Override
        public long getNumUpdates() {
            return this.vsdStats.getNumUpdates();
        }

        @Override
        public void incNumValues(int delta) {
            this.vsdStats.incNumValues(delta);
        }

        @Override
        public void incNumUpdates() {
            this.vsdStats.incNumUpdates();
        }

        @Override
        public void incNumUpdates(int delta) {
            this.vsdStats.incNumUpdates(delta);
        }

        @Override
        public void updateNumKeys(long numKeys) {
            this.vsdStats.updateNumKeys(numKeys);
        }

        @Override
        public void incNumKeys(long numKeys) {
            this.vsdStats.incNumKeys(numKeys);
        }

        @Override
        public void incNumMapIndexKeys(long numKeys) {
            this.vsdStats.incNumMapIndexKeys(numKeys);
        }

        @Override
        public void incUpdateTime(long delta) {
            this.vsdStats.incUpdateTime(delta);
        }

        @Override
        public void incUpdatesInProgress(int delta) {
            this.vsdStats.incUpdatesInProgress(delta);
        }

        @Override
        public void incNumUses() {
            this.vsdStats.incNumUses();
        }

        @Override
        public void incUseTime(long delta) {
            this.vsdStats.incUseTime(delta);
        }

        @Override
        public void incUsesInProgress(int delta) {
            this.vsdStats.incUsesInProgress(delta);
        }

        @Override
        public void incReadLockCount(int delta) {
            this.vsdStats.incReadLockCount(delta);
        }

        @Override
        public void incNumBucketIndexes(int delta) {
            this.vsdStats.incNumBucketIndexes(delta);
        }

        @Override
        public long getNumberOfMapIndexKeys() {
            return this.vsdStats.getNumberOfMapIndexKeys();
        }

        @Override
        public long getTotalUpdateTime() {
            return this.vsdStats.getTotalUpdateTime();
        }

        @Override
        public long getTotalUses() {
            return this.vsdStats.getTotalUses();
        }

        @Override
        public long getNumberOfKeys() {
            return this.vsdStats.getNumberOfKeys();
        }

        @Override
        public long getNumberOfValues() {
            return this.vsdStats.getNumberOfValues();
        }

        @Override
        public long getReadLockCountLong() {
            return this.vsdStats.getReadLockCount();
        }

        @Override
        public long getNumberOfBucketIndexesLong() {
            return this.vsdStats.getNumberOfBucketIndexes();
        }

        @Override
        public void close() {
            this.vsdStats.close();
        }

        public String toString() {
            return "No Keys = " + this.getNumberOfKeys() + "\nNo Map Index Keys = " + this.getNumberOfMapIndexKeys() + "\nNo Values = " + this.getNumberOfValues() + "\nNo Uses = " + this.getTotalUses() + "\nNo Updates = " + this.getNumUpdates() + "\nTotal Update time = " + this.getTotalUpdateTime() + "\n";
        }
    }
}

