/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal.index;

import it.unimi.dsi.fastutil.HashCommon;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.geode.annotations.internal.MutableForTesting;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.index.HashIndex;
import org.apache.geode.cache.query.internal.index.IndexManager;
import org.apache.geode.cache.query.internal.types.TypeUtils;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.pdx.internal.PdxString;

public class HashIndexSet
implements Set {
    private transient CachePerfStats cacheStats;
    protected static final float DEFAULT_LOAD_FACTOR = 0.5f;
    protected static final int DEFAULT_INITIAL_CAPACITY = 128;
    protected float _loadFactor;
    protected static final float CONDITIONAL_REMOVED_TOKEN_REHASH_FACTOR = 0.7f;
    HashIndexSetProperties hashIndexSetProperties;
    protected HashIndex.IMQEvaluator _imqEvaluator;
    protected static final Object REMOVED = new Object();
    @MutableForTesting
    static boolean TEST_ALWAYS_REHASH = false;

    public HashIndexSet() {
        this(128, 0.5f);
    }

    private HashIndexSet(int initialCapacity, float loadFactor) {
        this.setUp(initialCapacity, loadFactor);
    }

    public void setEvaluator(HashIndex.IMQEvaluator evaluator) {
        this._imqEvaluator = evaluator;
    }

    public void setCachePerfStats(CachePerfStats stats) {
        this.cacheStats = stats;
    }

    @Override
    public boolean contains(Object obj) {
        return this.index(obj) >= 0;
    }

    private int computeHash(Object object) {
        return object.hashCode();
    }

    protected int index(Object obj) {
        return this.index(this._imqEvaluator.evaluateKey(obj), obj);
    }

    protected int index(Object key, Object obj) {
        return this.index(key, obj, -1);
    }

    protected int index(Object key, Object obj, int ignoreThisSlot) {
        HashIndexSetProperties metaData = this.hashIndexSetProperties;
        Object[] set = metaData.set;
        int mask = metaData.mask;
        int hash = this.computeHash(key);
        int pos = HashCommon.mix((int)hash) & mask;
        Object curr = set[pos];
        if (curr != null && curr != REMOVED) {
            if (curr.equals(obj) && pos != ignoreThisSlot) {
                return pos;
            }
            while ((curr = set[pos = pos + 1 & mask]) != null && curr != REMOVED) {
                if (!curr.equals(obj) || pos == ignoreThisSlot) continue;
                return pos;
            }
        }
        return -1;
    }

    public Iterator getAll() {
        return this.getAllNotMatching(Collections.EMPTY_LIST);
    }

    public Iterator getAllNotMatching(Collection keysToRemove) {
        return new HashIndexSetIterator(keysToRemove, this.hashIndexSetProperties);
    }

    public Iterator get(Object indexKey) {
        return new HashIndexSetIterator(indexKey, this.hashIndexSetProperties);
    }

    private boolean addObjectToSet(Object[] set, int index, Object newObject) {
        boolean added = true;
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException("Cannot add:" + String.valueOf(newObject) + " into array position:" + index);
        }
        Object oldObject = set[index];
        if (oldObject == null || oldObject == REMOVED) {
            set[index] = newObject;
        }
        return added;
    }

    @Override
    public synchronized boolean add(Object obj) {
        throw new UnsupportedOperationException("add(Object) not supported, try add(Object key, Object obj) instead");
    }

    public synchronized int add(Object indexKey, Object obj) throws TypeMismatchException {
        if (indexKey == null) {
            indexKey = IndexManager.NULL;
        }
        this.preInsertHook();
        HashIndexSetProperties metaData = this.hashIndexSetProperties;
        int indexSlot = this.insertionIndex(indexKey, metaData);
        Object old = metaData.set[indexSlot];
        this.addObjectToSet(metaData.set, indexSlot, obj);
        this.hashIndexSetProperties = metaData;
        this.postInsertHook(old == null);
        return indexSlot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int insertionIndex(Object indexKey, HashIndexSetProperties metaData) {
        int mask = metaData.mask;
        Object[] array = metaData.set;
        int hash = this.computeHash(indexKey);
        long start = -1L;
        if (this.cacheStats != null) {
            start = this.cacheStats.getTime();
            this.cacheStats.incQueryResultsHashCollisions();
        }
        try {
            int pos = HashCommon.mix((int)hash) & mask;
            Object curr = array[pos];
            if (curr != null && curr != REMOVED) {
                while ((curr = array[pos = pos + 1 & mask]) != null && curr != REMOVED) {
                }
            }
            int n = pos;
            return n;
        }
        finally {
            if (this.cacheStats != null) {
                this.cacheStats.endQueryResultsHashCollisionProbe(start);
            }
        }
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof HashIndexSet)) {
            return false;
        }
        Set that = (Set)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.containsAll((Collection)that);
    }

    @Override
    public int hashCode() {
        int hash = 0;
        Object[] set = this.hashIndexSetProperties.set;
        int i = set.length;
        while (i-- > 0) {
            if (set[i] == null || set[i] == REMOVED) continue;
            hash += set[i].hashCode();
        }
        return hash;
    }

    protected void rehash(int newN) {
        HashIndexSetProperties metaData = this.hashIndexSetProperties;
        if (TEST_ALWAYS_REHASH) {
            Thread.yield();
        }
        Object[] oldSet = metaData.set;
        int oldCapacity = oldSet.length;
        int mask = newN - 1;
        int _maxSize = this.computeMaxSize(newN, this._loadFactor);
        Object[] newSet = new Object[newN + 1];
        HashIndexSetProperties newHashIndexProperties = new HashIndexSetProperties(newSet, mask);
        newHashIndexProperties.size = metaData.size;
        newHashIndexProperties.free = this.hashIndexSetProperties.computeNumFree();
        newHashIndexProperties.removedTokens = 0;
        newHashIndexProperties.n = newN;
        newHashIndexProperties.maxSize = _maxSize;
        int i = oldCapacity;
        while (i-- > 0) {
            int index;
            if (oldSet[i] == null || oldSet[i] == REMOVED) continue;
            Object o = oldSet[i];
            Object key = this._imqEvaluator.evaluateKey(o);
            if (key == null) {
                key = IndexManager.NULL;
            }
            if ((index = this.insertionIndex(key, newHashIndexProperties)) < 0) continue;
            this.addObjectToSet(newHashIndexProperties.set, index, o);
        }
        this.hashIndexSetProperties = newHashIndexProperties;
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException("toArray not yet supported");
    }

    @Override
    public Object[] toArray(Object[] a) {
        throw new UnsupportedOperationException("toArray(Object[] a) not yet supported");
    }

    @Override
    public void clear() {
        HashIndexSetProperties metaData = this.hashIndexSetProperties;
        metaData.size = 0;
        metaData.free = this.capacity();
        metaData.removedTokens = 0;
        Object[] set = metaData.set;
        int i = set.length;
        while (i-- > 0) {
            set[i] = null;
        }
        this.hashIndexSetProperties = metaData;
    }

    protected int capacity() {
        return this.hashIndexSetProperties.set.length;
    }

    @Override
    public boolean remove(Object obj) {
        return this.remove(this._imqEvaluator.evaluateKey(obj), obj);
    }

    public synchronized boolean remove(Object key, Object obj) {
        return this.remove(key, obj, -1);
    }

    public synchronized boolean remove(Object key, Object obj, int newIndexSlot) {
        int indexSlot = this.index(key, obj, newIndexSlot);
        boolean removed = false;
        if (indexSlot >= 0 && indexSlot != newIndexSlot) {
            removed = this.removeAt(indexSlot);
            return removed;
        }
        if (!IndexManager.isObjectModificationInplace()) {
            HashIndexSetIterator iterator = (HashIndexSetIterator)this.getAll();
            while (iterator.hasNext()) {
                Object indexedObject = iterator.next();
                if (!this.areObjectsEqual(indexedObject, obj) || iterator.currentObjectIndex() == newIndexSlot) continue;
                iterator.remove();
                return true;
            }
        }
        return false;
    }

    public boolean areObjectsEqual(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        try {
            return TypeUtils.compare(o1, o2, 13).equals(Boolean.TRUE);
        }
        catch (TypeMismatchException e) {
            return o1.equals(o2);
        }
    }

    @Override
    public Iterator iterator() {
        return this.getAll();
    }

    @Override
    public boolean containsAll(Collection collection) {
        for (Object o : collection) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException("Add all not implemented");
    }

    @Override
    public boolean removeAll(Collection collection) {
        boolean changed = false;
        int size = collection.size();
        Iterator it = collection.iterator();
        while (size-- > 0) {
            if (!this.remove(it.next())) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection collection) {
        boolean changed = false;
        int size = this.size();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (collection.contains(object)) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.hashIndexSetProperties.size;
    }

    @Override
    public int size() {
        return this.hashIndexSetProperties.size;
    }

    public int size(Object indexKey) {
        return this.hashIndexSetProperties.size;
    }

    public void compact() {
        this.trimToSize(this.hashIndexSetProperties.size);
    }

    public boolean trimToSize(int n) {
        int l = HashCommon.nextPowerOfTwo((int)((int)Math.ceil((float)n / this._loadFactor)));
        if (this.hashIndexSetProperties.n <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected boolean removeAt(int index) {
        HashIndexSetProperties metaData = this.hashIndexSetProperties;
        Object cur = metaData.set[index];
        if (cur == null || cur == REMOVED) {
            return false;
        }
        metaData.set[index] = REMOVED;
        --metaData.size;
        ++metaData.removedTokens;
        this.hashIndexSetProperties = metaData;
        return true;
    }

    protected int setUp(int expectedCapacity, float loadFactor) {
        int n = HashCommon.arraySize((int)expectedCapacity, (float)loadFactor);
        this._loadFactor = loadFactor;
        int _maxSize = this.computeMaxSize(n, loadFactor);
        int mask = n - 1;
        Object[] set = new Object[n + 1];
        HashIndexSetProperties metaData = new HashIndexSetProperties(set, mask);
        metaData.n = n;
        metaData.maxSize = _maxSize;
        this.hashIndexSetProperties = metaData;
        this.hashIndexSetProperties.free = this.hashIndexSetProperties.computeNumFree();
        return n;
    }

    private int computeMaxSize(int n, float loadFactor) {
        return Math.min((int)Math.ceil((float)n * loadFactor), n - 1);
    }

    protected void postInsertHook(boolean usedFreeSlot) {
        if (usedFreeSlot) {
            --this.hashIndexSetProperties.free;
        } else {
            --this.hashIndexSetProperties.removedTokens;
        }
        ++this.hashIndexSetProperties.size;
    }

    protected void preInsertHook() {
        if (this.hashIndexSetProperties.size > this.hashIndexSetProperties.maxSize || this.hashIndexSetProperties.free == 0 || TEST_ALWAYS_REHASH) {
            this.rehash(HashCommon.arraySize((int)(this.hashIndexSetProperties.size + 1), (float)this._loadFactor));
            this.computeMaxSize(this.capacity(), this._loadFactor);
            this.hashIndexSetProperties.free = this.hashIndexSetProperties.computeNumFree();
        } else if ((float)this.hashIndexSetProperties.removedTokens > (float)this.hashIndexSetProperties.maxSize * 0.7f) {
            this.compact();
        }
    }

    class HashIndexSetProperties {
        protected final transient Object[] set;
        protected final int mask;
        protected transient int size = 0;
        protected transient int free;
        transient int removedTokens;
        protected int n;
        protected int maxSize;

        private int computeNumFree() {
            return this.n - this.size;
        }

        public HashIndexSetProperties(Object[] set, int mask) {
            this.set = set;
            this.mask = mask;
        }
    }

    private class HashIndexSetIterator
    implements Iterator {
        private Object keyToMatch;
        private final Object[] objects;
        private int pos;
        private int prevPos;
        private Collection keysToRemove;
        private Object current;
        private int hash;
        private int mask;
        private int probe;

        private HashIndexSetIterator(Collection keysToRemove, HashIndexSetProperties metaData) {
            this.keysToRemove = keysToRemove;
            this.pos = 0;
            this.prevPos = 0;
            this.objects = metaData.set;
            this.current = this.objects[this.pos];
        }

        private HashIndexSetIterator(Object keyToMatch, HashIndexSetProperties metaData) {
            this.keyToMatch = keyToMatch;
            this.objects = metaData.set;
            this.mask = metaData.mask;
            this.hash = HashIndexSet.this.computeHash(keyToMatch);
            this.prevPos = this.pos = HashCommon.mix((int)this.hash) & this.mask;
            this.current = this.objects[this.pos];
        }

        private void setPos(int pos) {
            this.prevPos = this.pos;
            this.pos = pos;
        }

        @Override
        public boolean hasNext() {
            if (this.keysToRemove != null) {
                while (this.pos < this.objects.length) {
                    this.current = this.objects[this.pos];
                    if (this.current != null && !this.current.equals(REMOVED) && this.notMatchingAnyKeyToRemove(this.keysToRemove, this.current)) {
                        return true;
                    }
                    this.setPos(this.pos + 1);
                }
                return false;
            }
            this.current = this.objects[this.pos];
            while (this.current != null) {
                if (this.current != REMOVED && this.objectMatchesIndexKey(this.keyToMatch, this.current)) {
                    return true;
                }
                this.setPos(this.pos + 1 & this.mask);
                this.current = this.objects[this.pos];
            }
            return false;
        }

        private boolean notMatchingAnyKeyToRemove(Collection keysToRemove, Object current) {
            for (Object keyToMatch : keysToRemove) {
                if (!this.objectMatchesIndexKey(keyToMatch, current)) continue;
                return false;
            }
            return true;
        }

        public Object next() throws NoSuchElementException {
            Object obj = this.current;
            if (this.keysToRemove != null) {
                this.setPos(this.pos + 1);
            } else {
                this.setPos(this.pos + 1 & this.mask);
            }
            return obj;
        }

        int currentObjectIndex() {
            return this.prevPos;
        }

        @Override
        public void remove() {
            HashIndexSet.this.removeAt(this.currentObjectIndex());
        }

        public boolean objectMatchesIndexKey(Object indexKey, Object o) {
            Object fieldValue = HashIndexSet.this._imqEvaluator.evaluateKey(o);
            if (fieldValue == IndexManager.NULL && indexKey == IndexManager.NULL) {
                return true;
            }
            try {
                if (fieldValue instanceof PdxString) {
                    if (indexKey instanceof String) {
                        fieldValue = fieldValue.toString();
                    }
                } else if (indexKey instanceof PdxString && fieldValue instanceof String) {
                    fieldValue = new PdxString((String)fieldValue);
                }
                return TypeUtils.compare(fieldValue, indexKey, 13).equals(Boolean.TRUE);
            }
            catch (TypeMismatchException e) {
                return fieldValue.equals(indexKey);
            }
        }
    }
}

