/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.Index;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.Struct;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.AbstractCompiledValue;
import org.apache.geode.cache.query.internal.CompiledComparison;
import org.apache.geode.cache.query.internal.CompiledID;
import org.apache.geode.cache.query.internal.CompiledJunction;
import org.apache.geode.cache.query.internal.CompiledOperation;
import org.apache.geode.cache.query.internal.CompiledSortCriterion;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.DerivedInfo;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.IndexConditioningHelper;
import org.apache.geode.cache.query.internal.IndexCutDownExpansionHelper;
import org.apache.geode.cache.query.internal.IndexInfo;
import org.apache.geode.cache.query.internal.LinkedResultSet;
import org.apache.geode.cache.query.internal.LinkedStructSet;
import org.apache.geode.cache.query.internal.QueryMonitor;
import org.apache.geode.cache.query.internal.QueryObserver;
import org.apache.geode.cache.query.internal.QueryObserverHolder;
import org.apache.geode.cache.query.internal.ResultsBag;
import org.apache.geode.cache.query.internal.ResultsCollectionWrapper;
import org.apache.geode.cache.query.internal.ResultsSet;
import org.apache.geode.cache.query.internal.RuntimeIterator;
import org.apache.geode.cache.query.internal.SortedResultsBag;
import org.apache.geode.cache.query.internal.StructBag;
import org.apache.geode.cache.query.internal.StructFields;
import org.apache.geode.cache.query.internal.StructImpl;
import org.apache.geode.cache.query.internal.StructSet;
import org.apache.geode.cache.query.internal.Support;
import org.apache.geode.cache.query.internal.index.AbstractIndex;
import org.apache.geode.cache.query.internal.index.IndexData;
import org.apache.geode.cache.query.internal.index.IndexManager;
import org.apache.geode.cache.query.internal.index.IndexProtocol;
import org.apache.geode.cache.query.internal.index.IndexUtils;
import org.apache.geode.cache.query.internal.index.MemoryIndexStore;
import org.apache.geode.cache.query.internal.index.PartitionedIndex;
import org.apache.geode.cache.query.internal.types.ObjectTypeImpl;
import org.apache.geode.cache.query.internal.types.StructTypeImpl;
import org.apache.geode.cache.query.types.CollectionType;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.cache.query.types.StructType;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.partitioned.Bucket;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class QueryUtils {
    private static final Logger logger = LogService.getLogger();

    public static SelectResults intersection(SelectResults c1, SelectResults c2, ExecutionContext contextOrNull) {
        QueryObserverHolder.getInstance().invokedQueryUtilsIntersection(c1, c2);
        QueryUtils.assertCompatible(c1, c2);
        if (c1.isEmpty()) {
            return c1;
        }
        if (c2.isEmpty()) {
            return c2;
        }
        if (c1.size() < c2.size()) {
            return QueryUtils.sizeSortedIntersection(c1, c2, contextOrNull);
        }
        return QueryUtils.sizeSortedIntersection(c2, c1, contextOrNull);
    }

    public static SelectResults union(SelectResults c1, SelectResults c2, ExecutionContext contextOrNull) {
        QueryObserverHolder.getInstance().invokedQueryUtilsUnion(c1, c2);
        QueryUtils.assertCompatible(c1, c2);
        if (c1.size() < c2.size()) {
            return QueryUtils.sizeSortedUnion(c1, c2, contextOrNull);
        }
        return QueryUtils.sizeSortedUnion(c2, c1, contextOrNull);
    }

    private static void assertCompatible(SelectResults sr1, SelectResults sr2) {
        Assert.assertTrue(sr1.getCollectionType().getElementType().equals(sr2.getCollectionType().getElementType()));
    }

    public static SelectResults createResultCollection(ExecutionContext context, ObjectType elementType) {
        return context.isDistinct() ? new ResultsSet(elementType) : new ResultsBag(elementType, context.getCachePerfStats());
    }

    public static SelectResults createStructCollection(ExecutionContext context, StructType elementType) {
        return context.isDistinct() ? new StructSet(elementType) : new StructBag(elementType, context.getCachePerfStats());
    }

    public static SelectResults createResultCollection(boolean distinct, ObjectType elementType, ExecutionContext context) {
        return distinct ? new ResultsSet(elementType) : new ResultsBag(elementType, context.getCachePerfStats());
    }

    public static SelectResults createStructCollection(boolean distinct, StructType elementType, ExecutionContext context) {
        return distinct ? new StructSet(elementType) : new StructBag(elementType, context.getCachePerfStats());
    }

    public static SelectResults getEmptySelectResults(ObjectType objectType, CachePerfStats statsOrNull) {
        ResultsBag emptyResults = null;
        emptyResults = objectType instanceof StructType ? new StructBag((StructTypeImpl)objectType, statsOrNull) : new ResultsBag(objectType, statsOrNull);
        return emptyResults;
    }

    public static SelectResults getEmptySelectResults(CollectionType collectionType, CachePerfStats statsOrNull) {
        SelectResults emptyResults = null;
        emptyResults = collectionType.isOrdered() ? new ResultsCollectionWrapper(collectionType.getElementType(), new ArrayList()) : (!collectionType.allowsDuplicates() ? new ResultsCollectionWrapper(collectionType.getElementType(), new HashSet()) : QueryUtils.getEmptySelectResults(collectionType.getElementType(), statsOrNull));
        return emptyResults;
    }

    private static boolean isBag(SelectResults coln) {
        return coln.getCollectionType().allowsDuplicates();
    }

    private static SelectResults sizeSortedIntersection(SelectResults small, SelectResults large, ExecutionContext contextOrNull) {
        boolean largeModifiable;
        boolean smallModifiable = small.isModifiable() && (QueryUtils.isBag(small) || !QueryUtils.isBag(large));
        boolean bl = largeModifiable = large.isModifiable() && (QueryUtils.isBag(large) || !QueryUtils.isBag(small));
        if (smallModifiable) {
            try {
                Iterator itr = small.iterator();
                while (itr.hasNext()) {
                    Object element = itr.next();
                    if (element instanceof MemoryIndexStore.CachedEntryWrapper) {
                        element = ((MemoryIndexStore.CachedEntryWrapper)element).getKey();
                    }
                    int count = large.occurrences(element);
                    if (small.occurrences(element) <= count) continue;
                    itr.remove();
                }
                return small;
            }
            catch (UnsupportedOperationException itr) {
                // empty catch block
            }
        }
        if (largeModifiable) {
            try {
                Iterator itr = large.iterator();
                while (itr.hasNext()) {
                    Object element = itr.next();
                    if (element instanceof MemoryIndexStore.CachedEntryWrapper) {
                        element = ((MemoryIndexStore.CachedEntryWrapper)element).getKey();
                    }
                    int count = small.occurrences(element);
                    if (large.occurrences(element) <= count) continue;
                    itr.remove();
                }
                return large;
            }
            catch (UnsupportedOperationException itr) {
                // empty catch block
            }
        }
        AbstractCollection rs = contextOrNull != null ? (contextOrNull.isDistinct() ? new ResultsSet(small) : new ResultsBag(small, contextOrNull.getCachePerfStats())) : new ResultsBag(small, null);
        Iterator itr = rs.iterator();
        while (itr.hasNext()) {
            Object element = itr.next();
            int count = large.occurrences(element);
            if (rs.occurrences(element) <= count) continue;
            itr.remove();
        }
        return rs;
    }

    private static SelectResults sizeSortedUnion(SelectResults small, SelectResults large, ExecutionContext contextOrNull) {
        boolean largeModifiable;
        boolean smallModifiable = small.isModifiable() && (QueryUtils.isBag(small) || !QueryUtils.isBag(large));
        boolean bl = largeModifiable = large.isModifiable() && (QueryUtils.isBag(large) || !QueryUtils.isBag(small));
        if (largeModifiable) {
            try {
                for (Object element : small) {
                    int count = small.occurrences(element);
                    if (large.occurrences(element) >= count) continue;
                    large.add(element);
                }
                return large;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        if (smallModifiable) {
            try {
                for (Object element : large) {
                    int count = large.occurrences(element);
                    if (small.occurrences(element) >= count) continue;
                    small.add(element);
                }
                return small;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        AbstractCollection rs = contextOrNull != null ? (contextOrNull.isDistinct() ? new ResultsSet(large) : new ResultsBag(large, contextOrNull.getCachePerfStats())) : new ResultsBag(large, null);
        for (Object element : small) {
            rs.add(element);
        }
        return rs;
    }

    static List getDependentItrChainForIndpndntItrs(RuntimeIterator[] indpndntItrs, ExecutionContext context) {
        ArrayList ret = new ArrayList();
        for (RuntimeIterator indpndntItr : indpndntItrs) {
            ret.addAll(context.getCurrScopeDpndntItrsBasedOnSingleIndpndntItr(indpndntItr));
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SelectResults cartesian(SelectResults[] results, RuntimeIterator[][] itrsForResultFields, List expansionList, List finalList, ExecutionContext context, CompiledValue operand) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        SelectResults returnSet = null;
        if (finalList.size() == 1) {
            ObjectType type = ((RuntimeIterator)finalList.iterator().next()).getElementType();
            if (!(type instanceof StructType)) return QueryUtils.createResultCollection(context, type);
            returnSet = QueryUtils.createStructCollection(context, (StructTypeImpl)type);
        } else {
            StructType structType = QueryUtils.createStructTypeForRuntimeIterators(finalList);
            returnSet = QueryUtils.createStructCollection(context, structType);
        }
        ListIterator expnItr = expansionList.listIterator();
        QueryUtils.doNestedIterations(0, returnSet, results, itrsForResultFields, finalList, expnItr, results.length + expansionList.size(), context, operand);
        return returnSet;
    }

    private static void doNestedIterations(int level, SelectResults returnSet, SelectResults[] results, RuntimeIterator[][] itrsForResultFields, List finalItrs, ListIterator expansionItrs, int finalLevel, ExecutionContext context, CompiledValue operand) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        if (level == finalLevel) {
            boolean select = true;
            if (operand != null) {
                select = QueryUtils.applyCondition(operand, context);
            }
            Iterator itr = finalItrs.iterator();
            int len = finalItrs.size();
            if (len > 1) {
                Object[] values = new Object[len];
                int j = 0;
                while (itr.hasNext()) {
                    values[j++] = ((RuntimeIterator)itr.next()).evaluate(context);
                }
                if (select) {
                    ((StructFields)((Object)returnSet)).addFieldValues(values);
                }
            } else if (select) {
                returnSet.add(((RuntimeIterator)itr.next()).evaluate(context));
            }
        } else if (level < results.length) {
            SelectResults individualResultSet = results[level];
            RuntimeIterator[] itrsForFields = itrsForResultFields[level];
            int len = itrsForFields.length;
            for (Object anIndividualResultSet : individualResultSet) {
                QueryMonitor.throwExceptionIfQueryOnCurrentThreadIsCanceled();
                if (len == 1) {
                    itrsForFields[0].setCurrent(anIndividualResultSet);
                } else {
                    Struct struct = (Struct)anIndividualResultSet;
                    Object[] fieldValues = struct.getFieldValues();
                    int size = fieldValues.length;
                    for (int i = 0; i < size; ++i) {
                        itrsForFields[i].setCurrent(fieldValues[i]);
                    }
                }
                QueryUtils.doNestedIterations(level + 1, returnSet, results, itrsForResultFields, finalItrs, expansionItrs, finalLevel, context, operand);
            }
        } else {
            RuntimeIterator currLevel = (RuntimeIterator)expansionItrs.next();
            SelectResults c = currLevel.evaluateCollection(context);
            if (c == null) {
                expansionItrs.previous();
                return;
            }
            for (Object aC : c) {
                currLevel.setCurrent(aC);
                QueryUtils.doNestedIterations(level + 1, returnSet, results, itrsForResultFields, finalItrs, expansionItrs, finalLevel, context, operand);
            }
            expansionItrs.previous();
        }
    }

    public static boolean applyCondition(CompiledValue operand, ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        if (operand == null) {
            return true;
        }
        Object result = operand.evaluate(context);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        if (result != null && result != QueryService.UNDEFINED) {
            throw new TypeMismatchException(String.format("AND/OR operands must be of type boolean, not type ' %s '", result.getClass().getName()));
        }
        return false;
    }

    private static void mergeRelationshipIndexResultsWithIntermediateResults(SelectResults returnSet, SelectResults[] intermediateResults, RuntimeIterator[][] itrsForIntermediateResults, Object[][] indexResults, RuntimeIterator[][] indexFieldToItrsMapping, ListIterator expansionListItr, List finalItrs, ExecutionContext context, List[] checkList, CompiledValue iterOps, IndexCutDownExpansionHelper[] icdeh, int level, int maxExpnCartesianDepth) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        int resultSize = indexResults[level].length;
        for (int j = 0; j < resultSize; ++j) {
            if (!QueryUtils.setIndexFieldValuesInRespectiveIterators(indexResults[level][j], indexFieldToItrsMapping[level], icdeh[level])) continue;
            if (level == indexResults.length - 1) {
                QueryUtils.doNestedIterations(0, returnSet, intermediateResults, itrsForIntermediateResults, finalItrs, expansionListItr, maxExpnCartesianDepth, context, iterOps);
                continue;
            }
            QueryUtils.mergeRelationshipIndexResultsWithIntermediateResults(returnSet, intermediateResults, itrsForIntermediateResults, indexResults, indexFieldToItrsMapping, expansionListItr, finalItrs, context, checkList, iterOps, icdeh, level + 1, maxExpnCartesianDepth);
            if (!icdeh[level + 1].cutDownNeeded) continue;
            icdeh[level + 1].checkSet.clear();
        }
    }

    private static void mergeAndExpandCutDownRelationshipIndexResults(Object[][] values, SelectResults result, RuntimeIterator[][] indexFieldToItrsMapping, ListIterator expansionListIterator, List finalItrs, ExecutionContext context, CompiledValue iterOps, IndexCutDownExpansionHelper[] icdeh, int level) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        int limit;
        int resultSize = values[level].length;
        Boolean applyLimit = (Boolean)context.cacheGet("can_apply_limit_at_index");
        int n = limit = applyLimit != null && applyLimit != false ? QueryUtils.getLimitValue(context) : -1;
        if (limit != -1 && result.size() >= limit) {
            return;
        }
        for (int j = 0; j < resultSize; ++j) {
            QueryMonitor.throwExceptionIfQueryOnCurrentThreadIsCanceled();
            if (!QueryUtils.setIndexFieldValuesInRespectiveIterators(values[level][j], indexFieldToItrsMapping[level], icdeh[level])) continue;
            if (level == values.length - 1) {
                QueryUtils.doNestedIterationsForIndex(expansionListIterator.hasNext(), result, finalItrs, expansionListIterator, context, iterOps, limit, null);
                if (limit == -1 || result.size() < limit) continue;
                break;
            }
            QueryUtils.mergeAndExpandCutDownRelationshipIndexResults(values, result, indexFieldToItrsMapping, expansionListIterator, finalItrs, context, iterOps, icdeh, level + 1);
            if (!icdeh[level + 1].cutDownNeeded) continue;
            icdeh[level + 1].checkSet.clear();
        }
    }

    private static boolean setIndexFieldValuesInRespectiveIterators(Object value, RuntimeIterator[] indexFieldToItrsMapping, IndexCutDownExpansionHelper icdeh) {
        boolean select = true;
        int len = indexFieldToItrsMapping.length;
        if (len == 1) {
            Support.Assert(!icdeh.cutDownNeeded, "If the index fields to iter mapping is of of size 1 then cut down cannot occur");
            indexFieldToItrsMapping[0].setCurrent(value);
        } else {
            Struct struct = (Struct)value;
            Object[] fieldValues = struct.getFieldValues();
            int size = fieldValues.length;
            Object[] checkFields = null;
            if (icdeh.cutDownNeeded) {
                checkFields = new Object[icdeh.checkSize];
            }
            int j = 0;
            RuntimeIterator rItr = null;
            for (int i = 0; i < size; ++i) {
                rItr = indexFieldToItrsMapping[i];
                if (rItr == null) continue;
                rItr.setCurrent(fieldValues[i]);
                if (!icdeh.cutDownNeeded) continue;
                checkFields[j++] = fieldValues[i];
            }
            if (icdeh.cutDownNeeded) {
                Object temp = null;
                temp = icdeh.checkSize == 1 ? checkFields[0] : new StructImpl((StructTypeImpl)icdeh.checkType, checkFields);
                if (icdeh.checkSet.contains(temp)) {
                    select = false;
                } else {
                    icdeh.checkSet.add(temp);
                }
            }
        }
        return select;
    }

    private static SelectResults cutDownAndExpandIndexResults(SelectResults result, RuntimeIterator[] indexFieldToItrsMapping, List expansionList, List finalItrs, ExecutionContext context, List checkList, CompiledValue iterOps, IndexInfo theFilteringIndex) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        boolean useLinkedDataStructure = false;
        boolean nullValuesAtStart = true;
        Boolean orderByClause = (Boolean)context.cacheGet("can_apply_orderby_at_index");
        if (orderByClause != null && orderByClause.booleanValue()) {
            List orderByAttrs = (List)context.cacheGet("orderby");
            useLinkedDataStructure = orderByAttrs.size() == 1;
            nullValuesAtStart = !((CompiledSortCriterion)orderByAttrs.get(0)).getCriterion();
        }
        Collection returnSet = null;
        if (finalItrs.size() == 1) {
            ObjectType resultType = ((RuntimeIterator)finalItrs.iterator().next()).getElementType();
            returnSet = useLinkedDataStructure ? (context.isDistinct() ? new LinkedResultSet(resultType) : new SortedResultsBag(resultType, nullValuesAtStart)) : QueryUtils.createResultCollection(context, resultType);
        } else {
            StructTypeImpl resultType = (StructTypeImpl)QueryUtils.createStructTypeForRuntimeIterators(finalItrs);
            returnSet = useLinkedDataStructure ? (context.isDistinct() ? new LinkedStructSet(resultType) : new SortedResultsBag((ObjectType)resultType, nullValuesAtStart)) : QueryUtils.createStructCollection(context, resultType);
        }
        QueryUtils.cutDownAndExpandIndexResults(returnSet, result, indexFieldToItrsMapping, expansionList, finalItrs, context, checkList, iterOps, theFilteringIndex);
        return returnSet;
    }

    private static void cutDownAndExpandIndexResults(SelectResults returnSet, SelectResults result, RuntimeIterator[] indexFieldToItrsMapping, List expansionList, List finalItrs, ExecutionContext context, List checkList, CompiledValue iterOps, IndexInfo theFilteringIndex) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        IndexCutDownExpansionHelper icdeh = new IndexCutDownExpansionHelper(checkList, context);
        int len = indexFieldToItrsMapping.length;
        if (result.getClass() == ResultsBag.class) {
            Support.Assert(len == 1, "The array size of iterators should be 1 here, but got " + len);
        }
        Iterator itr = result.iterator();
        ListIterator expansionListIterator = expansionList.listIterator();
        int limit = QueryUtils.getLimitValue(context);
        while (itr.hasNext()) {
            Object value;
            DerivedInfo derivedInfo = null;
            if (IndexManager.JOIN_OPTIMIZATION) {
                derivedInfo = new DerivedInfo();
                derivedInfo.setExpansionList(expansionList);
            }
            if (!QueryUtils.setIndexFieldValuesInRespectiveIterators(value = itr.next(), indexFieldToItrsMapping, icdeh)) continue;
            if (IndexManager.JOIN_OPTIMIZATION) {
                derivedInfo.computeDerivedJoinResults(theFilteringIndex, context, iterOps);
            }
            QueryUtils.doNestedIterationsForIndex(expansionListIterator.hasNext(), returnSet, finalItrs, expansionListIterator, context, iterOps, limit, derivedInfo.derivedResults);
            if (limit == -1 || returnSet.size() < limit) continue;
            break;
        }
    }

    private static int getLimitValue(ExecutionContext context) {
        int limit = -1;
        if (context.cacheGet("orderby") == null) {
            limit = context.cacheGet("limit") != null ? (Integer)context.cacheGet("limit") : -1;
        }
        return limit;
    }

    static CompiledID getCompiledIdFromPath(CompiledValue path) {
        int type = path.getType();
        if (type == 35) {
            return (CompiledID)path;
        }
        return QueryUtils.getCompiledIdFromPath(path.getReceiver());
    }

    private static void doNestedIterationsForIndex(boolean continueRecursion, SelectResults resultSet, List finalItrs, ListIterator expansionItrs, ExecutionContext context, CompiledValue iterOps, int limit, Map<String, SelectResults> derivedResults) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        if (!continueRecursion) {
            Iterator itr = finalItrs.iterator();
            int len = finalItrs.size();
            boolean select = true;
            if (iterOps != null) {
                select = QueryUtils.applyCondition(iterOps, context);
            }
            if (len > 1) {
                boolean isOrdered = resultSet.getCollectionType().isOrdered();
                StructTypeImpl elementType = (StructTypeImpl)resultSet.getCollectionType().getElementType();
                Object[] values = new Object[len];
                int j = 0;
                while (itr.hasNext()) {
                    QueryMonitor.throwExceptionIfQueryOnCurrentThreadIsCanceled();
                    values[j++] = ((RuntimeIterator)itr.next()).evaluate(context);
                }
                if (select) {
                    if (isOrdered) {
                        resultSet.add(new StructImpl(elementType, values));
                    } else {
                        ((StructFields)((Object)resultSet)).addFieldValues(values);
                    }
                }
            } else if (select) {
                resultSet.add(((RuntimeIterator)itr.next()).evaluate(context));
            }
        } else {
            RuntimeIterator currentLevel = (RuntimeIterator)expansionItrs.next();
            String key = null;
            boolean useDerivedResults = true;
            if (currentLevel.getCmpIteratorDefn().getCollectionExpr().getType() == 36) {
                key = currentLevel.getCmpIteratorDefn().getName() + ":" + currentLevel.getDefinition();
            } else if (currentLevel.getCmpIteratorDefn().getCollectionExpr().getType() == 74) {
                useDerivedResults = false;
            }
            CompiledValue path = currentLevel.getCmpIteratorDefn().getCollectionExpr();
            SelectResults c = useDerivedResults && derivedResults != null && path.hasIdentifierAtLeafNode() ? (derivedResults.containsKey(key = QueryUtils.getCompiledIdFromPath(path).getId() + ":" + currentLevel.getDefinition()) ? derivedResults.get(key) : currentLevel.evaluateCollection(context)) : (useDerivedResults && derivedResults != null && key != null && derivedResults.containsKey(key) ? derivedResults.get(key) : currentLevel.evaluateCollection(context));
            if (c == null) {
                expansionItrs.previous();
                return;
            }
            for (Object aC : c) {
                QueryMonitor.throwExceptionIfQueryOnCurrentThreadIsCanceled();
                currentLevel.setCurrent(aC);
                QueryUtils.doNestedIterationsForIndex(expansionItrs.hasNext(), resultSet, finalItrs, expansionItrs, context, iterOps, limit, derivedResults);
                if (limit == -1 || resultSet.size() < limit) continue;
                break;
            }
            expansionItrs.previous();
        }
    }

    static CompiledValue obtainTheBottomMostCompiledValue(CompiledValue expr) {
        boolean toContinue = true;
        int exprType = expr.getType();
        while (toContinue) {
            switch (exprType) {
                case 36: {
                    toContinue = false;
                    break;
                }
                case 54: {
                    CompiledOperation operation = (CompiledOperation)expr;
                    expr = operation.getReceiver(null);
                    if (expr != null) break;
                    expr = operation;
                    toContinue = false;
                    break;
                }
                case -5: {
                    expr = expr.getReceiver();
                    break;
                }
                case 24: {
                    expr = expr.getReceiver();
                    break;
                }
                default: {
                    toContinue = false;
                }
            }
            if (!toContinue) continue;
            exprType = expr.getType();
        }
        return expr;
    }

    static StructType createStructTypeForRuntimeIterators(List runTimeIterators) {
        int len = runTimeIterators.size();
        String[] fieldNames = new String[len];
        String[] indexAlternativeFieldNames = new String[len];
        ObjectType[] fieldTypes = new ObjectType[len];
        Iterator itr = runTimeIterators.iterator();
        int i = 0;
        while (itr.hasNext()) {
            RuntimeIterator iter = (RuntimeIterator)itr.next();
            fieldNames[i] = iter.getInternalId();
            indexAlternativeFieldNames[i] = iter.getIndexInternalID();
            fieldTypes[i++] = iter.getElementType();
        }
        return new StructTypeImpl(fieldNames, indexAlternativeFieldNames, fieldTypes);
    }

    static Set getCurrentScopeUltimateRuntimeIteratorsIfAny(CompiledValue compiledValue, ExecutionContext context) {
        HashSet<RuntimeIterator> set = new HashSet<RuntimeIterator>();
        context.computeUltimateDependencies(compiledValue, set);
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            RuntimeIterator rIter = (RuntimeIterator)iter.next();
            if (rIter.getScopeID() == context.currentScope().getScopeID()) continue;
            iter.remove();
        }
        return set;
    }

    static IndexData[] getRelationshipIndexIfAny(CompiledValue lhs, CompiledValue rhs, ExecutionContext context, int operator) throws TypeMismatchException, NameResolutionException {
        if (operator != 13) {
            return null;
        }
        IndexData lhsIndxData = QueryUtils.getAvailableIndexIfAny(lhs, context, false);
        if (lhsIndxData == null) {
            return null;
        }
        IndexData rhsIndxData = QueryUtils.getAvailableIndexIfAny(rhs, context, false);
        if (rhsIndxData == null) {
            IndexProtocol index = lhsIndxData.getIndex();
            Index prIndex = ((AbstractIndex)index).getPRIndex();
            if (prIndex != null) {
                ((PartitionedIndex)prIndex).releaseIndexReadLockForRemove();
            } else {
                ((AbstractIndex)index).releaseIndexReadLockForRemove();
            }
            return null;
        }
        IndexProtocol lhsIndx = lhsIndxData.getIndex();
        IndexProtocol rhsIndx = rhsIndxData.getIndex();
        if (lhsIndx.isValid() && rhsIndx.isValid()) {
            return new IndexData[]{lhsIndxData, rhsIndxData};
        }
        return null;
    }

    static IndexData getAvailableIndexIfAny(CompiledValue cv, ExecutionContext context, int operator) throws TypeMismatchException, NameResolutionException {
        boolean usePrimaryIndex = operator == 13 || operator == 20;
        return QueryUtils.getAvailableIndexIfAny(cv, context, usePrimaryIndex);
    }

    private static IndexData getAvailableIndexIfAny(CompiledValue cv, ExecutionContext context, boolean usePrimaryIndex) throws TypeMismatchException, NameResolutionException {
        HashSet<RuntimeIterator> set = new HashSet<RuntimeIterator>();
        context.computeUltimateDependencies(cv, set);
        if (set.size() != 1) {
            return null;
        }
        RuntimeIterator rIter = (RuntimeIterator)set.iterator().next();
        String regionPath = null;
        if (rIter.getScopeID() != context.currentScope().getScopeID() || (regionPath = context.getRegionPathForIndependentRuntimeIterator(rIter)) == null) {
            return null;
        }
        List groupRuntimeItrs = context.getCurrScopeDpndntItrsBasedOnSingleIndpndntItr(rIter);
        String[] definitions = new String[groupRuntimeItrs.size()];
        Iterator iterator = groupRuntimeItrs.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            RuntimeIterator rIterator = (RuntimeIterator)iterator.next();
            definitions[i++] = rIterator.getDefinition();
        }
        IndexData indexData = IndexUtils.findIndex(regionPath, definitions, cv, "*", context.getCache(), usePrimaryIndex, context);
        if (indexData != null && logger.isDebugEnabled()) {
            logger.debug("Indexed expression for indexed data : {}  for region : {}", (Object)indexData.getIndex().getCanonicalizedIndexedExpression(), (Object)regionPath);
        }
        return indexData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SelectResults getConditionedIndexResults(SelectResults indexResults, IndexInfo indexInfo, ExecutionContext context, int indexFieldsSize, boolean completeExpansion, CompiledValue iterOperands, RuntimeIterator[] grpIndpndntItr) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        if (!completeExpansion && grpIndpndntItr != null && grpIndpndntItr.length > 1) {
            IndexConditioningHelper ich = new IndexConditioningHelper(indexInfo, context, indexFieldsSize, completeExpansion, iterOperands, null);
            ich.finalList = QueryUtils.getDependentItrChainForIndpndntItrs(grpIndpndntItr, context);
            ArrayList newExpList = new ArrayList();
            int len = grpIndpndntItr.length;
            RuntimeIterator tempItr = null;
            for (RuntimeIterator aGrpIndpndntItr : grpIndpndntItr) {
                tempItr = aGrpIndpndntItr;
                if (tempItr == ich.indpndntItr) continue;
                newExpList.addAll(context.getCurrScopeDpndntItrsBasedOnSingleIndpndntItr(tempItr));
            }
            newExpList.addAll(ich.expansionList);
            ich.expansionList = newExpList;
            QueryObserver observer = QueryObserverHolder.getInstance();
            try {
                observer.beforeCutDownAndExpansionOfSingleIndexResult(indexInfo._index, indexResults);
                indexResults = QueryUtils.cutDownAndExpandIndexResults(indexResults, ich.indexFieldToItrsMapping, ich.expansionList, ich.finalList, context, ich.checkList, iterOperands, indexInfo);
            }
            finally {
                observer.afterCutDownAndExpansionOfSingleIndexResult(indexResults);
            }
        } else {
            IndexConditioningHelper ich = new IndexConditioningHelper(indexInfo, context, indexFieldsSize, completeExpansion, iterOperands, grpIndpndntItr != null ? grpIndpndntItr[0] : null);
            if (ich.shufflingNeeded) {
                QueryObserver observer = QueryObserverHolder.getInstance();
                try {
                    observer.beforeCutDownAndExpansionOfSingleIndexResult(indexInfo._index, indexResults);
                    indexResults = QueryUtils.cutDownAndExpandIndexResults(indexResults, ich.indexFieldToItrsMapping, ich.expansionList, ich.finalList, context, ich.checkList, iterOperands, indexInfo);
                }
                finally {
                    observer.afterCutDownAndExpansionOfSingleIndexResult(indexResults);
                }
            } else if (indexInfo.mapping.length > 1) {
                indexResults.setElementType(ich.structType);
            }
        }
        return indexResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SelectResults getRelationshipIndexResultsMergedWithIntermediateResults(SelectResults intermediateResults, IndexInfo[] indxInfo, ExecutionContext context, boolean completeExpansionNeeded, CompiledValue iterOperands, RuntimeIterator[] indpdntItrs) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        CompiledComparison reconstructedVal;
        ObjectType resultType1 = indxInfo[0]._index.getResultSetType();
        int indexFieldsSize1 = resultType1 instanceof StructType ? ((StructTypeImpl)resultType1).getFieldNames().length : 1;
        ObjectType resultType2 = indxInfo[1]._index.getResultSetType();
        int indexFieldsSize2 = resultType2 instanceof StructType ? ((StructTypeImpl)resultType2).getFieldNames().length : 1;
        IndexConditioningHelper ich1 = new IndexConditioningHelper(indxInfo[0], context, indexFieldsSize1, false, iterOperands, null);
        IndexConditioningHelper ich2 = new IndexConditioningHelper(indxInfo[1], context, indexFieldsSize2, false, iterOperands, null);
        int noOfIndexesToUse = intermediateResults == null || intermediateResults.isEmpty() ? 2 : 0;
        RuntimeIterator[] resultFieldsItrMapping = null;
        ArrayList allItrs = context.getCurrentIterators();
        IndexConditioningHelper singleUsableICH = null;
        IndexConditioningHelper nonUsableICH = null;
        ArrayList finalList = completeExpansionNeeded ? allItrs : (indpdntItrs == null ? new ArrayList() : null);
        HashSet<RuntimeIterator> expnItrsToIgnore = null;
        if (noOfIndexesToUse == 0) {
            noOfIndexesToUse = 2;
            StructType stype = (StructType)intermediateResults.getCollectionType().getElementType();
            String[] fieldNames = stype.getFieldNames();
            int len = fieldNames.length;
            resultFieldsItrMapping = new RuntimeIterator[len];
            String fieldName = null;
            String lhsID = ich1.indpndntItr.getInternalId();
            String rhsID = ich2.indpndntItr.getInternalId();
            for (int i = 0; i < len; ++i) {
                RuntimeIterator itrPrsntInIntermdtRes;
                fieldName = fieldNames[i];
                if (noOfIndexesToUse != 0) {
                    if (fieldName.equals(lhsID)) {
                        --noOfIndexesToUse;
                        singleUsableICH = ich2;
                        nonUsableICH = ich1;
                    } else if (fieldName.equals(rhsID)) {
                        --noOfIndexesToUse;
                        singleUsableICH = ich1;
                        nonUsableICH = ich2;
                    }
                }
                int pos = Integer.parseInt(fieldName.substring(4));
                resultFieldsItrMapping[i] = itrPrsntInIntermdtRes = (RuntimeIterator)allItrs.get(pos - 1);
                if (completeExpansionNeeded) {
                    if (expnItrsToIgnore == null) {
                        expnItrsToIgnore = new HashSet<RuntimeIterator>();
                    }
                    expnItrsToIgnore.add(itrPrsntInIntermdtRes);
                    continue;
                }
                if (indpdntItrs != null) continue;
                finalList.add(itrPrsntInIntermdtRes);
            }
            if (noOfIndexesToUse == 0) {
                singleUsableICH = null;
            }
        }
        QueryObserver observer = QueryObserverHolder.getInstance();
        if (noOfIndexesToUse == 2) {
            List data = null;
            try {
                ArrayList resultData = new ArrayList();
                observer.beforeIndexLookup(indxInfo[0]._index, 13, null);
                observer.beforeIndexLookup(indxInfo[1]._index, 13, null);
                data = context.getBucketList() != null ? QueryUtils.queryEquijoinConditionBucketIndexes(indxInfo, context) : indxInfo[0]._index.queryEquijoinCondition(indxInfo[1]._index, context);
                observer.afterIndexLookup(data);
            }
            catch (Throwable throwable) {
                observer.afterIndexLookup(data);
                throw throwable;
            }
            ArrayList<RuntimeIterator> totalExpList = new ArrayList<RuntimeIterator>();
            totalExpList.addAll(ich1.expansionList);
            totalExpList.addAll(ich2.expansionList);
            if (completeExpansionNeeded) {
                if (expnItrsToIgnore == null) {
                    Support.Assert(intermediateResults == null || intermediateResults.isEmpty(), "expnItrsToIgnore should not have been null if the intermediate result set is not empty");
                    expnItrsToIgnore = new HashSet();
                }
                expnItrsToIgnore.addAll(ich1.finalList);
                expnItrsToIgnore.addAll(ich2.finalList);
                int size = finalList.size();
                for (Object o : finalList) {
                    RuntimeIterator currItr = (RuntimeIterator)o;
                    if (expnItrsToIgnore.contains(currItr)) continue;
                    totalExpList.add(currItr);
                }
            } else if (indpdntItrs != null) {
                finalList = QueryUtils.getDependentItrChainForIndpndntItrs(indpdntItrs, context);
            } else {
                finalList.addAll(ich1.finalList);
                finalList.addAll(ich2.finalList);
            }
            List[] checkList = new List[]{ich1.checkList, ich2.checkList};
            StructType stype = QueryUtils.createStructTypeForRuntimeIterators(finalList);
            SelectResults returnSet = QueryUtils.createStructCollection(context, stype);
            RuntimeIterator[][] mappings = new RuntimeIterator[][]{ich1.indexFieldToItrsMapping, ich2.indexFieldToItrsMapping};
            List[] totalCheckList = new List[]{ich1.checkList, ich2.checkList};
            RuntimeIterator[][] resultMappings = new RuntimeIterator[][]{resultFieldsItrMapping};
            Iterator dataItr = data.iterator();
            IndexCutDownExpansionHelper[] icdeh = new IndexCutDownExpansionHelper[]{new IndexCutDownExpansionHelper(ich1.checkList, context), new IndexCutDownExpansionHelper(ich2.checkList, context)};
            ListIterator expansionListIterator = totalExpList.listIterator();
            if (dataItr.hasNext()) {
                observer = QueryObserverHolder.getInstance();
                try {
                    observer.beforeMergeJoinOfDoubleIndexResults(indxInfo[0]._index, indxInfo[1]._index, data);
                    boolean doMergeWithIntermediateResults = intermediateResults != null && !intermediateResults.isEmpty();
                    int maxCartesianDepth = totalExpList.size() + (doMergeWithIntermediateResults ? 1 : 0);
                    while (dataItr.hasNext()) {
                        Object[][] values = (Object[][])dataItr.next();
                        if (doMergeWithIntermediateResults) {
                            QueryUtils.mergeRelationshipIndexResultsWithIntermediateResults(returnSet, new SelectResults[]{intermediateResults}, resultMappings, values, mappings, expansionListIterator, finalList, context, checkList, iterOperands, icdeh, 0, maxCartesianDepth);
                        } else {
                            QueryUtils.mergeAndExpandCutDownRelationshipIndexResults(values, returnSet, mappings, expansionListIterator, finalList, context, iterOperands, icdeh, 0);
                        }
                        if (!icdeh[0].cutDownNeeded) continue;
                        icdeh[0].checkSet.clear();
                    }
                }
                finally {
                    observer.afterMergeJoinOfDoubleIndexResults(returnSet);
                }
            }
            return returnSet;
        }
        if (noOfIndexesToUse == 1) {
            ArrayList<RuntimeIterator> totalExpList = new ArrayList<RuntimeIterator>(singleUsableICH.expansionList);
            if (completeExpansionNeeded) {
                Support.Assert(expnItrsToIgnore != null, "expnItrsToIgnore should not have been null as we are in this block itself indicates that intermediate results was not null");
                expnItrsToIgnore.addAll(singleUsableICH.finalList);
                int size = finalList.size();
                for (Object o : finalList) {
                    RuntimeIterator currItr = (RuntimeIterator)o;
                    if (expnItrsToIgnore.contains(currItr)) continue;
                    totalExpList.add(currItr);
                }
            } else if (indpdntItrs != null) {
                finalList = QueryUtils.getDependentItrChainForIndpndntItrs(indpdntItrs, context);
            } else {
                finalList.addAll(singleUsableICH.finalList);
            }
            StructType stype = QueryUtils.createStructTypeForRuntimeIterators(finalList);
            SelectResults returnSet = QueryUtils.createStructCollection(context, stype);
            IndexProtocol singleUsblIndex = singleUsableICH.indxInfo._index;
            CompiledValue nonUsblIndxPath = nonUsableICH.indxInfo._path;
            ObjectType singlUsblIndxResType = singleUsblIndex.getResultSetType();
            SelectResults singlUsblIndxRes = null;
            singlUsblIndxRes = singlUsblIndxResType instanceof StructType ? QueryUtils.createStructCollection(context, (StructTypeImpl)singlUsblIndxResType) : QueryUtils.createResultCollection(context, singlUsblIndxResType);
            Iterator intrmdtRsItr = intermediateResults.iterator();
            observer = QueryObserverHolder.getInstance();
            try {
                observer.beforeIndexLookup(singleUsblIndex, 13, null);
                observer.beforeIterJoinOfSingleIndexResults(singleUsblIndex, nonUsableICH.indxInfo._index);
                while (intrmdtRsItr.hasNext()) {
                    Struct strc = (Struct)intrmdtRsItr.next();
                    Object[] val = strc.getFieldValues();
                    int len = val.length;
                    for (int i = 0; i < len; ++i) {
                        resultFieldsItrMapping[i].setCurrent(val[i]);
                    }
                    Object key = nonUsblIndxPath.evaluate(context);
                    if (key != null && key.equals(QueryService.UNDEFINED)) continue;
                    singleUsblIndex.query(key, 13, singlUsblIndxRes, context);
                    QueryUtils.cutDownAndExpandIndexResults(returnSet, singlUsblIndxRes, singleUsableICH.indexFieldToItrsMapping, totalExpList, finalList, context, singleUsableICH.checkList, iterOperands, singleUsableICH.indxInfo);
                    singlUsblIndxRes.clear();
                }
            }
            finally {
                observer.afterIterJoinOfSingleIndexResults(returnSet);
                observer.afterIndexLookup(returnSet);
            }
            return returnSet;
        }
        if (logger.isDebugEnabled()) {
            StringBuilder tempBuffLhs = new StringBuilder();
            StringBuilder tempBuffRhs = new StringBuilder();
            ich1.indxInfo._path.generateCanonicalizedExpression(tempBuffLhs, context);
            ich2.indxInfo._path.generateCanonicalizedExpression(tempBuffRhs, context);
            logger.debug("For better performance indexes are not used for the condition {} = {}", (Object)tempBuffLhs, (Object)tempBuffRhs);
        }
        AbstractCompiledValue finalVal = reconstructedVal = new CompiledComparison(ich1.indxInfo._path, ich2.indxInfo._path, 13);
        if (iterOperands != null) {
            finalVal = new CompiledJunction(new CompiledValue[]{iterOperands, reconstructedVal}, 91);
        }
        RuntimeIterator[][] resultMappings = new RuntimeIterator[][]{resultFieldsItrMapping};
        return QueryUtils.cartesian(new SelectResults[]{intermediateResults}, resultMappings, Collections.emptyList(), finalList, context, finalVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SelectResults getConditionedRelationshipIndexResultsExpandedToTopOrCGJLevel(List data, IndexInfo[] indxInfo, ExecutionContext context, boolean completeExpansionNeeded, CompiledValue iterOperands, RuntimeIterator[] indpdntItrs) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        ObjectType resultType1 = indxInfo[0]._index.getResultSetType();
        int indexFieldsSize1 = resultType1 instanceof StructType ? ((StructTypeImpl)resultType1).getFieldNames().length : 1;
        ObjectType resultType2 = indxInfo[1]._index.getResultSetType();
        int indexFieldsSize2 = resultType2 instanceof StructType ? ((StructTypeImpl)resultType2).getFieldNames().length : 1;
        IndexConditioningHelper ich1 = new IndexConditioningHelper(indxInfo[0], context, indexFieldsSize1, false, iterOperands, null);
        IndexConditioningHelper ich2 = new IndexConditioningHelper(indxInfo[1], context, indexFieldsSize2, false, iterOperands, null);
        ArrayList<RuntimeIterator> totalExpList = new ArrayList<RuntimeIterator>();
        totalExpList.addAll(ich1.expansionList);
        totalExpList.addAll(ich2.expansionList);
        ArrayList totalFinalList = null;
        if (completeExpansionNeeded) {
            totalFinalList = context.getCurrentIterators();
            HashSet expnItrsAlreadyAccounted = new HashSet();
            expnItrsAlreadyAccounted.addAll(ich1.finalList);
            expnItrsAlreadyAccounted.addAll(ich2.finalList);
            int size = totalFinalList.size();
            for (Object o : totalFinalList) {
                RuntimeIterator currItr = (RuntimeIterator)o;
                if (expnItrsAlreadyAccounted.contains(currItr)) continue;
                totalExpList.add(currItr);
            }
        } else {
            totalFinalList = new ArrayList();
            for (RuntimeIterator indpndntItr : indpdntItrs) {
                if (indpndntItr == ich1.finalList.get(0)) {
                    totalFinalList.addAll(ich1.finalList);
                    continue;
                }
                if (indpndntItr == ich2.finalList.get(0)) {
                    totalFinalList.addAll(ich2.finalList);
                    continue;
                }
                List temp = context.getCurrScopeDpndntItrsBasedOnSingleIndpndntItr(indpndntItr);
                totalFinalList.addAll(temp);
                totalExpList.addAll(temp);
            }
        }
        StructType stype = QueryUtils.createStructTypeForRuntimeIterators(totalFinalList);
        SelectResults returnSet = totalFinalList.size() == 1 ? QueryUtils.createResultCollection(context, new ObjectTypeImpl(stype.getClass())) : QueryUtils.createStructCollection(context, stype);
        RuntimeIterator[][] mappings = new RuntimeIterator[][]{ich1.indexFieldToItrsMapping, ich2.indexFieldToItrsMapping};
        Iterator dataItr = data.iterator();
        IndexCutDownExpansionHelper[] icdeh = new IndexCutDownExpansionHelper[]{new IndexCutDownExpansionHelper(ich1.checkList, context), new IndexCutDownExpansionHelper(ich2.checkList, context)};
        ListIterator expansionListIterator = totalExpList.listIterator();
        if (dataItr.hasNext()) {
            QueryObserver observer = QueryObserverHolder.getInstance();
            try {
                observer.beforeMergeJoinOfDoubleIndexResults(ich1.indxInfo._index, ich2.indxInfo._index, data);
                while (dataItr.hasNext()) {
                    Object[][] values = (Object[][])dataItr.next();
                    QueryUtils.mergeAndExpandCutDownRelationshipIndexResults(values, returnSet, mappings, expansionListIterator, totalFinalList, context, iterOperands, icdeh, 0);
                    if (!icdeh[0].cutDownNeeded) continue;
                    icdeh[0].checkSet.clear();
                }
            }
            finally {
                observer.afterMergeJoinOfDoubleIndexResults(returnSet);
            }
        }
        return returnSet;
    }

    static SelectResults testCutDownAndExpandIndexResults(List dataList) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        return QueryUtils.cutDownAndExpandIndexResults((SelectResults)dataList.get(0), (RuntimeIterator[])dataList.get(1), (List)dataList.get(2), (List)dataList.get(3), (ExecutionContext)dataList.get(4), (List)dataList.get(5), null, null);
    }

    static List queryEquijoinConditionBucketIndexes(IndexInfo[] indxInfo, ExecutionContext context) throws QueryInvocationTargetException, TypeMismatchException, FunctionDomainException, NameResolutionException {
        ArrayList resultData = new ArrayList();
        AbstractIndex index0 = (AbstractIndex)indxInfo[0]._index;
        AbstractIndex index1 = (AbstractIndex)indxInfo[1]._index;
        PartitionedRegion pr0 = null;
        if (index0.getRegion() instanceof BucketRegion) {
            pr0 = ((Bucket)((Object)index0.getRegion())).getPartitionedRegion();
        }
        PartitionedRegion pr1 = null;
        if (index1.getRegion() instanceof BucketRegion) {
            pr1 = ((Bucket)((Object)index1.getRegion())).getPartitionedRegion();
        }
        List data = null;
        IndexProtocol i0 = null;
        IndexProtocol i1 = null;
        for (Object b : context.getBucketList()) {
            i0 = pr0 != null ? PartitionedIndex.getBucketIndex(pr0, index0.getName(), (Integer)b) : indxInfo[0]._index;
            IndexProtocol indexProtocol = i1 = pr1 != null ? PartitionedIndex.getBucketIndex(pr1, index1.getName(), (Integer)b) : indxInfo[1]._index;
            if (i0 == null || i1 == null) continue;
            data = i0.queryEquijoinCondition(i1, context);
            resultData.addAll(data);
        }
        data = resultData;
        return data;
    }
}

