/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.configuration;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.annotations.internal.MakeImmutable;
import org.apache.geode.cache.configuration.ClassNameType;
import org.apache.geode.cache.configuration.ParameterType;
import org.apache.geode.management.configuration.ClassName;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="declarable-type", namespace="http://geode.apache.org/schema/cache", propOrder={"parameters"})
@Experimental
public class DeclarableType
extends ClassNameType
implements Serializable {
    @XmlElement(name="parameter", namespace="http://geode.apache.org/schema/cache")
    protected List<ParameterType> parameters;
    @MakeImmutable
    public static final DeclarableType EMPTY = new DeclarableType("");

    public DeclarableType() {
    }

    public DeclarableType(String className) {
        this(className, (Properties)null);
    }

    public DeclarableType(String className, String jsonProperties) {
        this(className, new ClassName(className, jsonProperties).getInitProperties());
    }

    public DeclarableType(String className, Properties properties) {
        if (StringUtils.isBlank((CharSequence)className)) {
            return;
        }
        this.className = className;
        this.setParameters(properties);
    }

    public List<ParameterType> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ArrayList<ParameterType>();
        }
        return this.parameters;
    }

    public void setParameters(Properties properties) {
        if (properties == null) {
            this.parameters = null;
            return;
        }
        this.parameters = properties.stringPropertyNames().stream().map(k -> new ParameterType((String)k, properties.getProperty((String)k))).collect(Collectors.toList());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeclarableType that = (DeclarableType)o;
        return Objects.equals(this.className, that.className) && Objects.equals(this.parameters, that.parameters);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.className, this.parameters);
    }

    @Override
    public String toString() {
        if (this.parameters == null) {
            return this.className;
        }
        return this.className + "{" + this.parameters.stream().map(Objects::toString).collect(Collectors.joining(",")) + "}";
    }
}

