/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal.locator;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.client.internal.locator.SerializationHelper;
import org.apache.geode.cache.client.internal.locator.ServerLocationResponse;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public class QueueConnectionResponse
extends ServerLocationResponse {
    private boolean durableQueueFound;
    private List<ServerLocation> servers;
    private boolean serversFound = false;

    public QueueConnectionResponse() {
    }

    public QueueConnectionResponse(boolean durableQueueFound, List<ServerLocation> servers) {
        this.durableQueueFound = durableQueueFound;
        this.servers = servers;
        if (servers != null && !servers.isEmpty()) {
            this.serversFound = true;
        }
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        this.durableQueueFound = DataSerializer.readPrimitiveBoolean(in);
        this.servers = SerializationHelper.readServerLocationList(in);
        if (this.servers != null && !this.servers.isEmpty()) {
            this.serversFound = true;
        }
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        DataSerializer.writePrimitiveBoolean(this.durableQueueFound, out);
        SerializationHelper.writeServerLocationList(this.servers, out);
    }

    public boolean isDurableQueueFound() {
        return this.durableQueueFound;
    }

    public List<ServerLocation> getServers() {
        return this.servers;
    }

    public String toString() {
        return "QueueConnectionResponse{durableQueueFound=" + this.durableQueueFound + ", servers=" + String.valueOf(this.servers) + "}";
    }

    public int getDSFID() {
        return -49;
    }

    @Override
    public boolean hasResult() {
        return this.serversFound;
    }
}

