/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal.locator;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.client.internal.locator.SerializationHelper;
import org.apache.geode.cache.client.internal.locator.ServerLocationRequest;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public class QueueConnectionRequest
extends ServerLocationRequest {
    private ClientProxyMembershipID proxyId;
    private Set excludedServers;
    private int redundantCopies;
    private boolean findDurable = false;

    public QueueConnectionRequest() {
    }

    public QueueConnectionRequest(ClientProxyMembershipID proxyId, int redundantCopies, Set excludedServers, String serverGroup, boolean findDurable) {
        super(serverGroup);
        this.proxyId = proxyId;
        this.excludedServers = excludedServers;
        this.redundantCopies = redundantCopies;
        this.findDurable = findDurable;
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.proxyId = ClientProxyMembershipID.readCanonicalized(in);
        this.redundantCopies = DataSerializer.readPrimitiveInt(in);
        this.excludedServers = SerializationHelper.readServerLocationSet(in);
        this.findDurable = in.readBoolean();
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        context.getSerializer().writeObject((Object)this.proxyId, out);
        DataSerializer.writePrimitiveInt(this.redundantCopies, out);
        SerializationHelper.writeServerLocationSet(this.excludedServers, out);
        out.writeBoolean(this.findDurable);
    }

    public Set getExcludedServers() {
        return this.excludedServers;
    }

    public ClientProxyMembershipID getProxyId() {
        return this.proxyId;
    }

    public int getRedundantCopies() {
        return this.redundantCopies;
    }

    public boolean isFindDurable() {
        return this.findDurable;
    }

    public String toString() {
        return "QueueConnectionRequest{group=" + this.getServerGroup() + ", excluded=" + String.valueOf(this.getExcludedServers()) + ", redundant= " + this.redundantCopies + ",findDurable=" + this.findDurable + ",proxyId=" + String.valueOf(this.proxyId) + "}";
    }

    public int getDSFID() {
        return -52;
    }
}

