/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.distributed.internal.tcpserver.HostAndPort;
import org.jetbrains.annotations.NotNull;

class LocatorList
implements Iterable<HostAndPort> {
    @Immutable
    static final Comparator<@NotNull HostAndPort> SOCKET_ADDRESS_COMPARATOR = (address, otherAddress) -> {
        InetSocketAddress inetSocketAddress = address.getSocketInetAddress();
        InetSocketAddress otherInetSocketAddress = otherAddress.getSocketInetAddress();
        int result = StringUtils.compare((String)inetSocketAddress.getHostString(), (String)otherInetSocketAddress.getHostString());
        if (result != 0) {
            return result;
        }
        return Integer.compare(inetSocketAddress.getPort(), otherInetSocketAddress.getPort());
    };
    private final List<@NotNull HostAndPort> locators;
    private final AtomicInteger currentLocatorIndex = new AtomicInteger();

    public LocatorList(@NotNull @NotNull List<@NotNull HostAndPort> locators) {
        locators.sort(SOCKET_ADDRESS_COMPARATOR);
        this.locators = Collections.unmodifiableList(locators);
    }

    @NotNull
    public @NotNull List<@NotNull InetSocketAddress> getLocators() {
        ArrayList<@NotNull InetSocketAddress> addresses = new ArrayList<InetSocketAddress>(this.locators.size());
        for (HostAndPort locator : this.locators) {
            addresses.add(locator.getSocketInetAddress());
        }
        return addresses;
    }

    @NotNull
    public @NotNull List<@NotNull HostAndPort> getLocatorAddresses() {
        return this.locators;
    }

    public int size() {
        return this.locators.size();
    }

    @Override
    @NotNull
    public @NotNull Iterator<@NotNull HostAndPort> iterator() {
        return new LocatorIterator();
    }

    public String toString() {
        return this.locators.toString();
    }

    private class LocatorIterator
    implements Iterator<HostAndPort> {
        private final int lastKnownGoodIndex;
        private int currentIndex;

        private LocatorIterator() {
            this.lastKnownGoodIndex = LocatorList.this.currentLocatorIndex.get();
            this.currentIndex = 0;
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < LocatorList.this.locators.size();
        }

        @Override
        @NotNull
        public HostAndPort next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int index = (this.currentIndex + this.lastKnownGoodIndex) % LocatorList.this.locators.size();
            HostAndPort nextLocator = LocatorList.this.locators.get(index);
            LocatorList.this.currentLocatorIndex.set(index);
            ++this.currentIndex;
            return nextLocator;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

