/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.util.Properties;
import org.apache.geode.DataSerializer;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.client.ServerOperationException;
import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.ConnectionImpl;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.cache.client.internal.Op;
import org.apache.geode.cache.client.internal.UserAttributes;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.cache.tier.MessageType;
import org.apache.geode.internal.cache.tier.sockets.Handshake;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.serialization.ByteArrayDataInput;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.security.AuthenticationExpiredException;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.geode.security.AuthenticationRequiredException;
import org.apache.geode.security.NotAuthorizedException;
import org.jetbrains.annotations.NotNull;

public class AuthenticateUserOp {
    public static final long NOT_A_USER_ID = -1L;

    public static Long executeOn(Connection con, ExecutablePool pool) {
        AuthenticateUserOpImpl op = new AuthenticateUserOpImpl();
        return (Long)pool.executeOn(con, (Op)op);
    }

    public static Long executeOn(ServerLocation location, ExecutablePool pool) {
        AuthenticateUserOpImpl op = new AuthenticateUserOpImpl();
        return (Long)pool.executeOn(location, (Op)op);
    }

    public static Long executeOn(ServerLocation location, ExecutablePool pool, Properties securityProps) {
        AuthenticateUserOpImpl op = new AuthenticateUserOpImpl(securityProps);
        return (Long)pool.executeOn(location, (Op)op);
    }

    private AuthenticateUserOp() {
    }

    static class AuthenticateUserOpImpl
    extends AbstractOp {
        private Properties securityProperties = null;
        private boolean needsServerLocation = false;

        AuthenticateUserOpImpl() {
            super(77, 1);
            this.getMessage().setMessageHasSecurePartFlag();
        }

        AuthenticateUserOpImpl(Properties securityProps) {
            this(securityProps, false);
        }

        AuthenticateUserOpImpl(Properties securityProps, boolean needsServer) {
            super(77, 1);
            this.securityProperties = securityProps;
            this.needsServerLocation = needsServer;
            this.getMessage().setMessageHasSecurePartFlag();
        }

        @Override
        protected void sendMessage(Connection connection) throws Exception {
            if (this.securityProperties == null) {
                this.securityProperties = this.getConnectedSystem().getSecurityProperties();
            }
            byte[] credentialBytes = this.getCredentialBytes(connection, this.securityProperties);
            this.getMessage().addBytesPart(credentialBytes);
            try (HeapDataOutputStream hdos = new HeapDataOutputStream(16, KnownVersion.CURRENT);){
                hdos.writeLong(connection.getConnectionID());
                long userId = this.getUserId(connection);
                secureLogger.debug("AuthenticateUserOp with uniqueId {}", (Object)userId);
                hdos.writeLong(userId);
                this.getMessage().setSecurePart(((ConnectionImpl)connection).encryptBytes(hdos.toByteArray()));
            }
            this.getMessage().send(false);
        }

        protected long getUserId(Connection connection) {
            if (UserAttributes.userAttributes.get() == null) {
                return connection.getServer().getUserId();
            }
            Long id = UserAttributes.userAttributes.get().getServerToId().get(connection.getServer());
            if (id == null) {
                return -1L;
            }
            return id;
        }

        protected InternalDistributedSystem getConnectedSystem() {
            return InternalDistributedSystem.getConnectedInstance();
        }

        protected byte[] getCredentialBytes(Connection connection, Properties securityProperties) throws Exception {
            byte[] credentialBytes;
            InternalDistributedSystem distributedSystem = this.getConnectedSystem();
            InternalDistributedMember server = new InternalDistributedMember(connection.getSocket().getInetAddress(), connection.getSocket().getPort(), false);
            String authInitMethod = distributedSystem.getProperties().getProperty("security-client-auth-init");
            Properties credentials = Handshake.getCredentials(authInitMethod, securityProperties, server, false, distributedSystem.getLogWriter(), distributedSystem.getSecurityLogWriter());
            try (HeapDataOutputStream heapdos = new HeapDataOutputStream(KnownVersion.CURRENT);){
                DataSerializer.writeProperties(credentials, heapdos);
                credentialBytes = ((ConnectionImpl)connection).encryptBytes(heapdos.toByteArray());
            }
            return credentialBytes;
        }

        @Override
        public Object attempt(Connection connection) throws Exception {
            if (!connection.getServer().getRequiresCredentials()) {
                return null;
            }
            try {
                return this.parentAttempt(connection);
            }
            catch (AuthenticationExpiredException first) {
                this.getMessage().clear();
                try {
                    return this.parentAttempt(connection);
                }
                catch (AuthenticationExpiredException second) {
                    throw new AuthenticationFailedException(second.getMessage(), second);
                }
            }
        }

        @VisibleForTesting
        Object parentAttempt(Connection connection) throws Exception {
            return super.attempt(connection);
        }

        @Override
        protected Object processResponse(@NotNull Message msg, @NotNull Connection connection) throws Exception {
            Part part = msg.getPart(0);
            int msgType = msg.getMessageType();
            long userId = -1L;
            if (msgType == 1) {
                byte[] bytes = (byte[])part.getObject();
                if (bytes.length == 0) {
                    connection.getServer().setRequiresCredentials(false);
                } else {
                    connection.getServer().setRequiresCredentials(true);
                    byte[] decrypted = ((ConnectionImpl)connection).decryptBytes(bytes);
                    try (ByteArrayDataInput dis = new ByteArrayDataInput(decrypted);){
                        userId = dis.readLong();
                    }
                }
                if (this.needsServerLocation) {
                    return new Object[]{connection.getServer(), userId};
                }
                return userId;
            }
            if (msgType == 2) {
                Object result = part.getObject();
                String s = "While performing a remote authenticate";
                if (result instanceof AuthenticationFailedException) {
                    AuthenticationFailedException afe = (AuthenticationFailedException)result;
                    if ("REPLY_REFUSED".equals(afe.getMessage())) {
                        throw new AuthenticationFailedException(s, afe.getCause());
                    }
                    throw new AuthenticationFailedException(s, afe);
                }
                if (result instanceof AuthenticationExpiredException) {
                    throw (AuthenticationExpiredException)result;
                }
                if (result instanceof AuthenticationRequiredException) {
                    throw new AuthenticationRequiredException(s, (AuthenticationRequiredException)result);
                }
                if (result instanceof NotAuthorizedException) {
                    throw new NotAuthorizedException(s, (NotAuthorizedException)result);
                }
                throw new ServerOperationException(s, (Throwable)result);
            }
            if (this.isErrorResponse(msgType)) {
                throw new ServerOperationException(part.getString());
            }
            throw new InternalGemFireError("Unexpected message type " + MessageType.getString(msgType));
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return msgType == 3;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startGet();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endGetSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endGet(start, this.hasTimedOut(), this.hasFailed());
        }

        @Override
        protected Object processResponse(@NotNull Message msg) throws Exception {
            return null;
        }

        @Override
        protected boolean needsUserId() {
            return false;
        }
    }
}

