/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.CacheLoader;
import org.apache.geode.cache.CacheWriter;
import org.apache.geode.cache.CustomExpiry;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.DiskStoreFactory;
import org.apache.geode.cache.DiskWriteAttributes;
import org.apache.geode.cache.DiskWriteAttributesFactory;
import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.ExpirationAction;
import org.apache.geode.cache.ExpirationAttributes;
import org.apache.geode.cache.InterestPolicy;
import org.apache.geode.cache.MembershipAttributes;
import org.apache.geode.cache.MirrorType;
import org.apache.geode.cache.PartitionAttributes;
import org.apache.geode.cache.PartitionAttributesFactory;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.SubscriptionAttributes;
import org.apache.geode.compression.Compressor;
import org.apache.geode.internal.cache.AbstractRegion;
import org.apache.geode.internal.cache.DiskStoreAttributes;
import org.apache.geode.internal.cache.DiskStoreFactoryImpl;
import org.apache.geode.internal.cache.DiskWriteAttributesImpl;
import org.apache.geode.internal.cache.EvictionAttributesImpl;
import org.apache.geode.internal.cache.PartitionAttributesImpl;
import org.apache.geode.internal.cache.PartitionedRegionHelper;
import org.apache.geode.internal.cache.UserSpecifiedRegionAttributes;
import org.apache.geode.internal.cache.persistence.DefaultDiskDirs;
import org.apache.geode.internal.cache.xmlcache.RegionAttributesCreation;

@Deprecated
public class AttributesFactory<K, V> {
    private final RegionAttributesImpl<K, V> regionAttributes;
    public static final boolean DEFAULT_DISK_SYNCHRONOUS = true;
    public static final int DEFAULT_CONCURRENCY_LEVEL = 16;

    public AttributesFactory() {
        this.regionAttributes = new RegionAttributesImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributesFactory(RegionAttributes<K, V> regionAttributes) {
        RegionAttributesImpl<K, V> regionAttributesImpl = this.regionAttributes = new RegionAttributesImpl();
        synchronized (regionAttributesImpl) {
            this.regionAttributes.cacheListeners = new ArrayList<CacheListener<K, V>>(Arrays.asList(regionAttributes.getCacheListeners()));
        }
        this.regionAttributes.cacheLoader = regionAttributes.getCacheLoader();
        this.regionAttributes.cacheWriter = regionAttributes.getCacheWriter();
        this.regionAttributes.regionTimeToLive = regionAttributes.getRegionTimeToLive().getTimeout();
        this.regionAttributes.regionTimeToLiveExpirationAction = regionAttributes.getRegionTimeToLive().getAction();
        this.regionAttributes.regionIdleTimeout = regionAttributes.getRegionIdleTimeout().getTimeout();
        this.regionAttributes.regionIdleTimeoutExpirationAction = regionAttributes.getRegionIdleTimeout().getAction();
        this.regionAttributes.entryTimeToLive = regionAttributes.getEntryTimeToLive().getTimeout();
        this.regionAttributes.entryTimeToLiveExpirationAction = regionAttributes.getEntryTimeToLive().getAction();
        this.regionAttributes.customEntryTimeToLive = regionAttributes.getCustomEntryTimeToLive();
        this.regionAttributes.entryIdleTimeout = regionAttributes.getEntryIdleTimeout().getTimeout();
        this.regionAttributes.entryIdleTimeoutExpirationAction = regionAttributes.getEntryIdleTimeout().getAction();
        this.regionAttributes.customEntryIdleTimeout = regionAttributes.getCustomEntryIdleTimeout();
        this.regionAttributes.scope = regionAttributes.getScope();
        this.regionAttributes.dataPolicy = regionAttributes.getDataPolicy();
        this.regionAttributes.statisticsEnabled = regionAttributes.getStatisticsEnabled();
        this.regionAttributes.ignoreJTA = regionAttributes.getIgnoreJTA();
        this.regionAttributes.keyConstraint = regionAttributes.getKeyConstraint();
        this.regionAttributes.valueConstraint = regionAttributes.getValueConstraint();
        this.regionAttributes.initialCapacity = regionAttributes.getInitialCapacity();
        this.regionAttributes.loadFactor = regionAttributes.getLoadFactor();
        this.regionAttributes.concurrencyLevel = regionAttributes.getConcurrencyLevel();
        this.regionAttributes.concurrencyChecksEnabled = regionAttributes.getConcurrencyChecksEnabled();
        this.regionAttributes.earlyAck = regionAttributes.getEarlyAck();
        this.regionAttributes.diskStoreName = regionAttributes.getDiskStoreName();
        if (this.regionAttributes.diskStoreName == null) {
            this.regionAttributes.diskWriteAttributes = regionAttributes.getDiskWriteAttributes();
            this.regionAttributes.diskDirs = regionAttributes.getDiskDirs();
            this.regionAttributes.diskSizes = regionAttributes.getDiskDirSizes();
        }
        this.regionAttributes.diskSynchronous = regionAttributes.isDiskSynchronous();
        this.regionAttributes.indexMaintenanceSynchronous = regionAttributes.getIndexMaintenanceSynchronous();
        this.regionAttributes.partitionAttributes = regionAttributes.getPartitionAttributes();
        this.regionAttributes.evictionAttributes = (EvictionAttributesImpl)regionAttributes.getEvictionAttributes();
        this.regionAttributes.membershipAttributes = regionAttributes.getMembershipAttributes();
        this.regionAttributes.subscriptionAttributes = regionAttributes.getSubscriptionAttributes();
        this.regionAttributes.evictionAttributes = (EvictionAttributesImpl)regionAttributes.getEvictionAttributes();
        this.regionAttributes.publisher = regionAttributes.getPublisher();
        this.regionAttributes.enableAsyncConflation = regionAttributes.getEnableAsyncConflation();
        this.regionAttributes.enableSubscriptionConflation = regionAttributes.getEnableSubscriptionConflation();
        this.regionAttributes.poolName = regionAttributes.getPoolName();
        this.regionAttributes.isCloningEnabled = regionAttributes.getCloningEnabled();
        this.regionAttributes.multicastEnabled = regionAttributes.getMulticastEnabled();
        this.regionAttributes.gatewaySenderIds = new CopyOnWriteArraySet<String>(regionAttributes.getGatewaySenderIds());
        this.regionAttributes.asyncEventQueueIds = new CopyOnWriteArraySet<String>(regionAttributes.getAsyncEventQueueIds());
        this.regionAttributes.isLockGrantor = regionAttributes.isLockGrantor();
        if (regionAttributes instanceof UserSpecifiedRegionAttributes) {
            this.regionAttributes.setIndexes(((UserSpecifiedRegionAttributes)regionAttributes).getIndexes());
        }
        if (regionAttributes instanceof UserSpecifiedRegionAttributes) {
            UserSpecifiedRegionAttributes nonDefault = (UserSpecifiedRegionAttributes)regionAttributes;
            this.regionAttributes.initHasFields(nonDefault);
            this.regionAttributes.requiresPoolName = nonDefault.requiresPoolName;
        } else {
            this.regionAttributes.setAllHasFields(false);
        }
        this.regionAttributes.compressor = regionAttributes.getCompressor();
        this.regionAttributes.offHeap = regionAttributes.getOffHeap();
    }

    public void setCacheLoader(CacheLoader<K, V> cacheLoader) {
        this.regionAttributes.cacheLoader = cacheLoader;
        this.regionAttributes.setHasCacheLoader(true);
    }

    public void setCacheWriter(CacheWriter<K, V> cacheWriter) {
        this.regionAttributes.cacheWriter = cacheWriter;
        this.regionAttributes.setHasCacheWriter(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setCacheListener(CacheListener<K, V> aListener) {
        ArrayList<CacheListener<K, V>> col;
        if (aListener == null) {
            col = null;
        } else {
            col = new ArrayList<CacheListener<K, V>>(1);
            col.add(aListener);
        }
        RegionAttributesImpl<K, V> regionAttributesImpl = this.regionAttributes;
        synchronized (regionAttributesImpl) {
            this.regionAttributes.cacheListeners = col;
        }
        this.regionAttributes.setHasCacheListeners(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCacheListener(CacheListener<K, V> aListener) {
        if (aListener == null) {
            throw new IllegalArgumentException("addCacheListener parameter was null");
        }
        RegionAttributesImpl<K, V> regionAttributesImpl = this.regionAttributes;
        synchronized (regionAttributesImpl) {
            this.regionAttributes.addCacheListener(aListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initCacheListeners(CacheListener<K, V>[] newListeners) {
        RegionAttributesImpl<K, V> regionAttributesImpl = this.regionAttributes;
        synchronized (regionAttributesImpl) {
            if (newListeners == null || newListeners.length == 0) {
                this.regionAttributes.cacheListeners = null;
            } else {
                List<CacheListener<K, V>> nl = Arrays.asList(newListeners);
                if (nl.contains(null)) {
                    throw new IllegalArgumentException("initCacheListeners parameter had a null element");
                }
                this.regionAttributes.cacheListeners = new ArrayList<CacheListener<K, V>>(nl);
            }
        }
        this.regionAttributes.setHasCacheListeners(true);
    }

    public void setEntryIdleTimeout(ExpirationAttributes idleTimeout) {
        if (idleTimeout == null) {
            throw new IllegalArgumentException("idleTimeout must not be null");
        }
        this.regionAttributes.entryIdleTimeout = idleTimeout.getTimeout();
        this.regionAttributes.entryIdleTimeoutExpirationAction = idleTimeout.getAction();
        this.regionAttributes.setHasEntryIdleTimeout(true);
    }

    public void setCustomEntryIdleTimeout(CustomExpiry<K, V> custom) {
        this.regionAttributes.customEntryIdleTimeout = custom;
        this.regionAttributes.setHasCustomEntryIdleTimeout(true);
    }

    public void setEntryTimeToLive(ExpirationAttributes timeToLive) {
        if (timeToLive == null) {
            throw new IllegalArgumentException("timeToLive must not be null");
        }
        this.regionAttributes.entryTimeToLive = timeToLive.getTimeout();
        this.regionAttributes.entryTimeToLiveExpirationAction = timeToLive.getAction();
        this.regionAttributes.setHasEntryTimeToLive(true);
    }

    public void setCustomEntryTimeToLive(CustomExpiry<K, V> custom) {
        this.regionAttributes.customEntryTimeToLive = custom;
        this.regionAttributes.setHasCustomEntryTimeToLive(true);
    }

    public void setRegionIdleTimeout(ExpirationAttributes idleTimeout) {
        if (idleTimeout == null) {
            throw new IllegalArgumentException("idleTimeout must not be null");
        }
        this.regionAttributes.regionIdleTimeout = idleTimeout.getTimeout();
        this.regionAttributes.regionIdleTimeoutExpirationAction = idleTimeout.getAction();
        this.regionAttributes.setHasRegionIdleTimeout(true);
    }

    public void setRegionTimeToLive(ExpirationAttributes timeToLive) {
        if (timeToLive == null) {
            throw new IllegalArgumentException("timeToLive must not be null");
        }
        this.regionAttributes.regionTimeToLive = timeToLive.getTimeout();
        this.regionAttributes.regionTimeToLiveExpirationAction = timeToLive.getAction();
        this.regionAttributes.setHasRegionTimeToLive(true);
    }

    public void setScope(Scope scopeType) {
        if (scopeType == null) {
            throw new IllegalArgumentException("scopeType must not be null");
        }
        this.regionAttributes.setScope(scopeType);
    }

    public void setEvictionAttributes(EvictionAttributes evictAttrs) {
        this.regionAttributes.evictionAttributes = evictAttrs != null ? (EvictionAttributesImpl)evictAttrs : new EvictionAttributesImpl();
        this.regionAttributes.setHasEvictionAttributes(true);
    }

    @Deprecated
    public void setMirrorType(MirrorType mirrorType) {
        if (mirrorType == null) {
            throw new IllegalArgumentException("mirrorType must not be null");
        }
        DataPolicy dp = mirrorType.getDataPolicy();
        if (dp.withReplication()) {
            if (!this.regionAttributes.getDataPolicy().withReplication()) {
                this.setDataPolicy(dp);
            }
        } else if (this.regionAttributes.getDataPolicy().withReplication()) {
            this.setDataPolicy(dp);
        }
    }

    public void setDataPolicy(DataPolicy dataPolicy) {
        if (dataPolicy == null) {
            throw new IllegalArgumentException("dataPolicy must not be null");
        }
        if (this.regionAttributes.partitionAttributes != null && !PartitionedRegionHelper.ALLOWED_DATA_POLICIES.contains(dataPolicy)) {
            throw new IllegalStateException(String.format("Data policies other than %s are not supported for Partitioned Regions", PartitionedRegionHelper.ALLOWED_DATA_POLICIES));
        }
        this.regionAttributes.setDataPolicy(dataPolicy);
    }

    public void setKeyConstraint(Class<K> keyConstraint) {
        if (keyConstraint != null && keyConstraint.isPrimitive()) {
            throw new IllegalArgumentException("keyConstraint must not be a primitive type");
        }
        this.regionAttributes.keyConstraint = keyConstraint;
        this.regionAttributes.setHasKeyConstraint(true);
    }

    public void setValueConstraint(Class<V> valueConstraint) {
        if (valueConstraint != null && valueConstraint.isPrimitive()) {
            throw new IllegalArgumentException("valueConstraint must not be a primitive type");
        }
        this.regionAttributes.valueConstraint = valueConstraint;
        this.regionAttributes.setHasValueConstraint(true);
    }

    public void setInitialCapacity(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initialCapacity must be >= 0");
        }
        this.regionAttributes.initialCapacity = initialCapacity;
        this.regionAttributes.setHasInitialCapacity(true);
    }

    public void setLoadFactor(float loadFactor) {
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException(String.format("loadFactor must be > 0, value is %s", Float.valueOf(loadFactor)));
        }
        this.regionAttributes.loadFactor = loadFactor;
        this.regionAttributes.setHasLoadFactor(true);
    }

    public void setConcurrencyLevel(int concurrencyLevel) {
        if (concurrencyLevel <= 0) {
            throw new IllegalArgumentException("concurrencyLevel must be > 0");
        }
        this.regionAttributes.concurrencyLevel = concurrencyLevel;
        this.regionAttributes.setHasConcurrencyLevel(true);
    }

    public void setConcurrencyChecksEnabled(boolean concurrencyChecksEnabled) {
        this.regionAttributes.concurrencyChecksEnabled = concurrencyChecksEnabled;
        this.regionAttributes.setHasConcurrencyChecksEnabled(true);
    }

    @Deprecated
    public void setPersistBackup(boolean persistBackup) {
        if (persistBackup) {
            if (!this.regionAttributes.getDataPolicy().withPersistence()) {
                if (this.regionAttributes.getDataPolicy().withPartitioning()) {
                    this.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                } else {
                    this.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                }
            }
        } else if (this.regionAttributes.getDataPolicy().withReplication()) {
            this.setDataPolicy(DataPolicy.REPLICATE);
        } else if (this.regionAttributes.getDataPolicy().withPartitioning()) {
            this.setDataPolicy(DataPolicy.PARTITION);
        }
    }

    @Deprecated
    public void setEarlyAck(boolean earlyAck) {
        this.regionAttributes.earlyAck = earlyAck;
        this.regionAttributes.setHasEarlyAck(true);
    }

    @Deprecated
    public void setPublisher(boolean v) {
    }

    public void setEnableAsyncConflation(boolean enableAsyncConflation) {
        this.regionAttributes.enableAsyncConflation = enableAsyncConflation;
        this.regionAttributes.setHasEnableAsyncConflation(true);
    }

    public void setEnableSubscriptionConflation(boolean enableSubscriptionConflation) {
        this.regionAttributes.enableSubscriptionConflation = enableSubscriptionConflation;
        this.regionAttributes.setHasEnableSubscriptionConflation(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGatewaySenderId(String gatewaySenderId) {
        if (gatewaySenderId == null) {
            throw new IllegalArgumentException("GatewaySender id is null.");
        }
        RegionAttributesImpl<K, V> regionAttributesImpl = this.regionAttributes;
        synchronized (regionAttributesImpl) {
            this.regionAttributes.addGatewaySenderId(gatewaySenderId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAsyncEventQueueId(String asyncEventQueueId) {
        if (asyncEventQueueId == null) {
            throw new IllegalArgumentException("GatewaySender id is null.");
        }
        RegionAttributesImpl<K, V> regionAttributesImpl = this.regionAttributes;
        synchronized (regionAttributesImpl) {
            this.regionAttributes.addAsyncEventQueueId(asyncEventQueueId);
        }
    }

    @Deprecated
    public void setEnableBridgeConflation(boolean enableBridgeConflation) {
        this.setEnableSubscriptionConflation(enableBridgeConflation);
    }

    @Deprecated
    public void setEnableConflation(boolean enableBridgeConflation) {
        this.setEnableSubscriptionConflation(enableBridgeConflation);
    }

    @Deprecated
    public void setDiskWriteAttributes(DiskWriteAttributes attrs) {
        if (this.regionAttributes.getDiskStoreName() != null) {
            throw new IllegalStateException(String.format("Deprecated API %s cannot be used with DiskStore %s", "setDiskWriteAttributes", this.regionAttributes.getDiskStoreName()));
        }
        this.regionAttributes.diskWriteAttributes = attrs;
        this.regionAttributes.setHasDiskWriteAttributes(true);
        if (attrs != null) {
            this.regionAttributes.diskSynchronous = attrs.isSynchronous();
        }
    }

    @Deprecated
    public void setDiskDirs(File[] diskDirs) {
        if (this.regionAttributes.getDiskStoreName() != null) {
            throw new IllegalStateException(String.format("Deprecated API %s cannot be used with DiskStore %s", "setDiskDirs", this.regionAttributes.getDiskStoreName()));
        }
        DiskStoreFactoryImpl.checkIfDirectoriesExist(diskDirs);
        this.regionAttributes.diskDirs = diskDirs;
        this.regionAttributes.diskSizes = new int[diskDirs.length];
        for (int i = 0; i < diskDirs.length; ++i) {
            this.regionAttributes.diskSizes[i] = Integer.MAX_VALUE;
        }
        if (!this.regionAttributes.hasDiskWriteAttributes() && !this.regionAttributes.hasDiskSynchronous()) {
            this.regionAttributes.diskSynchronous = false;
            this.regionAttributes.diskWriteAttributes = DiskWriteAttributesImpl.getDefaultAsyncInstance();
        }
        this.regionAttributes.setHasDiskDirs(true);
    }

    public void setDiskStoreName(String name) {
        if (this.regionAttributes.hasDiskDirs() || this.regionAttributes.hasDiskWriteAttributes()) {
            throw new IllegalStateException(String.format("Deprecated API %s cannot be used with DiskStore %s", "setDiskDirs or setDiskWriteAttributes", name));
        }
        this.regionAttributes.diskStoreName = name;
        this.regionAttributes.setHasDiskStoreName(true);
    }

    public void setDiskSynchronous(boolean isSynchronous) {
        this.regionAttributes.diskSynchronous = isSynchronous;
        this.regionAttributes.setHasDiskSynchronous(true);
        if (this.regionAttributes.hasDiskWriteAttributes()) {
            DiskWriteAttributesFactory dwaf = new DiskWriteAttributesFactory(this.regionAttributes.diskWriteAttributes);
            dwaf.setSynchronous(isSynchronous);
            this.regionAttributes.diskWriteAttributes = dwaf.create();
        } else {
            this.regionAttributes.diskWriteAttributes = isSynchronous ? DiskWriteAttributesImpl.getDefaultSyncInstance() : DiskWriteAttributesImpl.getDefaultAsyncInstance();
        }
    }

    @Deprecated
    public void setDiskDirsAndSizes(File[] diskDirs, int[] diskSizes) {
        if (this.regionAttributes.getDiskStoreName() != null) {
            throw new IllegalStateException(String.format("Deprecated API %s cannot be used with DiskStore %s", "setDiskDirsAndSizes", this.regionAttributes.getDiskStoreName()));
        }
        DiskStoreFactoryImpl.checkIfDirectoriesExist(diskDirs);
        this.regionAttributes.diskDirs = diskDirs;
        if (diskSizes.length != this.regionAttributes.diskDirs.length) {
            throw new IllegalArgumentException(String.format("Number of diskSizes is %s which is not equal to number of disk Dirs which is %s", diskSizes.length, diskDirs.length));
        }
        DiskStoreAttributes.verifyNonNegativeDirSize(diskSizes);
        this.regionAttributes.diskSizes = diskSizes;
        if (!this.regionAttributes.hasDiskWriteAttributes() && !this.regionAttributes.hasDiskSynchronous()) {
            this.regionAttributes.diskSynchronous = false;
            this.regionAttributes.diskWriteAttributes = DiskWriteAttributesImpl.getDefaultAsyncInstance();
        }
        this.regionAttributes.setHasDiskDirs(true);
    }

    public void setPartitionAttributes(PartitionAttributes partition) {
        if (partition != null) {
            if (!this.regionAttributes.hasDataPolicy()) {
                this.regionAttributes.dataPolicy = PartitionedRegionHelper.DEFAULT_DATA_POLICY;
            } else if (!PartitionedRegionHelper.ALLOWED_DATA_POLICIES.contains(this.regionAttributes.dataPolicy)) {
                throw new IllegalStateException(String.format("Data policy %s is not allowed for a partitioned region. DataPolicies other than %s are not allowed.", this.regionAttributes.dataPolicy, PartitionedRegionHelper.ALLOWED_DATA_POLICIES));
            }
            if (this.regionAttributes.hasPartitionAttributes() && this.regionAttributes.partitionAttributes instanceof PartitionAttributesImpl && partition instanceof PartitionAttributesImpl) {
                PartitionAttributesImpl copy = ((PartitionAttributesImpl)this.regionAttributes.partitionAttributes).copy();
                copy.merge((PartitionAttributesImpl)partition);
                this.regionAttributes.partitionAttributes = copy;
            } else {
                this.regionAttributes.partitionAttributes = partition;
                this.regionAttributes.setHasPartitionAttributes(true);
            }
            ((PartitionAttributesImpl)this.regionAttributes.partitionAttributes).setOffHeap(this.regionAttributes.offHeap);
        } else {
            this.regionAttributes.partitionAttributes = null;
            this.regionAttributes.setHasPartitionAttributes(false);
        }
    }

    protected void setBucketRegion(boolean b) {
        this.regionAttributes.isBucketRegion = b;
    }

    @Deprecated
    public void setMembershipAttributes(MembershipAttributes membership) {
        this.regionAttributes.membershipAttributes = membership;
        this.regionAttributes.setHasMembershipAttributes(true);
    }

    public void setSubscriptionAttributes(SubscriptionAttributes subscription) {
        this.regionAttributes.subscriptionAttributes = subscription;
        this.regionAttributes.setHasSubscriptionAttributes(true);
    }

    public void setIndexMaintenanceSynchronous(boolean synchronous) {
        this.regionAttributes.indexMaintenanceSynchronous = synchronous;
        this.regionAttributes.setHasIndexMaintenanceSynchronous(true);
    }

    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.regionAttributes.statisticsEnabled = statisticsEnabled;
        this.regionAttributes.setHasStatisticsEnabled(true);
    }

    public void setIgnoreJTA(boolean flag) {
        this.regionAttributes.ignoreJTA = flag;
        this.regionAttributes.setHasIgnoreJTA(true);
    }

    public void setLockGrantor(boolean isLockGrantor) {
        this.regionAttributes.isLockGrantor = isLockGrantor;
        this.regionAttributes.setHasIsLockGrantor(true);
    }

    public void setMulticastEnabled(boolean value) {
        this.regionAttributes.multicastEnabled = value;
        this.regionAttributes.setHasMulticastEnabled(true);
    }

    public void setCloningEnabled(boolean cloningEnable) {
        this.regionAttributes.isCloningEnabled = cloningEnable;
        this.regionAttributes.setHasCloningEnabled(true);
    }

    public void setPoolName(String name) {
        String nm = name;
        if ("".equals(nm)) {
            nm = null;
        }
        this.regionAttributes.poolName = nm;
        this.regionAttributes.setHasPoolName(true);
    }

    public void setCompressor(Compressor compressor) {
        this.regionAttributes.compressor = compressor;
        this.regionAttributes.setHasCompressor(true);
        if (compressor != null) {
            this.setCloningEnabled(true);
        }
    }

    public void setOffHeap(boolean offHeap) {
        this.regionAttributes.offHeap = offHeap;
        this.regionAttributes.setHasOffHeap(true);
        if (this.regionAttributes.partitionAttributes != null) {
            ((PartitionAttributesImpl)this.regionAttributes.partitionAttributes).setOffHeap(offHeap);
        }
    }

    @Deprecated
    public RegionAttributes<K, V> createRegionAttributes() {
        return this.create();
    }

    public RegionAttributes<K, V> create() {
        RegionAttributesImpl<K, V> attrs;
        if (this.regionAttributes.hasDataPolicy() && this.regionAttributes.dataPolicy.withPartitioning() && this.regionAttributes.partitionAttributes == null) {
            this.regionAttributes.partitionAttributes = new PartitionAttributesFactory().create();
            ((PartitionAttributesImpl)this.regionAttributes.partitionAttributes).setOffHeap(this.regionAttributes.getOffHeap());
        }
        if (!((attrs = this.regionAttributes).hasStatisticsEnabled() || attrs.getStatisticsEnabled() || attrs.getRegionTimeToLive().getTimeout() == 0 && attrs.getRegionIdleTimeout().getTimeout() == 0 && attrs.getEntryTimeToLive().getTimeout() == 0 && attrs.getEntryIdleTimeout().getTimeout() == 0 && attrs.getCustomEntryIdleTimeout() == null && attrs.getCustomEntryTimeToLive() == null)) {
            this.setStatisticsEnabled(true);
        }
        if (attrs.getDataPolicy().withReplication() && !attrs.getDataPolicy().withPersistence() && attrs.getScope().isDistributed()) {
            RegionAttributesImpl<K, V> rattr = attrs;
            if (!attrs.isForBucketRegion() && (attrs.getEvictionAttributes().getAction().isLocalDestroy() || attrs.getEntryIdleTimeout().getAction().isLocal() || attrs.getEntryTimeToLive().getAction().isLocal() || attrs.getRegionIdleTimeout().getAction().isLocalInvalidate() || attrs.getRegionTimeToLive().getAction().isLocalInvalidate())) {
                this.setDataPolicy(DataPolicy.PRELOADED);
                this.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
            }
        }
        AttributesFactory.validateAttributes(this.regionAttributes);
        return (RegionAttributes)this.regionAttributes.clone();
    }

    public static void validateAttributes(RegionAttributes<?, ?> attrs) {
        if (attrs.getDataPolicy().withReplication() && attrs.getScope().isDistributed()) {
            RegionAttributesImpl regionAttributes;
            boolean isForBucketRegion = false;
            if (attrs instanceof RegionAttributesImpl && (regionAttributes = (RegionAttributesImpl)attrs).isForBucketRegion()) {
                isForBucketRegion = true;
            }
            if (!isForBucketRegion) {
                ExpirationAction idleAction = attrs.getEntryIdleTimeout().getAction();
                ExpirationAction ttlAction = attrs.getEntryTimeToLive().getAction();
                if (idleAction == ExpirationAction.LOCAL_DESTROY || ttlAction == ExpirationAction.LOCAL_DESTROY) {
                    throw new IllegalStateException("ExpirationAction.LOCAL_DESTROY on the entries is incompatible with distributed replication");
                }
                if (attrs.getEvictionAttributes().getAction().isLocalDestroy()) {
                    throw new IllegalStateException("An Eviction Controller with local destroy eviction action is incompatible with distributed replication");
                }
                if (attrs.getRegionIdleTimeout().getAction() == ExpirationAction.LOCAL_INVALIDATE || attrs.getRegionTimeToLive().getAction() == ExpirationAction.LOCAL_INVALIDATE) {
                    throw new IllegalStateException("ExpirationAction.LOCAL_INVALIDATE on the region is incompatible with distributed replication");
                }
                if (idleAction == ExpirationAction.LOCAL_INVALIDATE || ttlAction == ExpirationAction.LOCAL_INVALIDATE) {
                    throw new IllegalStateException("ExpirationAction.LOCAL_INVALIDATE on the entries is incompatible with distributed replication");
                }
            }
        }
        if (attrs.getDiskStoreName() != null) {
            EvictionAttributes ea = attrs.getEvictionAttributes();
            if (!attrs.getDataPolicy().withPersistence() && ea != null && ea.getAction() != EvictionAction.OVERFLOW_TO_DISK) {
                throw new IllegalStateException("Only regions with persistence or overflow to disk can specify DiskStore");
            }
        }
        if (!(attrs.getStatisticsEnabled() || attrs.getRegionTimeToLive().getTimeout() == 0 && attrs.getRegionIdleTimeout().getTimeout() == 0 && attrs.getEntryTimeToLive().getTimeout() == 0 && attrs.getEntryIdleTimeout().getTimeout() == 0 && attrs.getCustomEntryIdleTimeout() == null && attrs.getCustomEntryTimeToLive() == null)) {
            throw new IllegalStateException("Statistics must be enabled for expiration");
        }
        if (attrs.getDataPolicy() == DataPolicy.EMPTY) {
            if (attrs.getEntryTimeToLive().getTimeout() != 0 || attrs.getEntryIdleTimeout().getTimeout() != 0 || attrs.getCustomEntryTimeToLive() != null || attrs.getCustomEntryIdleTimeout() != null) {
                throw new IllegalStateException(String.format("If the data policy is %s then entry expiration is not allowed.", attrs.getDataPolicy()));
            }
            if (!attrs.getEvictionAttributes().getAlgorithm().isNone()) {
                throw new IllegalStateException(String.format("If the data policy is %s then eviction is not allowed.", attrs.getDataPolicy()));
            }
        }
        if (attrs.getMembershipAttributes().hasRequiredRoles() && attrs.getScope().isLocal()) {
            throw new IllegalStateException("If the membership attributes has required roles then scope must not be LOCAL.");
        }
        PartitionAttributes pa = attrs.getPartitionAttributes();
        if (pa != null) {
            UserSpecifiedRegionAttributes rac;
            ((PartitionAttributesImpl)pa).validateWhenAllAttributesAreSet(attrs instanceof RegionAttributesCreation);
            ExpirationAttributes regionIdleTimeout = attrs.getRegionIdleTimeout();
            ExpirationAttributes regionTimeToLive = attrs.getRegionTimeToLive();
            AbstractRegion.validatePRRegionExpirationAttributes(regionIdleTimeout);
            AbstractRegion.validatePRRegionExpirationAttributes(regionTimeToLive);
            ExpirationAttributes entryIdleTimeout = attrs.getEntryIdleTimeout();
            ExpirationAttributes entryTimeToLive = attrs.getEntryTimeToLive();
            if (entryIdleTimeout.getAction().isLocalDestroy() && entryIdleTimeout.getTimeout() > 0 || entryTimeToLive.getAction().isLocalDestroy() && entryTimeToLive.getTimeout() > 0) {
                throw new IllegalStateException("ExpirationAction LOCAL_DESTROY is not supported for Partitioned Region.");
            }
            if (entryIdleTimeout.getAction().isLocalInvalidate() && entryIdleTimeout.getTimeout() > 0 || entryTimeToLive.getAction().isLocalInvalidate() && entryTimeToLive.getTimeout() > 0) {
                throw new IllegalStateException("ExpirationAction LOCAL_INVALIDATE is not supported for Partitioned Region.");
            }
            if (attrs instanceof UserSpecifiedRegionAttributes && (rac = (UserSpecifiedRegionAttributes)attrs).hasScope()) {
                throw new IllegalStateException("Setting Scope on a Partitioned Regions is not allowed.");
            }
            if (attrs.getPoolName() != null) {
                throw new IllegalStateException("Setting pool name on a Partitioned Region is not allowed");
            }
            if (pa.getTotalMaxMemory() <= 0L) {
                throw new IllegalStateException("Total size of partition region must be > 0.");
            }
            if (!PartitionedRegionHelper.ALLOWED_DATA_POLICIES.contains(attrs.getDataPolicy())) {
                throw new IllegalStateException(String.format("Data policies other than %s are not allowed in  partitioned regions.", PartitionedRegionHelper.ALLOWED_DATA_POLICIES));
            }
            if (((PartitionAttributesImpl)pa).getLocalMaxMemoryForValidation() < 0) {
                throw new IllegalStateException("PartitionAttributes localMaxMemory must not be negative.");
            }
            if (attrs.isLockGrantor()) {
                throw new IllegalStateException("setLockGranter(true) is not allowed in Partitioned Regions.");
            }
            if (((PartitionAttributesImpl)pa).getLocalMaxMemoryForValidation() == 0 && attrs.getDataPolicy() == DataPolicy.PERSISTENT_PARTITION) {
                throw new IllegalStateException("Persistence is not allowed when local-max-memory is zero.");
            }
        }
        if (null != attrs.getCompressor() && !attrs.getCloningEnabled()) {
            throw new IllegalStateException("Cloning cannot be disabled when a compressor is set.");
        }
    }

    private static class RegionAttributesImpl<K, V>
    extends UserSpecifiedRegionAttributes<K, V>
    implements Cloneable {
        public Set<String> gatewaySenderIds;
        public Set<String> asyncEventQueueIds;
        ArrayList<CacheListener<K, V>> cacheListeners;
        CacheLoader<K, V> cacheLoader;
        CacheWriter<K, V> cacheWriter;
        int regionTimeToLive = 0;
        ExpirationAction regionTimeToLiveExpirationAction = ExpirationAction.INVALIDATE;
        int regionIdleTimeout = 0;
        ExpirationAction regionIdleTimeoutExpirationAction = ExpirationAction.INVALIDATE;
        int entryTimeToLive = 0;
        ExpirationAction entryTimeToLiveExpirationAction = ExpirationAction.INVALIDATE;
        CustomExpiry<K, V> customEntryTimeToLive = null;
        int entryIdleTimeout = 0;
        ExpirationAction entryIdleTimeoutExpirationAction = ExpirationAction.INVALIDATE;
        CustomExpiry<K, V> customEntryIdleTimeout = null;
        Scope scope = AbstractRegion.DEFAULT_SCOPE;
        DataPolicy dataPolicy = DataPolicy.DEFAULT;
        boolean statisticsEnabled = false;
        boolean ignoreJTA = false;
        boolean isLockGrantor = false;
        Class<K> keyConstraint = null;
        Class<V> valueConstraint = null;
        int initialCapacity = 16;
        float loadFactor = 0.75f;
        int concurrencyLevel = 16;
        boolean concurrencyChecksEnabled = true;
        boolean earlyAck = false;
        boolean publisher = false;
        boolean enableAsyncConflation = false;
        boolean enableSubscriptionConflation = false;
        DiskWriteAttributes diskWriteAttributes = DiskWriteAttributesImpl.getDefaultSyncInstance();
        File[] diskDirs = DefaultDiskDirs.getDefaultDiskDirs();
        int[] diskSizes = DiskStoreFactory.DEFAULT_DISK_DIR_SIZES;
        boolean indexMaintenanceSynchronous = true;
        PartitionAttributes partitionAttributes = null;
        MembershipAttributes membershipAttributes = new MembershipAttributes();
        SubscriptionAttributes subscriptionAttributes = new SubscriptionAttributes();
        boolean multicastEnabled = false;
        EvictionAttributesImpl evictionAttributes = new EvictionAttributesImpl();
        String poolName = null;
        String diskStoreName = null;
        boolean diskSynchronous = true;
        protected boolean isBucketRegion = false;
        private boolean isCloningEnabled = false;
        Compressor compressor = null;
        boolean offHeap = false;
        @Immutable
        private static final CacheListener<?, ?>[] EMPTY_LISTENERS = new CacheListener[0];

        public String toString() {
            StringBuilder buf = new StringBuilder(1000);
            buf.append("RegionAttributes@").append(System.identityHashCode(this)).append(": ").append("scope=").append(this.scope).append("; earlyAck=").append(this.earlyAck).append("; publisher=").append(this.publisher).append("; partitionAttrs=").append(this.partitionAttributes).append("; membershipAttrs=").append(this.membershipAttributes).append("; subscriptionAttrs=").append(this.subscriptionAttributes).append("; regionTTL=").append(this.regionTimeToLive).append("; action=").append(this.regionTimeToLiveExpirationAction).append("; regionIdleTimeout=").append(this.regionIdleTimeout).append("; action=").append(this.regionIdleTimeoutExpirationAction).append("; TTL=").append(this.entryTimeToLive).append("; action=").append(this.entryTimeToLiveExpirationAction).append("; custom=").append(this.customEntryTimeToLive).append("; idleTimeout=").append(this.entryIdleTimeout).append("; action=").append(this.entryIdleTimeoutExpirationAction).append("; custom=").append(this.customEntryIdleTimeout).append("; dataPolicy=").append(this.dataPolicy).append("; statisticsEnabled=").append(this.statisticsEnabled).append("; ignoreJTA=").append(this.ignoreJTA).append("; isLockGrantor=").append(this.isLockGrantor).append("; keyConstraint=").append(this.keyConstraint).append("; valueConstraint=").append(this.valueConstraint).append("; initialCapacity=").append(this.initialCapacity).append("; loadFactor=").append(this.loadFactor).append("; concurrencyLevel=").append(this.concurrencyLevel).append("; concurrencyChecksEnabled=").append(this.concurrencyChecksEnabled).append("; enableAsyncConflation=").append(this.enableAsyncConflation).append("; enableSubscriptionConflation=").append(this.enableSubscriptionConflation).append("; isBucketRegion=").append(this.isBucketRegion).append("; poolName=").append(this.poolName).append("; diskSynchronous=").append(this.diskSynchronous).append("; multicastEnabled=").append(this.multicastEnabled).append("; isCloningEnabled=").append(this.isCloningEnabled);
            if (this.hasDiskWriteAttributes() || this.hasDiskDirs()) {
                buf.append("; diskAttrs=").append(this.diskWriteAttributes).append("; diskDirs=").append(Arrays.toString(this.diskDirs)).append("; diskDirSizes=").append(Arrays.toString(this.diskSizes));
            } else {
                buf.append("; diskStoreName=").append(this.diskStoreName);
            }
            buf.append("; GatewaySenderIds=").append(this.gatewaySenderIds);
            buf.append("; AsyncEventQueueIds=").append(this.asyncEventQueueIds);
            buf.append("; compressor=").append(this.compressor == null ? null : this.compressor.getClass().getName());
            buf.append("; offHeap=").append(this.offHeap);
            return buf.toString();
        }

        @Override
        public CacheLoader<K, V> getCacheLoader() {
            return this.cacheLoader;
        }

        @Override
        public CacheWriter<K, V> getCacheWriter() {
            return this.cacheWriter;
        }

        @Override
        public Class<K> getKeyConstraint() {
            return this.keyConstraint;
        }

        @Override
        public Class<V> getValueConstraint() {
            return this.valueConstraint;
        }

        private boolean isForBucketRegion() {
            return this.isBucketRegion;
        }

        @Override
        public ExpirationAttributes getRegionTimeToLive() {
            return new ExpirationAttributes(this.regionTimeToLive, this.regionTimeToLiveExpirationAction);
        }

        @Override
        public ExpirationAttributes getRegionIdleTimeout() {
            return new ExpirationAttributes(this.regionIdleTimeout, this.regionIdleTimeoutExpirationAction);
        }

        @Override
        public ExpirationAttributes getEntryTimeToLive() {
            return new ExpirationAttributes(this.entryTimeToLive, this.entryTimeToLiveExpirationAction);
        }

        @Override
        public CustomExpiry<K, V> getCustomEntryTimeToLive() {
            return this.customEntryTimeToLive;
        }

        @Override
        public ExpirationAttributes getEntryIdleTimeout() {
            return new ExpirationAttributes(this.entryIdleTimeout, this.entryIdleTimeoutExpirationAction);
        }

        @Override
        public CustomExpiry<K, V> getCustomEntryIdleTimeout() {
            return this.customEntryIdleTimeout;
        }

        @Override
        public MirrorType getMirrorType() {
            if (this.dataPolicy.isNormal() || this.dataPolicy.isPreloaded() || this.dataPolicy.isEmpty() || this.dataPolicy.withPartitioning()) {
                return MirrorType.NONE;
            }
            if (this.dataPolicy.withReplication()) {
                return MirrorType.KEYS_VALUES;
            }
            throw new IllegalStateException(String.format("No mirror type corresponds to data policy %s.", this.dataPolicy));
        }

        @Override
        public DataPolicy getDataPolicy() {
            return this.dataPolicy;
        }

        public void setDataPolicy(DataPolicy dp) {
            this.dataPolicy = dp;
            this.setHasDataPolicy(true);
        }

        @Override
        public Scope getScope() {
            return this.scope;
        }

        public void setScope(Scope s) {
            this.scope = s;
            this.setHasScope(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CacheListener<K, V>[] getCacheListeners() {
            RegionAttributesImpl regionAttributesImpl = this;
            synchronized (regionAttributesImpl) {
                if (this.cacheListeners == null || this.cacheListeners.isEmpty()) {
                    return EMPTY_LISTENERS;
                }
                CacheListener[] result = new CacheListener[this.cacheListeners.size()];
                this.cacheListeners.toArray(result);
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CacheListener<K, V> getCacheListener() {
            RegionAttributesImpl regionAttributesImpl = this;
            synchronized (regionAttributesImpl) {
                if (this.cacheListeners == null) {
                    return null;
                }
                if (this.cacheListeners.size() == 0) {
                    return null;
                }
                if (this.cacheListeners.size() == 1) {
                    return this.cacheListeners.get(0);
                }
            }
            throw new IllegalStateException("More than one cache listener exists.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addCacheListener(CacheListener<K, V> aListener) {
            RegionAttributesImpl regionAttributesImpl = this;
            synchronized (regionAttributesImpl) {
                if (this.cacheListeners == null) {
                    this.cacheListeners = new ArrayList(1);
                    this.cacheListeners.add(aListener);
                } else {
                    this.cacheListeners.add(aListener);
                }
                this.setHasCacheListeners(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addGatewaySenderId(String gatewaySenderId) {
            RegionAttributesImpl regionAttributesImpl = this;
            synchronized (regionAttributesImpl) {
                if (this.gatewaySenderIds == null) {
                    this.gatewaySenderIds = new CopyOnWriteArraySet<String>();
                    this.gatewaySenderIds.add(gatewaySenderId);
                } else {
                    if (this.gatewaySenderIds.contains(gatewaySenderId)) {
                        throw new IllegalArgumentException(String.format("gateway-sender-id %s is already added", gatewaySenderId));
                    }
                    this.gatewaySenderIds.add(gatewaySenderId);
                }
                this.setHasGatewaySenderIds(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addAsyncEventQueueId(String asyncEventQueueId) {
            RegionAttributesImpl regionAttributesImpl = this;
            synchronized (regionAttributesImpl) {
                if (this.asyncEventQueueIds == null) {
                    this.asyncEventQueueIds = new CopyOnWriteArraySet<String>();
                    this.asyncEventQueueIds.add(asyncEventQueueId);
                } else {
                    if (this.asyncEventQueueIds.contains(asyncEventQueueId)) {
                        throw new IllegalArgumentException(String.format("async-event-queue-id %s is already added", asyncEventQueueId));
                    }
                    this.asyncEventQueueIds.add(asyncEventQueueId);
                }
                this.setHasAsyncEventListeners(true);
            }
        }

        @Override
        public int getInitialCapacity() {
            return this.initialCapacity;
        }

        @Override
        public float getLoadFactor() {
            return this.loadFactor;
        }

        @Override
        public boolean getStatisticsEnabled() {
            return this.statisticsEnabled;
        }

        @Override
        public boolean getIgnoreJTA() {
            return this.ignoreJTA;
        }

        @Override
        public boolean isLockGrantor() {
            return this.isLockGrantor;
        }

        @Override
        public int getConcurrencyLevel() {
            return this.concurrencyLevel;
        }

        @Override
        public boolean getConcurrencyChecksEnabled() {
            return this.concurrencyChecksEnabled;
        }

        public Object clone() {
            try {
                RegionAttributesImpl copy = (RegionAttributesImpl)super.clone();
                if (copy.getIndexes() != null) {
                    copy.setIndexes(new ArrayList(copy.getIndexes()));
                }
                if (copy.partitionAttributes != null) {
                    copy.partitionAttributes = ((PartitionAttributesImpl)copy.partitionAttributes).copy();
                }
                if (copy.cacheListeners != null) {
                    copy.cacheListeners = new ArrayList<CacheListener<K, V>>(copy.cacheListeners);
                }
                if (copy.gatewaySenderIds != null) {
                    copy.gatewaySenderIds = new CopyOnWriteArraySet<String>(copy.gatewaySenderIds);
                }
                if (copy.asyncEventQueueIds != null) {
                    copy.asyncEventQueueIds = new CopyOnWriteArraySet<String>(copy.asyncEventQueueIds);
                }
                return copy;
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError("CloneNotSupportedException thrown in class that implements cloneable.");
            }
        }

        @Override
        public boolean getPersistBackup() {
            return this.getDataPolicy().withPersistence();
        }

        @Override
        public boolean getEarlyAck() {
            return this.earlyAck;
        }

        @Override
        @Deprecated
        public boolean getPublisher() {
            return this.publisher;
        }

        @Override
        public boolean getEnableConflation() {
            return this.getEnableSubscriptionConflation();
        }

        @Override
        public boolean getEnableAsyncConflation() {
            return this.enableAsyncConflation;
        }

        @Override
        public boolean getEnableBridgeConflation() {
            return this.getEnableSubscriptionConflation();
        }

        @Override
        public boolean getEnableSubscriptionConflation() {
            return this.enableSubscriptionConflation;
        }

        @Override
        @Deprecated
        public DiskWriteAttributes getDiskWriteAttributes() {
            if (this.diskStoreName != null) {
                throw new IllegalStateException(String.format("Deprecated API %s cannot be used with DiskStore %s", "getDiskWriteAttributes", this.diskStoreName));
            }
            return this.diskWriteAttributes;
        }

        @Override
        @Deprecated
        public File[] getDiskDirs() {
            if (this.diskStoreName != null) {
                throw new IllegalStateException(String.format("Deprecated API %s cannot be used with DiskStore %s", "getDiskDirs", this.diskStoreName));
            }
            return this.diskDirs;
        }

        @Override
        public boolean getIndexMaintenanceSynchronous() {
            return this.indexMaintenanceSynchronous;
        }

        @Override
        public PartitionAttributes getPartitionAttributes() {
            return this.partitionAttributes;
        }

        @Override
        public EvictionAttributes getEvictionAttributes() {
            return this.evictionAttributes;
        }

        @Override
        @Deprecated
        public MembershipAttributes getMembershipAttributes() {
            return this.membershipAttributes;
        }

        @Override
        public SubscriptionAttributes getSubscriptionAttributes() {
            return this.subscriptionAttributes;
        }

        @Override
        @Deprecated
        public int[] getDiskDirSizes() {
            if (this.diskStoreName != null) {
                throw new IllegalStateException(String.format("Deprecated API %s cannot be used with DiskStore %s", "getDiskDirSizes", this.diskStoreName));
            }
            return this.diskSizes;
        }

        @Override
        public String getDiskStoreName() {
            return this.diskStoreName;
        }

        @Override
        public boolean getMulticastEnabled() {
            return this.multicastEnabled;
        }

        @Override
        public String getPoolName() {
            return this.poolName;
        }

        @Override
        public boolean getCloningEnabled() {
            return this.isCloningEnabled;
        }

        @Override
        public boolean isDiskSynchronous() {
            return this.diskSynchronous;
        }

        @Override
        public Set<String> getGatewaySenderIds() {
            if (!this.hasGatewaySenderId()) {
                this.gatewaySenderIds = new CopyOnWriteArraySet<String>();
            }
            return this.gatewaySenderIds;
        }

        @Override
        public Set<String> getAsyncEventQueueIds() {
            if (!this.hasAsyncEventListeners()) {
                this.asyncEventQueueIds = new CopyOnWriteArraySet<String>();
            }
            return this.asyncEventQueueIds;
        }

        @Override
        public Compressor getCompressor() {
            return this.compressor;
        }

        @Override
        public boolean getOffHeap() {
            return this.offHeap;
        }
    }
}

