/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.jmx.internal;

import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import javax.naming.OperationNotSupportedException;
import org.apache.commons.modeler.ManagedBean;
import org.apache.geode.SystemFailure;
import org.apache.geode.admin.AdminException;
import org.apache.geode.admin.ConfigurationParameter;
import org.apache.geode.admin.OperationCancelledException;
import org.apache.geode.admin.StatisticResource;
import org.apache.geode.admin.SystemMember;
import org.apache.geode.admin.SystemMemberCache;
import org.apache.geode.admin.SystemMemberCacheEvent;
import org.apache.geode.admin.SystemMemberRegionEvent;
import org.apache.geode.admin.jmx.internal.ConfigAttributeInfo;
import org.apache.geode.admin.jmx.internal.ConfigurationParameterJmxImpl;
import org.apache.geode.admin.jmx.internal.DynamicManagedBean;
import org.apache.geode.admin.jmx.internal.MBeanUtils;
import org.apache.geode.admin.jmx.internal.ManagedResource;
import org.apache.geode.admin.jmx.internal.RefreshNotificationType;
import org.apache.geode.admin.jmx.internal.StatisticResourceJmxImpl;
import org.apache.geode.admin.jmx.internal.SystemMemberCacheJmxImpl;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.cache.Operation;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

@Deprecated
public interface SystemMemberJmx
extends SystemMember,
NotificationListener {
    public static final String NOTIF_CACHE_CREATED = "gemfire.distributedsystem.cache.created";
    public static final String NOTIF_CACHE_CLOSED = "gemfire.distributedsystem.cache.closed";
    public static final String NOTIF_REGION_CREATED = "gemfire.distributedsystem.cache.region.created";
    public static final String NOTIF_REGION_LOST = "gemfire.distributedsystem.cache.region.lost";
    public static final String NOTIF_CLIENT_JOINED = "gemfire.distributedsystem.cache.client.joined";
    public static final String NOTIF_CLIENT_LEFT = "gemfire.distributedsystem.cache.client.left";
    public static final String NOTIF_CLIENT_CRASHED = "gemfire.distributedsystem.cache.client.crashed";

    public int getRefreshInterval();

    @Deprecated
    public void setRefreshInterval(int var1) throws OperationNotSupportedException;

    public void _setRefreshInterval(int var1);

    public ObjectName manageCache() throws AdminException, MalformedObjectNameException;

    public ObjectName[] manageStats() throws AdminException, MalformedObjectNameException;

    public ObjectName[] manageStat(String var1) throws AdminException, MalformedObjectNameException;

    @Override
    public void handleNotification(Notification var1, Object var2);

    public ManagedBean addDynamicAttributes(ManagedBean var1) throws AdminException;

    public void handleCacheCreate(SystemMemberCacheEvent var1);

    public void handleCacheClose(SystemMemberCacheEvent var1);

    public void handleRegionCreate(SystemMemberRegionEvent var1);

    public void handleRegionLoss(SystemMemberRegionEvent var1);

    public void handleClientMembership(String var1, int var2);

    public static class Helper {
        private static final Logger logger = LogService.getLogger();
        @MakeNotStatic
        private static final AtomicInteger notificationSequenceNumber = new AtomicInteger();

        public static int setAndReturnRefreshInterval(SystemMemberJmx member, int refreshInterval) {
            int ret = refreshInterval;
            try {
                MBeanUtils.registerRefreshNotification(member, ((ManagedResource)((Object)member)).getMBeanName(), RefreshNotificationType.SYSTEM_MEMBER_CONFIG, refreshInterval);
            }
            catch (RuntimeException e) {
                logger.warn(e.getMessage(), (Throwable)e);
                ret = 0;
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Error e) {
                SystemFailure.checkFailure();
                logger.error(e.getMessage(), (Throwable)e);
                ret = 0;
            }
            return ret;
        }

        public static ObjectName manageCache(SystemMemberJmx member) throws AdminException, MalformedObjectNameException {
            boolean IthrewIt = false;
            try {
                SystemMemberCache cache = member.getCache();
                if (cache == null) {
                    IthrewIt = true;
                    throw new AdminException("This System Member does not have a Cache.");
                }
                SystemMemberCacheJmxImpl cacheJmx = (SystemMemberCacheJmxImpl)cache;
                return ObjectName.getInstance(cacheJmx.getMBeanName());
            }
            catch (AdminException e) {
                if (!IthrewIt) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
                throw e;
            }
            catch (RuntimeException e) {
                logger.warn(e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Error e) {
                SystemFailure.checkFailure();
                logger.error(e.getMessage(), (Throwable)e);
                throw e;
            }
        }

        public static ObjectName[] manageStats(SystemMemberJmx member) throws AdminException, MalformedObjectNameException {
            try {
                StatisticResource[] stats = member.getStats();
                ObjectName[] onames = new ObjectName[stats.length];
                for (int i = 0; i < stats.length; ++i) {
                    StatisticResourceJmxImpl stat = (StatisticResourceJmxImpl)stats[i];
                    onames[i] = ObjectName.getInstance(stat.getMBeanName());
                }
                return onames;
            }
            catch (AdminException e) {
                logger.warn(e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (RuntimeException e) {
                logger.warn(e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Error e) {
                SystemFailure.checkFailure();
                logger.error(e.getMessage(), (Throwable)e);
                throw e;
            }
        }

        public static ObjectName[] manageStat(SystemMemberJmx member, String statisticsTypeName) throws AdminException, MalformedObjectNameException {
            try {
                StatisticResource[] stats = member.getStat(statisticsTypeName);
                if (stats == null) {
                    return null;
                }
                ObjectName[] statNames = new ObjectName[stats.length];
                for (int i = 0; i < stats.length; ++i) {
                    StatisticResourceJmxImpl statJMX = (StatisticResourceJmxImpl)stats[i];
                    statNames[i] = ObjectName.getInstance(statJMX.getMBeanName());
                }
                return statNames;
            }
            catch (AdminException e) {
                logger.warn(e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (RuntimeException e) {
                logger.warn(e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (Error e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw e;
            }
        }

        public static void handleNotification(SystemMemberJmx member, Notification notification, Object hb) {
            if (RefreshNotificationType.SYSTEM_MEMBER_CONFIG.getType().equals(notification.getType()) && ((ManagedResource)((Object)member)).getMBeanName().equals(notification.getUserData())) {
                try {
                    member.refreshConfig();
                }
                catch (AdminException e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
                catch (OperationCancelledException e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                    member._setRefreshInterval(0);
                }
                catch (RuntimeException e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                    member._setRefreshInterval(0);
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Error e) {
                    SystemFailure.checkFailure();
                    logger.error(e.getMessage(), (Throwable)e);
                    member._setRefreshInterval(0);
                }
            }
        }

        public static ManagedBean addDynamicAttributes(SystemMemberJmx member, ManagedBean managed) throws AdminException {
            ConfigurationParameter[] params;
            if (managed == null) {
                throw new IllegalArgumentException("ManagedBean is null");
            }
            member.refreshConfig();
            DynamicManagedBean newManagedBean = new DynamicManagedBean(managed);
            for (ConfigurationParameter param : params = member.getConfiguration()) {
                ConfigurationParameterJmxImpl parm = (ConfigurationParameterJmxImpl)param;
                ConfigAttributeInfo attrInfo = new ConfigAttributeInfo(parm);
                attrInfo.setName(parm.getName());
                attrInfo.setDisplayName(parm.getName());
                attrInfo.setDescription(parm.getDescription());
                attrInfo.setType(parm.getJmxValueType().getName());
                attrInfo.setIs(false);
                attrInfo.setReadable(true);
                attrInfo.setWriteable(parm.isModifiable());
                newManagedBean.addAttribute(attrInfo);
            }
            return newManagedBean;
        }

        static int getNextNotificationSequenceNumber() {
            return notificationSequenceNumber.incrementAndGet();
        }

        static String getCacheEventDetails(SystemMemberCacheEvent event) {
            String memberId = event.getMemberId();
            Operation operation = event.getOperation();
            return "CacheEvent[MemberId: " + memberId + ", operation: " + String.valueOf(operation) + "]";
        }

        static String getRegionEventDetails(SystemMemberRegionEvent event) {
            String memberId = event.getMemberId();
            Operation operation = event.getOperation();
            return "RegionEvent[MemberId: " + memberId + ", operation: " + String.valueOf(operation) + ", region:" + event.getRegionPath() + "]";
        }

        static void sendNotification(ManagedResource resource, Notification notif) {
            try {
                if (MBeanUtils.isRegistered(resource.getObjectName())) {
                    resource.getModelMBean().sendNotification(notif);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Sent '{}' notification", (Object)notif.getType());
                    }
                }
            }
            catch (RuntimeOperationsException e) {
                logger.info(String.format("Failed to send %s notification for %s", "'" + notif.getType() + "'", "'" + notif.getMessage() + "'"), (Throwable)e);
            }
            catch (MBeanException e) {
                logger.info(String.format("Failed to send %s notification for %s", "'" + notif.getType() + "'", "'" + notif.getMessage() + "'"), (Throwable)e);
            }
        }
    }
}

