/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.internal;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.geode.CancelException;
import org.apache.geode.admin.AdminDistributedSystem;
import org.apache.geode.admin.DistributedSystemHealthConfig;
import org.apache.geode.admin.GemFireHealth;
import org.apache.geode.admin.GemFireHealthConfig;
import org.apache.geode.admin.internal.DistributedSystemHealthConfigImpl;
import org.apache.geode.admin.internal.DistributedSystemHealthEvaluator;
import org.apache.geode.admin.internal.DistributedSystemHealthMonitor;
import org.apache.geode.admin.internal.GemFireHealthConfigImpl;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.admin.ApplicationVM;
import org.apache.geode.internal.admin.GemFireVM;
import org.apache.geode.internal.admin.GfManagerAgent;
import org.apache.geode.internal.admin.HealthListener;
import org.apache.geode.internal.admin.JoinLeaveListener;

@Deprecated
public class GemFireHealthImpl
implements GemFireHealth,
JoinLeaveListener,
HealthListener {
    private final GfManagerAgent agent;
    protected GemFireHealthConfig defaultConfig;
    private final Map hostConfigs;
    private final Map hostMembers;
    private final Collection okayHealth;
    private final Collection poorHealth;
    private GemFireHealth.Health overallHealth;
    private boolean isClosed;
    protected volatile DistributedSystemHealthConfig dsHealthConfig;
    private DistributedSystemHealthMonitor dsHealthMonitor = null;
    private final AdminDistributedSystem system;

    protected GemFireHealthImpl(GfManagerAgent agent, AdminDistributedSystem system) {
        ApplicationVM[] apps;
        this.agent = agent;
        this.system = system;
        this.hostConfigs = new HashMap();
        this.hostMembers = new HashMap();
        this.okayHealth = new HashSet();
        this.poorHealth = new HashSet();
        this.overallHealth = GOOD_HEALTH;
        this.isClosed = false;
        for (ApplicationVM member : apps = this.agent.listApplications()) {
            this.noteNewMember(member);
        }
        agent.addJoinLeaveListener(this);
        this.setDefaultGemFireHealthConfig(this.createGemFireHealthConfig(null));
        this.setDistributedSystemHealthConfig(this.createDistributedSystemHealthConfig());
    }

    public String toString() {
        return "closed=" + this.isClosed + "; hostMembers=" + String.valueOf(this.hostMembers) + "; okayHealth=" + String.valueOf(this.okayHealth) + "; poorHealth=" + String.valueOf(this.poorHealth) + "; overallHealth=" + String.valueOf(this.overallHealth) + "; diagnosis=" + this.getDiagnosis();
    }

    public AdminDistributedSystem getDistributedSystem() {
        return this.system;
    }

    protected DistributedSystemHealthConfig createDistributedSystemHealthConfig() {
        return new DistributedSystemHealthConfigImpl();
    }

    protected GemFireHealthConfig createGemFireHealthConfig(String hostName) {
        return new GemFireHealthConfigImpl(hostName);
    }

    private void checkClosed() {
        if (this.isClosed) {
            throw new IllegalStateException("Cannot access a closed GemFireHealth instance.");
        }
    }

    @Override
    public GemFireHealth.Health getHealth() {
        this.checkClosed();
        return this.overallHealth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetHealth() {
        this.checkClosed();
        this.overallHealth = GOOD_HEALTH;
        this.okayHealth.clear();
        this.poorHealth.clear();
        GemFireHealthImpl gemFireHealthImpl = this;
        synchronized (gemFireHealthImpl) {
            for (Object value : this.hostMembers.values()) {
                List members = (List)value;
                for (Object o : members) {
                    GemFireVM member = (GemFireVM)o;
                    member.resetHealthStatus();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDiagnosis() {
        this.checkClosed();
        StringBuilder sb = new StringBuilder();
        GemFireHealthImpl gemFireHealthImpl = this;
        synchronized (gemFireHealthImpl) {
            for (Object value : this.hostMembers.values()) {
                List members = (List)value;
                for (Object o : members) {
                    String[] diagnoses;
                    GemFireVM member = (GemFireVM)o;
                    for (String diagnosis : diagnoses = member.getHealthDiagnosis(this.overallHealth)) {
                        sb.append(diagnosis).append("\n");
                    }
                }
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDistributedSystemHealthConfig(DistributedSystemHealthConfig config) {
        Map map = this.hostConfigs;
        synchronized (map) {
            if (this.dsHealthMonitor != null) {
                this.dsHealthMonitor.stop();
            }
            this.dsHealthConfig = config;
            DistributedSystemHealthEvaluator eval = new DistributedSystemHealthEvaluator(config, this.agent.getDM());
            int interval = this.getDefaultGemFireHealthConfig().getHealthEvaluationInterval();
            this.dsHealthMonitor = new DistributedSystemHealthMonitor(eval, this, interval);
            this.dsHealthMonitor.start();
        }
    }

    @Override
    public DistributedSystemHealthConfig getDistributedSystemHealthConfig() {
        this.checkClosed();
        return this.dsHealthConfig;
    }

    @Override
    public GemFireHealthConfig getDefaultGemFireHealthConfig() {
        this.checkClosed();
        return this.defaultConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultGemFireHealthConfig(GemFireHealthConfig config) {
        this.checkClosed();
        if (config.getHostName() != null) {
            throw new IllegalArgumentException(String.format("The GemFireHealthConfig for %s cannot serve as the default health config.", config.getHostName()));
        }
        this.defaultConfig = config;
        GemFireHealthImpl gemFireHealthImpl = this;
        synchronized (gemFireHealthImpl) {
            Iterator iterator = this.hostMembers.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry value;
                Map.Entry entry = value = iterator.next();
                InetAddress hostIpAddress = (InetAddress)entry.getKey();
                List members = (List)entry.getValue();
                GemFireHealthConfig hostConfig = (GemFireHealthConfig)this.hostConfigs.get(hostIpAddress);
                if (hostConfig == null) {
                    hostConfig = config;
                }
                for (Object o : members) {
                    GemFireVM member = (GemFireVM)o;
                    Assert.assertTrue(member.getHost().equals(hostIpAddress));
                    member.addHealthListener(this, hostConfig);
                }
            }
        }
        if (this.dsHealthConfig != null) {
            this.setDistributedSystemHealthConfig(this.dsHealthConfig);
        }
    }

    @Override
    public synchronized GemFireHealthConfig getGemFireHealthConfig(String hostName) {
        this.checkClosed();
        InetAddress hostIpAddress = null;
        try {
            hostIpAddress = InetAddress.getByName(hostName);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(String.format("Could not find a host with name %s.", hostName), e);
        }
        GemFireHealthConfig config = (GemFireHealthConfig)this.hostConfigs.get(hostIpAddress);
        if (config == null) {
            config = this.createGemFireHealthConfig(hostName);
            this.hostConfigs.put(hostIpAddress, config);
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGemFireHealthConfig(String hostName, GemFireHealthConfig config) {
        this.checkClosed();
        GemFireHealthImpl gemFireHealthImpl = this;
        synchronized (gemFireHealthImpl) {
            String configHost = config.getHostName();
            if (configHost == null || !configHost.equals(hostName)) {
                StringBuilder sb = new StringBuilder();
                sb.append("The GemFireHealthConfig configures ");
                if (configHost == null) {
                    sb.append("the default host ");
                } else {
                    sb.append("host \"");
                    sb.append(config.getHostName());
                    sb.append("\" ");
                }
                sb.append("not \"" + hostName + "\"");
                throw new IllegalArgumentException(sb.toString());
            }
            InetAddress hostIpAddress = null;
            try {
                hostIpAddress = InetAddress.getByName(hostName);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(String.format("Could not find a host with name %s.", hostName), e);
            }
            List members = (List)this.hostMembers.get(hostIpAddress);
            if (members == null || members.isEmpty()) {
                throw new IllegalArgumentException(String.format("There are no GemFire components on host %s.", hostName));
            }
            for (Object o : members) {
                GemFireVM member = (GemFireVM)o;
                member.addHealthListener(this, config);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.agent.removeJoinLeaveListener(this);
        GemFireHealthImpl gemFireHealthImpl = this;
        synchronized (gemFireHealthImpl) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            if (this.dsHealthMonitor != null) {
                this.dsHealthMonitor.stop();
                this.dsHealthMonitor = null;
            }
            try {
                for (Object value : this.hostMembers.values()) {
                    List members = (List)value;
                    for (Object o : members) {
                        GemFireVM member = (GemFireVM)o;
                        member.removeHealthListener();
                    }
                }
            }
            catch (CancelException cancelException) {
                // empty catch block
            }
            this.hostConfigs.clear();
            this.hostMembers.clear();
            this.okayHealth.clear();
            this.poorHealth.clear();
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    private void noteNewMember(GemFireVM member) {
        InetAddress hostIpAddress = member.getHost();
        ArrayList<GemFireVM> members = (ArrayList<GemFireVM>)this.hostMembers.get(hostIpAddress);
        if (members == null) {
            members = new ArrayList<GemFireVM>();
            this.hostMembers.put(hostIpAddress, members);
        }
        members.add(member);
    }

    @Override
    public synchronized void nodeJoined(GfManagerAgent source, GemFireVM joined) {
        this.noteNewMember(joined);
        InetAddress hostIpAddress = joined.getHost();
        GemFireHealthConfig config = (GemFireHealthConfig)this.hostConfigs.get(hostIpAddress);
        if (config == null) {
            config = this.getDefaultGemFireHealthConfig();
        }
        joined.addHealthListener(this, config);
    }

    @Override
    public synchronized void nodeLeft(GfManagerAgent source, GemFireVM left) {
        InetAddress hostIpAddress = left.getHost();
        List members = (List)this.hostMembers.get(hostIpAddress);
        if (members != null) {
            members.remove(left);
            if (members.isEmpty()) {
                this.hostConfigs.remove(hostIpAddress);
                this.hostMembers.remove(hostIpAddress);
            }
        }
        this.okayHealth.remove(left);
        this.poorHealth.remove(left);
        this.reevaluateHealth();
    }

    @Override
    public void nodeCrashed(GfManagerAgent source, GemFireVM crashed) {
        this.nodeLeft(source, crashed);
    }

    private void reevaluateHealth() {
        this.overallHealth = !this.poorHealth.isEmpty() ? POOR_HEALTH : (!this.okayHealth.isEmpty() ? OKAY_HEALTH : GOOD_HEALTH);
    }

    @Override
    public void healthChanged(GemFireVM member, GemFireHealth.Health status) {
        if (status == GOOD_HEALTH) {
            this.okayHealth.remove(member);
            this.poorHealth.remove(member);
        } else if (status == OKAY_HEALTH) {
            this.okayHealth.add(member);
            this.poorHealth.remove(member);
        } else if (status == POOR_HEALTH) {
            this.okayHealth.remove(member);
            this.poorHealth.add(member);
        } else {
            Assert.assertTrue(false, "Unknown health code: " + String.valueOf(status));
        }
        this.reevaluateHealth();
    }
}

