/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.annotations.internal.MutableForTesting;
import org.apache.geode.internal.ExitCode;
import org.apache.geode.internal.SystemFailureTestHook;
import org.apache.geode.internal.admin.remote.RemoteGfManagerAgent;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.logging.internal.executors.LoggingThread;

@Deprecated
@SuppressWarnings(value={"DM_GC"}, justification="This class performs System.gc as last ditch effort during out-of-memory condition.")
public final class SystemFailure {
    @MutableForTesting
    static int SHUTDOWN_WAIT = 1000;
    static final String JVM_CORRUPTION = "JVM corruption has been detected";
    private static final String CALLING_SYSTEM_EXIT = "Since this is a dedicated cache server and the JVM has been corrupted, this process will now terminate. Permission to call System#exit(int) was given in the following context.";
    @MakeNotStatic
    protected static volatile Error failure = null;
    @MakeNotStatic
    private static volatile Runnable failureAction = () -> {
        System.err.println(JVM_CORRUPTION);
        failure.printStackTrace();
    };
    @MakeNotStatic
    private static volatile boolean exitOK = false;
    @MakeNotStatic
    private static volatile Throwable exitExcuse;
    private static final Object failureSync;
    @MakeNotStatic
    private static volatile boolean gemfireCloseCompleted;
    @MakeNotStatic
    private static volatile boolean failureActionCompleted;
    private static final int WATCHDOG_WAIT;
    @MakeNotStatic
    private static Thread watchDog;
    @MakeNotStatic
    private static volatile boolean isCacheClosing;
    @MakeNotStatic
    private static Thread proctor;
    private static final Object memorySync;
    @MakeNotStatic
    private static long minimumMemoryThreshold;
    private static final long MEMORY_POLL_INTERVAL;
    public static final long MEMORY_MAX_WAIT;
    private static final boolean MONITOR_MEMORY;
    private static final long NEVER_STARVED = Long.MAX_VALUE;
    @MakeNotStatic
    private static long firstStarveTime;
    @MakeNotStatic
    private static long lastTotalMemory;
    private static final boolean DEBUG = false;
    private static final String WATCHDOG_NAME = "SystemFailure Watchdog";
    private static final String PROCTOR_NAME = "SystemFailure Proctor";
    @MakeNotStatic
    private static volatile boolean stopping;

    public static boolean setExitOK(boolean newVal) {
        boolean result = exitOK;
        exitOK = newVal;
        exitExcuse = exitOK ? new Throwable("SystemFailure exitOK set") : null;
        return result;
    }

    public static boolean isJVMFailureError(Error err) {
        return err instanceof OutOfMemoryError || err instanceof UnknownError;
    }

    private SystemFailure() {
    }

    public static void signalCacheCreate() {
        isCacheClosing = false;
    }

    public static void signalCacheClose() {
        isCacheClosing = true;
        if (proctor != null) {
            proctor.interrupt();
        }
        if (watchDog != null) {
            watchDog.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startWatchDog() {
        if (failureActionCompleted) {
            return;
        }
        Object object = failureSync;
        synchronized (object) {
            if (watchDog != null && watchDog.isAlive()) {
                return;
            }
            watchDog = new LoggingThread("SystemFailure WatchDog", SystemFailure::runWatchDog);
            watchDog.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stopWatchDog() {
        Thread watchDogSnapshot = null;
        Object object = failureSync;
        synchronized (object) {
            stopping = true;
            if (watchDog != null && watchDog.isAlive()) {
                failureSync.notifyAll();
                watchDogSnapshot = watchDog;
            }
        }
        if (watchDogSnapshot != null) {
            try {
                watchDogSnapshot.join(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (watchDogSnapshot.isAlive()) {
                watchDogSnapshot.interrupt();
                try {
                    watchDogSnapshot.join(SHUTDOWN_WAIT);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runWatchDog() {
        boolean warned = false;
        SystemFailure.logFine(WATCHDOG_NAME, "Starting");
        while (!stopping) {
            try {
                if (isCacheClosing) break;
                Object object = failureSync;
                synchronized (object) {
                    if (stopping) {
                        return;
                    }
                    SystemFailure.logFine(WATCHDOG_NAME, "Waiting for disaster");
                    try {
                        failureSync.wait((long)WATCHDOG_WAIT * 1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (stopping) {
                        return;
                    }
                }
                if (failureActionCompleted) {
                    SystemFailure.logInfo(WATCHDOG_NAME, "all actions completed; exiting");
                }
                if (failure == null) {
                    SystemFailure.logFine(WATCHDOG_NAME, "no failure detected");
                    continue;
                }
                if (!warned) {
                    warned = SystemFailure.logWarning(WATCHDOG_NAME, "failure detected", failure);
                }
                if (!gemfireCloseCompleted) {
                    SystemFailure.logInfo(WATCHDOG_NAME, "closing GemFire");
                    try {
                        SystemFailure.emergencyClose();
                    }
                    catch (Throwable t) {
                        SystemFailure.logWarning(WATCHDOG_NAME, "trouble closing GemFire", t);
                        continue;
                    }
                    gemfireCloseCompleted = true;
                }
                if (!failureActionCompleted) {
                    Runnable r = failureAction;
                    if (r != null) {
                        SystemFailure.logInfo(WATCHDOG_NAME, "running user's runnable");
                        try {
                            r.run();
                        }
                        catch (Throwable t) {
                            SystemFailure.logWarning(WATCHDOG_NAME, "trouble running user's runnable", t);
                            continue;
                        }
                    }
                    failureActionCompleted = true;
                }
                stopping = true;
                SystemFailure.stopProctor();
                if (exitOK) {
                    SystemFailure.logWarning(WATCHDOG_NAME, CALLING_SYSTEM_EXIT, exitExcuse);
                    ExitCode.FATAL.doSystemExit();
                }
                SystemFailure.logInfo(WATCHDOG_NAME, "exiting");
                return;
            }
            catch (Throwable t) {
                SystemFailure.logWarning(WATCHDOG_NAME, "thread encountered a problem: " + String.valueOf(t), t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startProctor() {
        if (failure != null) {
            SystemFailure.notifyWatchDog();
            return;
        }
        Object object = failureSync;
        synchronized (object) {
            if (proctor != null && proctor.isAlive()) {
                return;
            }
            proctor = new LoggingThread(PROCTOR_NAME, SystemFailure::runProctor);
            proctor.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stopProctor() {
        Thread proctorSnapshot;
        Object object = failureSync;
        synchronized (object) {
            stopping = true;
            proctorSnapshot = proctor;
        }
        if (proctorSnapshot != null && proctorSnapshot.isAlive()) {
            proctorSnapshot.interrupt();
            try {
                proctorSnapshot.join(SHUTDOWN_WAIT);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runProctor() {
        long maxMemory = Runtime.getRuntime().maxMemory();
        OutOfMemoryError oome = new OutOfMemoryError(String.format("%s : memory has remained chronically below %s bytes (out of a maximum of %s ) for %s sec.", PROCTOR_NAME, minimumMemoryThreshold, maxMemory, WATCHDOG_WAIT));
        SystemFailure.logFine(PROCTOR_NAME, "Starting, threshold = " + minimumMemoryThreshold + "; max = " + maxMemory);
        while (!isCacheClosing) {
            if (stopping) {
                return;
            }
            try {
                long lastStarveTime;
                long curThreshold;
                try {
                    Thread.sleep(MEMORY_POLL_INTERVAL * 1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (stopping) {
                    return;
                }
                if (failureActionCompleted) {
                    return;
                }
                if (failure != null) {
                    SystemFailure.notifyWatchDog();
                    SystemFailure.logFine(PROCTOR_NAME, "Failure has been reported, exiting");
                    return;
                }
                if (!MONITOR_MEMORY) continue;
                long totalMemory = Runtime.getRuntime().totalMemory();
                if (totalMemory < maxMemory) {
                    firstStarveTime = Long.MAX_VALUE;
                    continue;
                }
                if (lastTotalMemory < totalMemory) {
                    lastTotalMemory = totalMemory;
                    firstStarveTime = Long.MAX_VALUE;
                    continue;
                }
                lastTotalMemory = totalMemory;
                long freeMemory = Runtime.getRuntime().freeMemory();
                if (freeMemory == 0L) {
                    new Object();
                    freeMemory = Runtime.getRuntime().freeMemory();
                }
                Object object = memorySync;
                synchronized (object) {
                    curThreshold = minimumMemoryThreshold;
                    lastStarveTime = firstStarveTime;
                }
                if (freeMemory >= curThreshold || curThreshold == 0L) {
                    if (lastStarveTime != Long.MAX_VALUE) {
                        SystemFailure.logFine(PROCTOR_NAME, "...low memory has self-corrected.");
                    }
                    object = memorySync;
                    synchronized (object) {
                        firstStarveTime = Long.MAX_VALUE;
                        continue;
                    }
                }
                long now = System.currentTimeMillis();
                if (lastStarveTime == Long.MAX_VALUE) {
                    SystemFailure.logWarning(PROCTOR_NAME, "Noting that current memory available is less than the currently designated threshold", null);
                    Object object2 = memorySync;
                    synchronized (object2) {
                        firstStarveTime = now;
                    }
                    System.gc();
                    continue;
                }
                if (now - lastStarveTime < MEMORY_MAX_WAIT * 1000L) {
                    SystemFailure.logWarning(PROCTOR_NAME, "Noting that current memory available is still below currently designated threshold", null);
                    continue;
                }
                SystemFailure.logWarning(PROCTOR_NAME, "Memory is chronically low; setting failure!", null);
                SystemFailure.setFailure(oome);
                SystemFailure.notifyWatchDog();
                return;
            }
            catch (Throwable t) {
                SystemFailure.logWarning(PROCTOR_NAME, "thread encountered a problem", t);
            }
        }
    }

    public static void loadEmergencyClasses() {
        SystemFailure.startThreads();
    }

    public static void emergencyClose() {
        GemFireCacheImpl.emergencyClose();
        RemoteGfManagerAgent.emergencyClose();
        System.gc();
    }

    private static void throwFailure() throws Error {
        if (failure != null) {
            throw failure;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyWatchDog() {
        SystemFailure.startWatchDog();
        Object object = failureSync;
        synchronized (object) {
            failureSync.notifyAll();
        }
    }

    public static void checkFailure() throws InternalGemFireError, Error {
        if (failure == null) {
            return;
        }
        SystemFailure.notifyWatchDog();
        SystemFailure.throwFailure();
    }

    public static void initiateFailure(Error f) throws InternalGemFireError, Error {
        SystemFailure.setFailure(f);
        SystemFailure.throwFailure();
    }

    public static void setFailure(Error failure) {
        if (failure == null) {
            throw new IllegalArgumentException("You are not permitted to un-set a system failure.");
        }
        if (SystemFailureTestHook.errorIsExpected(failure)) {
            return;
        }
        SystemFailure.failure = failure;
        SystemFailure.notifyWatchDog();
    }

    public static Error getFailure() {
        return failure;
    }

    public static Runnable setFailureAction(Runnable action) {
        Runnable old = failureAction;
        failureAction = action;
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long setFailureMemoryThreshold(long newVal) {
        long result;
        Object object = memorySync;
        synchronized (object) {
            result = minimumMemoryThreshold;
            minimumMemoryThreshold = newVal;
            firstStarveTime = Long.MAX_VALUE;
        }
        SystemFailure.startProctor();
        return result;
    }

    private static boolean logStdErr(String kind, String name, String s, Throwable t) {
        try {
            System.err.print(name);
            System.err.print(": [");
            System.err.print(kind);
            System.err.print("] ");
            System.err.println(s);
            if (t != null) {
                t.printStackTrace();
            }
            return true;
        }
        catch (Throwable t2) {
            return false;
        }
    }

    protected static boolean logWarning(String name, String s, Throwable t) {
        return SystemFailure.logStdErr("warning", name, s, t);
    }

    protected static void logInfo(String name, String s) {
        SystemFailure.logStdErr("info", name, s, null);
    }

    protected static void logFine(String name, String s) {
    }

    public static void startThreads() {
        stopping = false;
        SystemFailure.startWatchDog();
        SystemFailure.startProctor();
    }

    public static void stopThreads() {
        stopping = true;
        SystemFailure.stopProctor();
        SystemFailure.stopWatchDog();
    }

    static Thread getWatchDogForTest() {
        return watchDog;
    }

    static Thread getProctorForTest() {
        return proctor;
    }

    static {
        failureSync = new Object();
        gemfireCloseCompleted = false;
        failureActionCompleted = false;
        WATCHDOG_WAIT = Integer.getInteger("gemfire.WATCHDOG_WAIT", 15);
        isCacheClosing = false;
        memorySync = new Object();
        minimumMemoryThreshold = Long.getLong("gemfire.SystemFailure.chronic_memory_threshold", 0x100000L);
        MEMORY_POLL_INTERVAL = Long.getLong("gemfire.SystemFailure.MEMORY_POLL_INTERVAL", 1L);
        MEMORY_MAX_WAIT = Long.getLong("gemfire.SystemFailure.MEMORY_MAX_WAIT", 15L);
        MONITOR_MEMORY = Boolean.getBoolean("gemfire.SystemFailure.MONITOR_MEMORY");
        firstStarveTime = Long.MAX_VALUE;
        lastTotalMemory = 0L;
    }
}

