/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.deployment.validate;

import com.sas.management.deployment.AbstractDeployment;
import com.sas.management.deployment.DeploymentException;
import com.sas.management.deployment.MessageUtil;
import com.sas.management.deployment.validate.MdAssociation;
import com.sas.management.deployment.validate.ValidationObject;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DeploymentValidation {
    public static final int ATTRIBUTE_VALIDATION = 0;
    public static final int ASSOCIATION_VALIDATION = 1;
    public static final String VALIDATION_TYPE = "ValidationType";
    public static final String VALIDATION_VALUE = "ValidationValue";
    public static final String VALIDATION_ERROR = "ErrorMsg";
    private String _extractXML;
    private String _validationXML;
    private int _validationErrorCount = 0;
    private MdFactory _factory;
    private MdObjectStore _store = null;
    private Map _reposMapping = null;
    private Map _validationAttributeMap = new HashMap();
    private Map _validationAssociationMap = new HashMap();
    private Map _associationsFoundMap = new HashMap();
    private Map _objectMap = new HashMap();

    public DeploymentValidation(MdFactory factory, String extractXML, String validationXML) {
        this._factory = factory;
        this._extractXML = extractXML;
        this._validationXML = validationXML;
    }

    public DeploymentValidation(MdFactory factory, File extractFile, File validationFile) throws IOException {
        this._factory = factory;
        this._extractXML = AbstractDeployment.getFileContents(extractFile);
        this._validationXML = AbstractDeployment.getFileContents(validationFile);
    }

    public boolean validateXML() throws DeploymentException {
        this.parseValidationFile();
        this.parseExtractFile();
        return this._validationErrorCount == 0;
    }

    public void setRepositoryMapping(Map reposMap) {
        this._reposMapping = reposMap;
    }

    public int getFailedValidationCount() {
        return this._validationErrorCount;
    }

    private void parseExtractFile() throws DeploymentException {
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setNamespaceAware(false);
            parserFactory.setValidating(true);
            parserFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            parserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            SAXParser parser = parserFactory.newSAXParser();
            if (this._extractXML != null && this._extractXML.length() > 0) {
                StringReader sr = new StringReader(this._extractXML);
                InputSource is = new InputSource(sr);
                ValidationHandler handler = new ValidationHandler();
                parser.parse(is, (DefaultHandler)handler);
                Object var2_3 = null;
            }
        }
        catch (Exception e) {
            MessageUtil.printStackTrace(e);
            throw new DeploymentException(e);
        }
    }

    private void parseValidationFile() throws DeploymentException {
        Document doc = null;
        try {
            DocumentBuilderFactory df = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = df.newDocumentBuilder();
            StringReader sr = new StringReader(this._validationXML);
            InputSource is = new InputSource(sr);
            doc = db.parse(is);
        }
        catch (ParserConfigurationException e) {
            MessageUtil.printStackTrace(e);
            throw new DeploymentException(e);
        }
        catch (IOException io) {
            MessageUtil.printStackTrace(io);
            throw new DeploymentException(io);
        }
        catch (SAXException se) {
            MessageUtil.printStackTrace(se);
            throw new DeploymentException(se);
        }
        if (doc != null) {
            NodeList objects = doc.getFirstChild().getChildNodes();
            for (int i = 0; i < objects.getLength(); ++i) {
                Node metadata_object = objects.item(i);
                NodeList list = metadata_object.getChildNodes();
                for (int j = 0; j < list.getLength(); ++j) {
                    Node validation_type = list.item(j);
                    if (validation_type == null || validation_type.getNodeName().charAt(0) == '#') continue;
                    if (validation_type.getNodeName().equalsIgnoreCase("Attributes")) {
                        this._validationAttributeMap.put(metadata_object.getNodeName(), this.getValidations(validation_type, 0));
                        continue;
                    }
                    if (!validation_type.getNodeName().equalsIgnoreCase("Associations")) continue;
                    this._validationAssociationMap.put(metadata_object.getNodeName(), this.getValidations(validation_type, 1));
                }
            }
            doc = null;
            Object var2_2 = null;
        }
    }

    private List getValidations(Node node, int validationType) {
        NodeList list = node.getChildNodes();
        int length = list.getLength();
        ArrayList<ValidationObject> itemsList = new ArrayList<ValidationObject>(length);
        for (int k = 0; k < length; ++k) {
            Node validation_node = list.item(k);
            NamedNodeMap map = validation_node.getAttributes();
            if (map == null) continue;
            ValidationObject validate = new ValidationObject(validationType);
            validate.setValidationName(validation_node.getNodeName());
            for (int i = 0; i < map.getLength(); ++i) {
                Node attrNode = map.item(i);
                String nodeName = attrNode.getNodeName();
                String nodeValue = attrNode.getNodeValue();
                if (VALIDATION_TYPE.equals(nodeName)) {
                    validate.setRestrictionType(nodeValue);
                    continue;
                }
                if (VALIDATION_VALUE.equals(nodeName)) {
                    validate.setRestrictionValue(nodeValue);
                    continue;
                }
                if (VALIDATION_ERROR.equals(nodeName)) {
                    if (nodeValue.length() <= 0) continue;
                    validate.setErrorMessage(nodeValue);
                    continue;
                }
                validate.addCustomAttribute(nodeName, nodeValue);
            }
            itemsList.add(validate);
        }
        return itemsList;
    }

    private class ValidationHandler
    extends DefaultHandler {
        Map uniquenessMap;
        boolean processing_objects = false;

        private ValidationHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.processing_objects) {
                this.processObjects(uri, localName, qName, attributes);
            } else if (qName.equalsIgnoreCase("TransportXml")) {
                this.processing_objects = true;
            }
        }

        public void processObjects(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equalsIgnoreCase("MdAssoc")) {
                String succID = attributes.getValue("SuccId");
                String predID = attributes.getValue("PredId");
                String succRole = attributes.getValue("SuccRole");
                String predRole = attributes.getValue("PredRole");
                String succType = (String)DeploymentValidation.this._objectMap.get(succID);
                String predType = (String)DeploymentValidation.this._objectMap.get(predID);
                if (DeploymentValidation.this._associationsFoundMap.containsKey(succID)) {
                    MdAssociation assoc = this.getAssociationObject(succRole, succID);
                    if (assoc == null) {
                        assoc = new MdAssociation(succType, predType, succRole, predRole);
                        assoc.addObjectToAssociation(predID);
                        ((List)DeploymentValidation.this._associationsFoundMap.get(succID)).add(assoc);
                    } else {
                        assoc.addObjectToAssociation(predID);
                    }
                } else {
                    MdAssociation assoc = new MdAssociation(succType, predType, succRole, predRole);
                    assoc.addObjectToAssociation(attributes.getValue("PredId"));
                    ArrayList<MdAssociation> assocList = new ArrayList<MdAssociation>();
                    assocList.add(assoc);
                    DeploymentValidation.this._associationsFoundMap.put(succID, assocList);
                }
            } else {
                String objectType = qName;
                String id = attributes.getValue("Id");
                if (id != null) {
                    DeploymentValidation.this._objectMap.put(id, objectType);
                }
                if (DeploymentValidation.this._validationAttributeMap.containsKey(objectType)) {
                    try {
                        String object_name = attributes.getValue("Name");
                        List validations = (List)DeploymentValidation.this._validationAttributeMap.get(objectType);
                        int val_length = validations.size();
                        for (int i = 0; i < val_length; ++i) {
                            ValidationObject validate = (ValidationObject)validations.get(i);
                            String attribute_name = validate.getValidationName();
                            String original_value = attributes.getValue(attribute_name);
                            boolean success = this.validateAttribute(objectType, id, original_value, validate);
                            if (success) continue;
                            DeploymentValidation.this._validationErrorCount++;
                            if (validate.getErrorMessage() != null) {
                                MessageUtil.printMessage(validate.getErrorMessage(), 0);
                                continue;
                            }
                            StringBuffer msg = new StringBuffer();
                            msg.append("The following object did not meet the restriction ");
                            msg.append(validate.getRestrictionType());
                            msg.append(" (");
                            msg.append(object_name);
                            msg.append(")");
                            MessageUtil.printMessage(msg.toString(), 0);
                        }
                    }
                    catch (DeploymentException e) {
                        throw new SAXException(e);
                    }
                    catch (RemoteException e) {
                        throw new SAXException(e);
                    }
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.processing_objects && qName.equalsIgnoreCase("TransportXml")) {
                this.processing_objects = false;
                if (DeploymentValidation.this._validationAssociationMap.size() > 0) {
                    for (String validation_type : DeploymentValidation.this._validationAssociationMap.keySet()) {
                        List list = (List)DeploymentValidation.this._validationAssociationMap.get(validation_type);
                        for (int j = 0; j < list.size(); ++j) {
                            ValidationObject validate = (ValidationObject)list.get(j);
                            String association_name = validate.getValidationName();
                            for (String object_id : DeploymentValidation.this._objectMap.keySet()) {
                                String object_type = (String)DeploymentValidation.this._objectMap.get(object_id);
                                if (!object_type.equalsIgnoreCase(validation_type)) continue;
                                List assocList = (List)DeploymentValidation.this._associationsFoundMap.get(object_id);
                                MdAssociation assoc = null;
                                if (assocList != null) {
                                    for (int i = 0; i < assocList.size(); ++i) {
                                        boolean success = true;
                                        assoc = (MdAssociation)assocList.get(i);
                                        if (assoc.getSuccRole().equalsIgnoreCase(association_name) || assoc.getPredRole().equalsIgnoreCase(association_name)) {
                                            success = this.validateAssociation(validate, assoc);
                                        }
                                        if (success) continue;
                                        DeploymentValidation.this._validationErrorCount++;
                                        StringBuffer msg = new StringBuffer();
                                        msg.append(validation_type);
                                        msg.append(" (");
                                        msg.append(object_id);
                                        msg.append(") - The association \"");
                                        msg.append(association_name);
                                        msg.append("\" did not meet the following restriction: ");
                                        msg.append(validate.getRestrictionType());
                                        msg.append(" = ");
                                        msg.append(validate.getRestrictionValue());
                                        MessageUtil.printMessage(msg.toString(), 2);
                                    }
                                    continue;
                                }
                                boolean success = this.validateAssociation(validate, null);
                                if (success) continue;
                                DeploymentValidation.this._validationErrorCount++;
                                StringBuffer msg = new StringBuffer();
                                msg.append(validation_type);
                                msg.append(" (");
                                msg.append(object_id);
                                msg.append(") - The association \"");
                                msg.append(association_name);
                                msg.append("\" did not meet the following restriction: ");
                                msg.append(validate.getRestrictionType());
                                msg.append(" = ");
                                msg.append(validate.getRestrictionValue());
                                MessageUtil.printMessage(msg.toString(), 2);
                            }
                        }
                    }
                }
            }
        }

        @Override
        public void endDocument() {
            if (DeploymentValidation.this._store != null) {
                try {
                    DeploymentValidation.this._store.dispose();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        private boolean validateAssociation(ValidationObject obj, MdAssociation assoc) {
            String restrictionType = obj.getRestrictionType();
            String restrictionValue = obj.getRestrictionValue();
            if (restrictionType.equalsIgnoreCase("MinSize")) {
                int minsize;
                int size = 0;
                if (assoc != null) {
                    size = assoc.getAssociationSize();
                }
                if (size < (minsize = Integer.parseInt(restrictionValue))) {
                    return false;
                }
            } else if (restrictionType.equalsIgnoreCase("MaxSize")) {
                int maxsize = Integer.parseInt(restrictionValue);
                if (assoc.getAssociationSize() > maxsize) {
                    return false;
                }
            }
            return true;
        }

        private boolean validateAttribute(String objectType, String objectID, String originalValue, ValidationObject obj) throws DeploymentException, RemoteException {
            String restrictionType = obj.getRestrictionType();
            String restrictionValue = obj.getRestrictionValue();
            try {
                if (restrictionType.equalsIgnoreCase("MinLength")) {
                    int minlength = Integer.parseInt(restrictionValue);
                    if (originalValue.length() < minlength) {
                        return false;
                    }
                } else if (restrictionType.equalsIgnoreCase("MaxLength")) {
                    int maxlength = Integer.parseInt(restrictionValue);
                    if (originalValue.length() > maxlength) {
                        return false;
                    }
                } else if (restrictionType.equalsIgnoreCase("Value")) {
                    if (!originalValue.equals(restrictionValue)) {
                        return false;
                    }
                } else if (restrictionType.equalsIgnoreCase("IsNumber")) {
                    if (restrictionValue.equalsIgnoreCase("true")) {
                        Integer.parseInt(originalValue);
                    }
                } else if (restrictionType.equalsIgnoreCase("IsRequired")) {
                    if (restrictionValue.equalsIgnoreCase("true") && originalValue == null) {
                        return false;
                    }
                } else if (restrictionType.equalsIgnoreCase("Range")) {
                    StringTokenizer st = new StringTokenizer(restrictionValue, ",-;:");
                    int start = Integer.parseInt(st.nextToken());
                    int end = Integer.parseInt(st.nextToken());
                    int value = Integer.parseInt(originalValue);
                    if (value < start || value > end) {
                        return false;
                    }
                } else if (restrictionType.equalsIgnoreCase("IsUnique")) {
                    if (originalValue == null) {
                        return true;
                    }
                    if (restrictionValue.equalsIgnoreCase("true")) {
                        boolean unique;
                        if (this.uniquenessMap == null) {
                            this.uniquenessMap = new HashMap();
                        }
                        if (!(unique = this.checkForUniquenessOnClient(objectType, objectID, obj.getValidationName(), originalValue))) {
                            // empty if block
                        }
                        boolean caseSensitive = true;
                        String strCaseSensitive = obj.getCustomAttribute("CaseSensitive");
                        if (strCaseSensitive != null && strCaseSensitive.equalsIgnoreCase("false")) {
                            caseSensitive = false;
                        }
                        if (!(unique = this.checkForUniquenessOnServer(objectType, objectID, obj.getValidationName(), originalValue, caseSensitive))) {
                            return unique;
                        }
                    }
                }
            }
            catch (NumberFormatException nfe) {
                return false;
            }
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean checkForUniquenessOnClient(String objectType, String objectID, String attributeName, String attributeValue) {
            if (this.uniquenessMap.containsKey(objectType)) {
                AttributeUniqueness attr = (AttributeUniqueness)this.uniquenessMap.get(objectType);
                if (attr.containsValue(attributeValue)) return false;
                attr.addValue(attributeValue);
                return true;
            } else {
                AttributeUniqueness attr = new AttributeUniqueness(objectType, attributeName);
                attr.addValue(attributeValue);
                this.uniquenessMap.put(objectType, attr);
            }
            return true;
        }

        private boolean checkForUniquenessOnServer(String objectType, String objectID, String attributeName, String attributeValue, boolean caseSensitiveSearch) throws DeploymentException, RemoteException {
            if (DeploymentValidation.this._store == null) {
                DeploymentValidation.this._store = DeploymentValidation.this._factory.createObjectStore();
                DeploymentValidation.this._factory.getUtil().setOutputStream(MessageUtil.getOutputStream());
                DeploymentValidation.this._factory.getUtil().setLogStream(MessageUtil.getOutputStream());
            }
            try {
                List objects = this.getMetadataObjects(objectType, objectID, attributeName);
                if (objects != null) {
                    int size = objects.size();
                    for (int i = 0; i < size; ++i) {
                        CMetadata meta = (CMetadata)objects.get(i);
                        String attr = (String)meta.getAttrs().get(attributeName);
                        if ((!caseSensitiveSearch || !attributeValue.equals(attr)) && (caseSensitiveSearch || !attributeValue.equalsIgnoreCase(attr))) continue;
                        return false;
                    }
                }
            }
            catch (MdException e) {
                MessageUtil.printStackTrace(e);
                throw new DeploymentException(e);
            }
            return true;
        }

        private MdAssociation getAssociationObject(String type, String id) {
            List list = (List)DeploymentValidation.this._associationsFoundMap.get(id);
            for (int i = 0; i < list.size(); ++i) {
                MdAssociation assoc = (MdAssociation)list.get(i);
                if (!assoc.getSuccRole().equalsIgnoreCase(type)) continue;
                return assoc;
            }
            return null;
        }

        private List getMetadataObjects(String objectType, String objectID, String attributeName) throws MdException, RemoteException {
            if (objectID == null || DeploymentValidation.this._reposMapping == null) {
                return null;
            }
            String sourceReposID = "A0000001." + objectID.substring(0, 8);
            String targetReposID = (String)DeploymentValidation.this._reposMapping.get(sourceReposID);
            if (targetReposID == null) {
                return null;
            }
            StringBuffer template = new StringBuffer();
            template.append("<TEMPLATES><");
            template.append(objectType);
            template.append(" ");
            template.append(attributeName);
            template.append("=\"\"/></TEMPLATES>");
            return DeploymentValidation.this._factory.getOMIUtil().getMetadataObjectsSubset((MdStore)DeploymentValidation.this._store, targetReposID, objectType, 260, template.toString(), false);
        }
    }

    private class AttributeUniqueness {
        private Set _valueSet = new HashSet();

        public AttributeUniqueness(String type, String name) {
        }

        public void addValue(String value) {
            this._valueSet.add(value);
        }

        public boolean containsValue(String value) {
            return this._valueSet.contains(value);
        }
    }
}

