/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.deployment;

import com.sas.management.deployment.DeploymentException;
import com.sas.management.deployment.ExtractMetadata;
import com.sas.management.deployment.ExtractMethod;
import com.sas.management.deployment.ExtractTemplate;
import com.sas.management.deployment.MdMethodCall;
import com.sas.metadata.remote.MetadataResource;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SAXHandler
extends DefaultHandler {
    protected static MetadataResource bundle = new MetadataResource(ExtractMetadata.class);
    private int optionsState = 0;
    private ExtractMetadata extract = null;
    private String namespace = null;
    private String reposID = null;
    private StringBuffer methodBuffer = null;
    private int extractLevel = 0;
    private String currentExtractType = "";
    private String elementData = "";
    private boolean processingMetadata = false;
    private boolean processingTemplates = false;
    private boolean foundTemplate = false;
    private boolean foundOptions = false;
    private boolean doNotDeleteOptions = false;
    private Map templateMap = null;
    private List methodList = null;

    public SAXHandler(ExtractMetadata extract) {
        this.extract = extract;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("multiple_requests")) {
            throw new SAXException(bundle.getString("SAXHandler.MultipleRequests.Warning.txt"));
        }
        if (this.processingMetadata) {
            if (attributes != null) {
                MdMethodCall method;
                String search;
                String id = attributes.getValue("Id");
                if (id == null) {
                    id = attributes.getValue("id");
                }
                if ((search = attributes.getValue("Search")) == null) {
                    search = attributes.getValue("search");
                }
                if (id != null && id.length() > 0) {
                    method = new MdMethodCall(qName, "Id", id);
                } else if (search != null && search.length() > 0) {
                    method = new MdMethodCall(qName, "Search", search);
                } else {
                    search = "*";
                    method = new MdMethodCall(qName, "Search", search);
                }
                String template = attributes.getValue("TemplateName");
                if (template != null) {
                    method.setTemplateName(template);
                }
                this.methodList.add(method);
            }
        } else if (this.processingTemplates) {
            if (this.extractLevel == 0) {
                String search;
                this.foundTemplate = true;
                this.currentExtractType = attributes.getValue("Type");
                if (this.currentExtractType == null) {
                    this.currentExtractType = attributes.getValue("type");
                }
                if ((search = attributes.getValue("Search")) == null) {
                    search = attributes.getValue("search");
                }
                if (search != null && this.methodList.size() > 0) {
                    this.customizeSearch(search);
                }
            } else if (this.extractLevel == 1 && this.foundTemplate) {
                if (this.currentExtractType == null) {
                    this.currentExtractType = qName;
                }
                ExtractTemplate template = new ExtractTemplate(this.currentExtractType);
                template.setObjectType(qName);
                this.templateMap.put(this.currentExtractType, template);
                this.foundTemplate = false;
            }
            ++this.extractLevel;
        } else if (qName.equalsIgnoreCase("ExtractMetadata")) {
            this.methodBuffer = new StringBuffer();
            this.methodList = new ArrayList();
            this.templateMap = new HashMap();
            this.optionsState = 0;
            this.namespace = null;
            this.reposID = null;
            this.extractLevel = 0;
        } else if (qName.equalsIgnoreCase("Metadata")) {
            this.processingMetadata = true;
        } else if (qName.equalsIgnoreCase("ExtractTemplates")) {
            this.processingTemplates = true;
        } else if (qName.equalsIgnoreCase("Options")) {
            this.foundOptions = true;
            this.doNotDeleteOptions = true;
        }
        if (attributes.getLength() > 0) {
            this.appendStartTagAndAttributes(qName, attributes);
        } else {
            this.appendStartTag(qName);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.appendEndTag(qName);
        if (this.processingMetadata) {
            if (qName.equalsIgnoreCase("Metadata")) {
                this.processingMetadata = false;
            }
        } else if (this.processingTemplates) {
            if (qName.equalsIgnoreCase("ExtractTemplates")) {
                this.processingTemplates = false;
            }
            --this.extractLevel;
        } else if (this.foundOptions) {
            if (qName.equalsIgnoreCase("Options")) {
                this.optionsState = this.templateMap.size() > 0 || this.doNotDeleteOptions ? 2 : 1;
                this.foundOptions = false;
            }
        } else if (qName.equalsIgnoreCase("ReposId")) {
            this.reposID = this.elementData;
        } else if (qName.equalsIgnoreCase("ReposName")) {
            if (this.reposID == null) {
                if (this.elementData.startsWith("A0000001.")) {
                    this.reposID = this.elementData;
                } else {
                    try {
                        this.reposID = this.extract.getTargetRepositoryInfo(this.elementData, false);
                    }
                    catch (DeploymentException deploymentException) {
                        // empty catch block
                    }
                    if (this.reposID != null) {
                        int length = this.methodBuffer.length();
                        int startIndex = length - (this.elementData.length() + 23);
                        this.methodBuffer.delete(startIndex, length);
                        this.methodBuffer.append("<");
                        this.methodBuffer.append("ReposId");
                        this.methodBuffer.append(">");
                        this.methodBuffer.append(this.reposID);
                        this.methodBuffer.append("</");
                        this.methodBuffer.append("ReposId");
                        this.methodBuffer.append(">");
                    }
                }
            }
        } else if (qName.equalsIgnoreCase("Ns")) {
            this.namespace = this.elementData;
        } else if (qName.equalsIgnoreCase("ExtractMetadata")) {
            ExtractMethod method = new ExtractMethod();
            method.setReposID(this.reposID);
            method.setNamespace(this.namespace);
            method.setOptionsState(this.optionsState);
            method.setMethodCalls(this.methodList);
            method.setTemplateMap(this.templateMap);
            method.setMethodXML(this.methodBuffer.toString());
            this.extract.setExtractMethod(method);
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) {
        if (len > 0 && !this.isTab(buf, offset, len)) {
            String s = new String(buf, offset, len);
            this.elementData = s = s.trim();
            this.methodBuffer.append(s);
        } else {
            this.elementData = "";
        }
    }

    public boolean isTab(char[] buf, int offset, int len) {
        for (int i = offset + len - 1; i >= offset; --i) {
            if (buf[i] <= ' ') continue;
            return false;
        }
        return true;
    }

    public void appendStartTag(String tag) {
        this.methodBuffer.append("<").append(tag).append(">");
    }

    public void appendEndTag(String tag) {
        this.methodBuffer.append("</").append(tag).append(">");
    }

    public void appendShortEndTag(String tag) {
        this.methodBuffer.append("<").append(tag).append("/>");
    }

    public void replaceWithShortEndTag() {
        this.methodBuffer.insert(this.methodBuffer.length() - 1, "/");
    }

    public void useShortEndTag(String tag) {
        int start = tag.length() + 4;
        this.methodBuffer.delete(start, this.methodBuffer.length());
        this.methodBuffer.append("/>");
    }

    public void appendStartTagAndAttributes(String tag, Attributes attrs) {
        this.methodBuffer.append("<").append(tag);
        int len = attrs.getLength();
        for (int i = 0; i < len; ++i) {
            this.methodBuffer.append(" ").append(attrs.getQName(i)).append("=\"");
            if (this.processingMetadata || this.processingTemplates) {
                try {
                    String xml = this.extract.getFactory().getOMIUtil().cleanStringForXML(attrs.getValue(i));
                    this.methodBuffer.append(xml);
                }
                catch (RemoteException remoteException) {}
            } else {
                this.methodBuffer.append(attrs.getValue(i));
            }
            this.methodBuffer.append("\"");
        }
        this.methodBuffer.append(">");
    }

    protected void customizeSearch(String currentSearch) {
        for (int i = 0; i < this.methodList.size(); ++i) {
            MdMethodCall method = (MdMethodCall)this.methodList.get(i);
            String templateName = method.getTemplateName();
            if (templateName == null || !templateName.equals(this.currentExtractType) || !method.getSearchType().equalsIgnoreCase("Search")) continue;
            String s = method.getSearchValue();
            if (s.equalsIgnoreCase("*")) {
                method.setSearchValue("*[" + currentSearch + "]", true);
                continue;
            }
            int index = s.indexOf(91);
            StringBuffer sb = new StringBuffer(s);
            if (index > -1) {
                if (s.charAt(index + 1) == '@') {
                    sb.insert(index + 1, currentSearch);
                    sb.insert(index + currentSearch.length() + 1, " and ");
                } else {
                    sb.insert(index, "[" + currentSearch + "]");
                }
            } else {
                sb.insert(0, "*[(" + currentSearch + ") and ");
                sb.append("]");
            }
            method.setSearchValue(sb.toString(), true);
        }
    }
}

