/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.deployment;

import com.sas.management.deployment.BaseDeploymentObject;
import com.sas.management.deployment.DeploymentObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReferencePoint
extends BaseDeploymentObject {
    private int _objectCountOnTarget = 0;
    private String _targetName;
    private String _path;
    private Map _referenceMap;
    private List _associatedObjectsList;
    private Map _attributeMap;
    private Object _targetObject;

    public ReferencePoint(String objectType, String objectName) {
        super(objectType, null, objectName);
    }

    public ReferencePoint(String path) {
        super(null, null, null);
        this._path = path;
    }

    public String getPath() {
        return this._path;
    }

    public boolean objectExistsOnceOnTarget() {
        return this._objectCountOnTarget == 1;
    }

    public boolean objectExistsMultipleTimesOnTarget() {
        return this._objectCountOnTarget > 1;
    }

    public void setObjectExistsOnTargetCount(int count) {
        this._objectCountOnTarget = count;
    }

    public Map getAllReferences() {
        return this._referenceMap;
    }

    public List getReferenceList(String associationName) {
        if (this._referenceMap == null || !this._referenceMap.containsKey(associationName)) {
            return new ArrayList();
        }
        return (List)this._referenceMap.get(associationName);
    }

    public void addReference(String associationName, ReferencePoint ref) {
        ArrayList<ReferencePoint> refs;
        if (this._referenceMap == null) {
            this._referenceMap = new HashMap();
        }
        if ((refs = (ArrayList<ReferencePoint>)this._referenceMap.get(associationName)) == null) {
            refs = new ArrayList<ReferencePoint>();
            this._referenceMap.put(associationName, refs);
        }
        refs.add(ref);
    }

    public String getTargetObjectName() {
        return this._targetName;
    }

    public void setTargetObjectName(String name) {
        this._targetName = name;
    }

    public List getAssociatedObjects() {
        return this._associatedObjectsList;
    }

    public void addAssociatedObject(DeploymentObject obj) {
        this.addAssociatedObject(obj, true);
    }

    protected void addAssociatedObject(DeploymentObject obj, boolean addOppositeSide) {
        if (this._associatedObjectsList == null) {
            this._associatedObjectsList = new ArrayList();
        }
        this._associatedObjectsList.add(obj);
        if (addOppositeSide) {
            obj.addReferencePoint(this, false);
        }
    }

    public void addAssociatedObjects(List objects) {
        this.addAssociatedObjects(objects, true);
    }

    protected void addAssociatedObjects(List objects, boolean addOppositeSide) {
        if (this._associatedObjectsList == null) {
            this._associatedObjectsList = new ArrayList(objects.size());
        }
        this._associatedObjectsList.addAll(objects);
        if (addOppositeSide) {
            int size = objects.size();
            for (int i = 0; i < size; ++i) {
                DeploymentObject obj = (DeploymentObject)objects.get(i);
                obj.addReferencePoint(this, false);
            }
        }
    }

    public void addAttribute(String attrName, String attrValue) {
        if (this._attributeMap == null) {
            this._attributeMap = new HashMap();
        }
        this._attributeMap.put(attrName, attrValue);
    }

    public String getAttributeValue(String attrName) {
        return this._attributeMap == null ? null : (String)this._attributeMap.get(attrName);
    }

    public Object getTargetObject() {
        return this._targetObject;
    }

    public void setTargetObject(Object obj) {
        this._targetObject = obj;
    }
}

