/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.deployment;

import com.sas.management.deployment.AbstractDeployment;
import com.sas.management.deployment.MetadataUtility;
import com.sas.metadata.remote.MetadataResource;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MessageUtil {
    public static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss,SSS");
    protected static MetadataResource bundle = new MetadataResource(MessageUtil.class);
    public static final int INFORMATION_TYPE = 0;
    public static final int WARNING_TYPE = 1;
    public static final int ERROR_TYPE = 2;
    public static final int DEBUG_TYPE = 3;
    private static OutputStream outputStream = null;
    private static PrintWriter outputWriter = null;

    public static void setOutputStream(OutputStream output) {
        outputStream = null;
        outputStream = output == null ? output : new BufferedOutputStream(output);
        if (outputStream != null) {
            outputWriter = new PrintWriter(outputStream, true);
        }
    }

    public static OutputStream getOutputStream() {
        return outputStream;
    }

    public static PrintWriter getPrintWriter() {
        return outputWriter;
    }

    public static void printMessage(String msg) {
        MessageUtil.printMessage(msg, -1);
    }

    public static void printMessage(String msg, int type) {
        if (outputWriter != null) {
            String title;
            boolean writeToStandardError = false;
            boolean writeToStandardOut = false;
            switch (type) {
                case 0: {
                    title = bundle.getString("MessageUtil.Title.Info.txt");
                    writeToStandardOut = true;
                    break;
                }
                case 1: {
                    title = bundle.getString("MessageUtil.Title.Warning.txt");
                    writeToStandardError = true;
                    break;
                }
                case 2: {
                    title = bundle.getString("MessageUtil.Title.Error.txt");
                    writeToStandardError = true;
                    break;
                }
                case 3: {
                    title = bundle.getString("MessageUtil.Title.Debug.txt");
                    break;
                }
                default: {
                    title = "";
                }
            }
            outputWriter.println(title + msg);
            outputWriter.flush();
            if (writeToStandardOut) {
                System.out.println(title + msg);
            }
            if (writeToStandardError) {
                System.err.println(title + msg);
            }
        }
    }

    public static void printStackTrace(Throwable t) {
        if (AbstractDeployment.getDebug()) {
            t.printStackTrace(outputWriter);
        }
    }

    public static void printLoglnClient(String inString) {
        if (AbstractDeployment.getDebug()) {
            String myString = inString;
            StringBuffer myBuf = myString == null ? new StringBuffer() : new StringBuffer(myString.length());
            MessageUtil.printMessage("Beginning Server Call: " + sdf.format(new Date()));
            myBuf.append("<Client>");
            myBuf.append(myString);
            myBuf.append("</Client>");
            MessageUtil.printMessage(MetadataUtility.formatXML(myBuf.toString()));
        }
    }

    public static void printLoglnServer(String inString) {
        if (AbstractDeployment.getDebug()) {
            String myString = inString;
            StringBuffer myBuf = myString == null ? new StringBuffer() : new StringBuffer(myString.length());
            myBuf.append("<Server>");
            myBuf.append(myString);
            myBuf.append("</Server>");
            MessageUtil.printMessage(MetadataUtility.formatXML(myBuf.toString()));
            MessageUtil.printMessage("Ending Server Call: " + sdf.format(new Date()));
        }
    }
}

