/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.deployment;

import com.sas.management.deployment.BaseDeploymentObject;
import com.sas.management.deployment.ConnectionPoint;
import com.sas.management.deployment.ReferencePoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeploymentObject
extends BaseDeploymentObject {
    public static final int OFF_STATE = 0;
    public static final int ADD_STATE = 1;
    public static final int UPDATE_STATE = 2;
    public static final int REPLACE_STATE = 3;
    private int _orderNum = 0;
    private String _searchAttribute = null;
    private Map _connectionPointsMap = null;
    private List _referencePointList = null;
    private boolean _isTopLevel = false;
    private String _logicalType = null;
    private int _importState = 1;
    private String _targetID = null;
    private double _usageVersion = 0.0;

    public DeploymentObject(String objectType, String objectID, String objectName, boolean topLevel) {
        super(objectType, objectID, objectName);
        this._isTopLevel = topLevel;
        this._connectionPointsMap = new HashMap();
    }

    public boolean isTopLevelObject() {
        return this._isTopLevel;
    }

    public void setLogicalObjectType(String type) {
        this._logicalType = type;
    }

    public String getLogicalObjectType() {
        return this._logicalType;
    }

    public void setSearchAttribute(String search) {
        this._searchAttribute = search;
    }

    protected void setOrderNumber(int id) {
        this._orderNum = id;
    }

    public void addConnectionPoint(ConnectionPoint conn) {
        this.addConnectionPoint(conn, true);
    }

    public void addConnectionPoint(ConnectionPoint conn, boolean addOppositeSide) {
        this._connectionPointsMap.put(conn.getObjectID(), conn);
        if (addOppositeSide) {
            conn.addAssociatedObject(this, false);
        }
    }

    public void addReferencePoint(ReferencePoint ref) {
        this.addReferencePoint(ref, true);
    }

    protected void addReferencePoint(ReferencePoint ref, boolean addOppositeSide) {
        if (this._referencePointList == null) {
            this._referencePointList = new ArrayList();
        }
        this._referencePointList.add(ref);
        if (addOppositeSide) {
            ref.addAssociatedObject(this, false);
        }
    }

    public String getSearchAttribute() {
        return this._searchAttribute;
    }

    public Map getConnectionPoints() {
        return this._connectionPointsMap;
    }

    public List getConnectionPointsByType(String metadataType) {
        ArrayList<ConnectionPoint> returnValue = new ArrayList<ConnectionPoint>();
        Map cxPointMap = this.getConnectionPoints();
        Collection values = cxPointMap.values();
        for (ConnectionPoint cPoint : values) {
            if (!cPoint.getType().equals(metadataType)) continue;
            returnValue.add(cPoint);
        }
        return returnValue;
    }

    public List getReferencePoints() {
        return this._referencePointList;
    }

    public int getOrderNumber() {
        return this._orderNum;
    }

    public void setImportState(int state) {
        if (this._isTopLevel) {
            this._importState = state;
        }
    }

    public int getImportState() {
        return this._importState;
    }

    public void setTargetID(String id) {
        if (this._isTopLevel) {
            this._targetID = id;
        }
    }

    public String getTargetID() {
        return this._targetID;
    }

    protected void setUsageVersion(double version) {
        this._usageVersion = version;
    }

    public double getUsageVersion() {
        return this._usageVersion;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getType());
        sb.append(": Name=\"");
        sb.append(this.getName());
        sb.append("\", Id=\"");
        sb.append(this.getObjectID());
        sb.append("\"");
        return sb.toString();
    }
}

