/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.deployment;

import com.sas.management.deployment.AbstractDeployment;
import com.sas.management.deployment.BaseDeploymentObject;
import com.sas.management.deployment.ConnectionPoint;
import com.sas.management.deployment.DeploymentException;
import com.sas.management.deployment.DeploymentObject;
import com.sas.management.deployment.ExtractTemplate;
import com.sas.management.deployment.MessageUtil;
import com.sas.management.deployment.MetadataUtility;
import com.sas.management.deployment.ReferencePoint;
import com.sas.management.deployment.Substitution;
import com.sas.management.deployment.TemplateParser;
import com.sas.management.deployment.TopLevelObjectComparator;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MetadataResource;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Matcher;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class DeploymentMapping {
    protected static MetadataResource bundle = new MetadataResource(DeploymentMapping.class);
    private static final int MINIMUM_VERSION = 9133;
    public static final String METADATA_TYPE = "MetadataObjectType";
    private static final String IGNORE_IMPORT_ACTION = "Ignore";
    private static final String OFF_IMPORT_ACTION = "No";
    private static final String UPDATE_IMPORT_ACTION = "Update";
    private static final String REPLACE_IMPORT_ACTION = "Replace";
    private static boolean _verifyExtractVersion = true;
    private Map _extractTemplateMap = null;
    private Map _repositoryMap = null;
    private Map _sourceReposMap = null;
    private List _connectionsList = null;
    private List _directConnectionsList = null;
    private List _substitutionsList = null;
    private List _topLevelObjectsList = null;
    private List _referencesList = null;
    private Document _deployDocument = null;
    private String _extractXML = null;
    private Map _objectNodeMap;
    private Map _connectionNodeMap;
    private Map _topLevelMap = null;
    private MdFactory _factory;

    private DeploymentMapping(MdFactory factory) {
        this._factory = factory;
    }

    public DeploymentMapping(MdFactory factory, String extractXML) throws DeploymentException, RemoteException {
        this(factory);
        try {
            this._extractXML = extractXML;
            this.verifyExtractXML();
            String deployMap = this.getDeployMapFromExtractFile();
            if (deployMap == null) {
                throw new DeploymentException(bundle.getString("DeploymentMapping.InvalidFile.txt"));
            }
            this._deployDocument = this._factory.getOMIUtil().parseXML(deployMap);
            this.loadDeployMap();
        }
        catch (MdException e) {
            throw new DeploymentException(e);
        }
    }

    public DeploymentMapping(MdFactory factory, File extractFile) throws DeploymentException, IOException {
        this(factory, AbstractDeployment.getFileContents(extractFile));
    }

    public DeploymentMapping(MdFactory factory, File extractFile, File deployFile) throws DeploymentException, RemoteException, IOException {
        this(factory);
        try {
            this._extractXML = AbstractDeployment.getFileContents(extractFile);
            this.verifyExtractXML();
            String df = AbstractDeployment.getFileContents(deployFile);
            this._deployDocument = this._factory.getOMIUtil().parseXML(df);
            this.loadDeployMap();
        }
        catch (MdException e) {
            throw new DeploymentException(e);
        }
    }

    private void verifyExtractXML() throws DeploymentException {
        if (this._extractXML == null || this._extractXML.indexOf("<ExtractMetadata>") < 0) {
            throw new DeploymentException(bundle.getString("DeploymentMapping.InvalidFile.txt"));
        }
        if (_verifyExtractVersion && this.getExtractFileVersion() < 9133) {
            throw new DeploymentException(bundle.getString("DeploymentMapping.InvalidVersion.txt"));
        }
    }

    protected static void setVerifyExtractVersion(boolean verify) {
        _verifyExtractVersion = verify;
    }

    public boolean supportsMapping() {
        String topLevelAttr = " TLObjN";
        return this._extractXML.indexOf(" TLObjN") > -1;
    }

    public int getExtractFileVersion() {
        String version;
        String platformVersion = "PlatformVersion=\"";
        int index = this._extractXML.indexOf("PlatformVersion=\"");
        if (index > -1 && (version = this._extractXML.substring(index += 17, this._extractXML.indexOf(34, index))) != null && version.length() > 0) {
            StringBuffer sb = new StringBuffer(4);
            for (int i = 0; i < version.length(); ++i) {
                char c = version.charAt(i);
                if (c == '.') continue;
                sb.append(c);
            }
            try {
                return Integer.parseInt(sb.toString());
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return -1;
    }

    public Map getExtractTemplates() throws DeploymentException {
        if (this._extractTemplateMap != null) {
            return this._extractTemplateMap;
        }
        try {
            this._extractTemplateMap = new HashMap();
            int startIndex = this._extractXML.lastIndexOf("<ExtractTemplates>");
            int endIndex = this._extractXML.lastIndexOf("</ExtractTemplates>");
            String templates = this._extractXML.substring(startIndex, endIndex + 19);
            Document doc = this._factory.getOMIUtil().parseXML(templates);
            Node firstNode = doc.getFirstChild();
            NodeList nodeList = firstNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node nameNode;
                NamedNodeMap attrs;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || (attrs = node.getAttributes()) == null || (nameNode = attrs.getNamedItem("Type")) == null) continue;
                String name = nameNode.getNodeValue();
                ExtractTemplate template = new ExtractTemplate(name);
                Node searchNode = attrs.getNamedItem("search");
                if (searchNode == null) {
                    searchNode = attrs.getNamedItem("Search");
                }
                if (searchNode != null) {
                    template.setTemplateSearch(searchNode.getNodeValue());
                }
                NodeList childList = node.getChildNodes();
                for (int j = 0; j < childList.getLength(); ++j) {
                    Node childNode = childList.item(j);
                    if (childNode.getNodeType() != 1) continue;
                    template.setObjectType(childNode.getNodeName());
                    break;
                }
                this._extractTemplateMap.put(name, template);
            }
        }
        catch (Exception e) {
            throw new DeploymentException(e);
        }
        return this._extractTemplateMap;
    }

    public List getTopLevelObjects() {
        return this._topLevelObjectsList;
    }

    public List getDirectConnectionPoints() {
        return this._directConnectionsList;
    }

    public List getConnectionPoints() {
        return this._connectionsList;
    }

    public List getConnectionPointsByType(String metadataType) {
        ArrayList<ConnectionPoint> connections = new ArrayList<ConnectionPoint>();
        if (this._connectionsList != null) {
            for (ConnectionPoint pt : this._connectionsList) {
                if (!metadataType.equalsIgnoreCase(pt.getType())) continue;
                connections.add(pt);
            }
        }
        return connections;
    }

    public List getSubstitutions() {
        return this._substitutionsList;
    }

    public List getReferences() {
        if (this._referencesList == null) {
            this._referencesList = new ArrayList();
        }
        return this._referencesList;
    }

    public Map getSourceRepositoryMap() {
        return this._sourceReposMap;
    }

    public String getUpdatedExtractString() {
        int startIndex = this._extractXML.lastIndexOf("<DeployMap>");
        int endIndex = this._extractXML.lastIndexOf("</DeployMap>");
        if (startIndex > -1 && endIndex > startIndex) {
            StringBuffer sb = new StringBuffer(this._extractXML);
            sb.delete(startIndex, endIndex + 12);
            sb.insert(startIndex, this.getUpdatedDeployMapString());
            return sb.toString();
        }
        return this._extractXML;
    }

    public String getUpdatedDeployMapString() {
        StringBuffer sb = new StringBuffer();
        NodeList nodes = this._deployDocument.getChildNodes();
        int len = nodes.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = nodes.item(i);
            sb.append(MetadataUtility.createXMLStringForNode(node));
        }
        return sb.toString();
    }

    public void setTargetRepositoryIDs(Map reposMap) {
        if (reposMap == null || reposMap.size() == 0) {
            return;
        }
        this._repositoryMap = reposMap;
        Node parentNode = this._deployDocument.getFirstChild();
        NodeList list = parentNode.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node childNode = list.item(i);
            String name = childNode.getNodeName();
            if (name.charAt(0) == '#' || !name.equalsIgnoreCase("ReposMap")) continue;
            NodeList nodes = childNode.getChildNodes();
            for (int j = 0; j < nodes.getLength(); ++j) {
                Element element;
                String source;
                String target;
                Node reposNode = nodes.item(j);
                if (reposNode.getNodeType() != 1 || (target = (String)reposMap.get(source = (element = (Element)reposNode).getAttribute("Id"))) == null) continue;
                element.setAttribute("Deploy_Id", target);
            }
            break;
        }
    }

    public void updateConnectionPoint(ConnectionPoint conn) {
        if (this._connectionsList == null) {
            return;
        }
        int index = this._connectionsList.indexOf(conn);
        if (index > -1) {
            this._connectionsList.set(index, conn);
            Node node = (Node)this._connectionNodeMap.get(conn.getObjectID());
            if (node != null) {
                Element element = (Element)node;
                element.setAttribute("Desc", conn.getDescription());
                element.setAttribute("Deploy_Id", conn.getTargetObjectID());
                element.setAttribute("Search", conn.getSearchAttribute());
                if (conn.getConnectionAction() != 'D') {
                    element.setAttribute("ConnectionAction", String.valueOf(conn.getConnectionAction()));
                    element.setAttribute("ConnectionMessage", conn.getConnectionMessage());
                }
            }
        }
    }

    public void resetInactiveConnectionPoint(ConnectionPoint conn) {
        Element element;
        String attr;
        Node node = (Node)this._connectionNodeMap.get(conn.getObjectID());
        if (node != null && (attr = (element = (Element)node).getAttribute("Deploy_Action")).equalsIgnoreCase(IGNORE_IMPORT_ACTION)) {
            element.removeAttribute("Deploy_Action");
        }
    }

    public void updateSubstitution(Substitution sub) {
        if (this._substitutionsList == null) {
            return;
        }
        int index = this._substitutionsList.indexOf(sub);
        if (index > -1) {
            this._substitutionsList.set(index, sub);
            Node node = this.getNodeInDocument(sub, "Substitutions");
            if (node != null) {
                Element element = (Element)node;
                element.setAttribute(sub.getAttribute(), sub.getAttributeValue());
            }
        }
    }

    public void addReference(ReferencePoint ref) {
        if (this._referencesList == null) {
            this._referencesList = new ArrayList();
        }
        this._referencesList.add(ref);
    }

    public void removeReference(ReferencePoint ref) {
        if (this._referencesList == null) {
            this._referencesList = new ArrayList();
        }
        this._referencesList.remove(ref);
    }

    public Map getRepositoryMap() {
        return this._repositoryMap;
    }

    public void autoMapRepositories() throws DeploymentException {
        this._repositoryMap = new HashMap();
        NodeList list = this._deployDocument.getElementsByTagName("RepositoryBase");
        for (int i = 0; i < list.getLength(); ++i) {
            String targetName;
            String targetID;
            Node node = list.item(i);
            NamedNodeMap map = node.getAttributes();
            String sourceID = map.getNamedItem("Id").getNodeValue();
            String sourceName = map.getNamedItem("Name").getNodeValue();
            if (map.getNamedItem("Deploy_Id") != null && map.getNamedItem("Deploy_Id").getNodeValue().length() > 0) {
                targetID = map.getNamedItem("Deploy_Id").getNodeValue();
                targetName = this.getTargetRepositoryInfo(targetID, true);
                if (targetName == null) {
                    return;
                }
                ((Element)node).setAttribute("Deploy_Name", targetName);
            } else if (map.getNamedItem("Deploy_Name") != null && map.getNamedItem("Deploy_Name").getNodeValue().length() > 0) {
                targetName = map.getNamedItem("Deploy_Name").getNodeValue();
                targetID = this.getTargetRepositoryInfo(targetName, false);
                if (targetID == null) {
                    return;
                }
                ((Element)node).setAttribute("Deploy_Id", targetID);
            } else {
                targetID = this.getTargetRepositoryInfo(sourceName, false);
                if (targetID == null) {
                    return;
                }
                ((Element)node).setAttribute("Deploy_Id", targetID);
                ((Element)node).setAttribute("Deploy_Name", sourceName);
            }
            this._repositoryMap.put(sourceID, targetID);
        }
    }

    public void autoMapConnectionPoint(ConnectionPoint conn) throws DeploymentException {
        this.autoMapConnectionPoint(conn, true);
    }

    public void autoMapConnectionPoint(ConnectionPoint conn, boolean checkAction) throws DeploymentException {
        if (this._repositoryMap == null) {
            return;
        }
        String sourceReposID = "A0000001." + conn.getObjectID().substring(0, conn.getObjectID().indexOf(46));
        String targetReposID = (String)this._repositoryMap.get(sourceReposID);
        if (targetReposID == null) {
            return;
        }
        String serverXML = MetadataUtility.getMetadataObjects(this._factory, conn.getType(), conn.getSearchAttribute(), targetReposID);
        if (serverXML.length() <= 10) {
            if (checkAction) {
                AbstractDeployment.checkConnectionAction(String.valueOf(conn.getConnectionAction()), conn.getConnectionMessage());
            }
        } else {
            int start = serverXML.indexOf("Id=\"");
            int end = serverXML.indexOf(34, start + 4);
            if (start > -1) {
                String targetID = serverXML.substring(start + 4, end);
                conn.setTargetObjectID(targetID);
                this.updateConnectionPoint(conn);
            }
        }
    }

    public void redeployTopLevelObject(DeploymentObject topLevel) {
        NamedNodeMap map;
        Node deployNode;
        if (topLevel == null || !topLevel.isTopLevelObject()) {
            return;
        }
        Node node = (Node)this._objectNodeMap.get(topLevel.getObjectID());
        if (node != null && (deployNode = (map = node.getAttributes()).getNamedItem("Deploy_Action")) != null && deployNode.getNodeValue().equalsIgnoreCase(OFF_IMPORT_ACTION)) {
            map.removeNamedItem("Deploy_Action");
            this._topLevelObjectsList.add(topLevel);
        }
    }

    public void removeTopLevelObject(DeploymentObject topLevel) {
        Node node;
        if (topLevel == null || !topLevel.isTopLevelObject()) {
            return;
        }
        boolean remove = this._topLevelObjectsList.remove(topLevel);
        if (remove && (node = (Node)this._objectNodeMap.get(topLevel.getObjectID())) != null) {
            ((Element)node).setAttribute("Deploy_Action", OFF_IMPORT_ACTION);
        }
    }

    public void setImportStateForTopLevelObject(DeploymentObject topLevel, int state) {
        if (topLevel == null || !topLevel.isTopLevelObject()) {
            return;
        }
        Node node = (Node)this._objectNodeMap.get(topLevel.getObjectID());
        if (node != null && node.getNodeType() == 1) {
            switch (state) {
                case 0: {
                    ((Element)node).setAttribute("Deploy_Action", OFF_IMPORT_ACTION);
                    break;
                }
                case 2: {
                    if (topLevel.getTargetID() == null) break;
                    ((Element)node).setAttribute("Deploy_Id", topLevel.getTargetID());
                    ((Element)node).setAttribute("Deploy_Action", UPDATE_IMPORT_ACTION);
                    break;
                }
                case 3: {
                    if (topLevel.getTargetID() == null) break;
                    ((Element)node).setAttribute("Deploy_Id", topLevel.getTargetID());
                    ((Element)node).setAttribute("Deploy_Action", REPLACE_IMPORT_ACTION);
                    break;
                }
                default: {
                    ((Element)node).setAttribute("Deploy_Action", "");
                }
            }
        }
    }

    public void addSubsitution(Substitution sub) {
        for (Substitution s : this._substitutionsList) {
            if (!s.getObjectID().equals(sub.getObjectID()) || !s.getAttribute().equals(sub.getAttribute())) continue;
            this.removeSubstitution(s);
            break;
        }
        this._substitutionsList.add(sub);
        this.addNodeToDocument(sub, "Substitutions");
    }

    public void removeSubstitution(String objectID, String attributeName) {
        for (Substitution s : this._substitutionsList) {
            if (!s.getObjectID().equals(objectID) || !s.getAttribute().equals(attributeName)) continue;
            this.removeSubstitution(s);
            break;
        }
    }

    public void removeSubstitution(Substitution sub) {
        this._substitutionsList.remove(sub);
        this.removeNodeFromDocument(sub, "Substitutions");
    }

    public void removeUnusedSubstitutions() {
        Object[] subs = this._substitutionsList.toArray();
        int len = subs.length;
        for (int i = 0; i < len; ++i) {
            Substitution sub = (Substitution)subs[i];
            if (sub.hasAttributeBeenModified()) continue;
            this._substitutionsList.remove(sub);
            this.removeNodeFromDocument(sub, "Substitutions");
        }
    }

    public String getUserDefinedData() {
        Node parentNode = this._deployDocument.getFirstChild();
        NodeList list = parentNode.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node childNode = list.item(i);
            if (!childNode.getNodeName().equalsIgnoreCase("UserData")) continue;
            NodeList nodes = childNode.getChildNodes();
            for (int j = 0; j < nodes.getLength(); ++j) {
                Node dataNode = nodes.item(j);
                if (dataNode.getNodeType() != 4) continue;
                return dataNode.getNodeValue();
            }
        }
        return "";
    }

    public Map getAssociationsForObjects(List deployObjects, String template) throws DeploymentException {
        TemplateParser parser = new TemplateParser(deployObjects, this._extractXML, this._connectionsList);
        this.parseTemplate(parser, template);
        Map objects = parser.getObjectMap();
        return objects;
    }

    public Map getAssociationsForObject(DeploymentObject deployObject, String template) throws DeploymentException {
        ArrayList<DeploymentObject> list = new ArrayList<DeploymentObject>(1);
        list.add(deployObject);
        TemplateParser parser = new TemplateParser(list, this._extractXML, this._connectionsList);
        this.parseTemplate(parser, template);
        Map objects = parser.getObjectMap();
        return objects;
    }

    private void loadDeployMap() {
        NodeList reposList = this._deployDocument.getElementsByTagName("ReposMap");
        this.loadRepositoryMap(reposList.item(0));
        NodeList objectsList = this._deployDocument.getElementsByTagName("Objects");
        this.loadTopLevelObjects(objectsList.item(0));
        NodeList connectionsList = this._deployDocument.getElementsByTagName("Connections");
        this.loadConnectionPoints(connectionsList.item(0));
        NodeList substitutionsList = this._deployDocument.getElementsByTagName("Substitutions");
        this.loadSubstitutions(substitutionsList.item(0));
    }

    private void loadRepositoryMap(Node reposNode) {
        this._sourceReposMap = new HashMap();
        if (reposNode != null) {
            NodeList nodes = reposNode.getChildNodes();
            int length = nodes.getLength();
            for (int i = 0; i < length; ++i) {
                Node node = nodes.item(i);
                if (node.getNodeType() != 1) continue;
                NamedNodeMap attributes = node.getAttributes();
                Node idNode = attributes.getNamedItem("Id");
                Node nameNode = attributes.getNamedItem("Name");
                if (idNode == null) continue;
                this._sourceReposMap.put(idNode.getNodeValue(), nameNode == null ? null : nameNode.getNodeValue());
            }
        }
    }

    private void loadTopLevelObjects(Node objectsNode) {
        this._objectNodeMap = new HashMap();
        this._topLevelObjectsList = new ArrayList();
        if (objectsNode != null) {
            NodeList nodes = objectsNode.getChildNodes();
            TreeSet<DeploymentObject> set = new TreeSet<DeploymentObject>(new TopLevelObjectComparator());
            this._topLevelMap = new HashMap();
            int length = nodes.getLength();
            for (int i = 0; i < length; ++i) {
                Node idNode;
                Node searchNode;
                Node descNode;
                Node versionNode;
                Node node = nodes.item(i);
                if (node.getNodeType() != 1) continue;
                NamedNodeMap attributes = node.getAttributes();
                String type = node.getNodeName();
                String id = attributes.getNamedItem("Id").getNodeValue();
                String name = attributes.getNamedItem("Name").getNodeValue();
                DeploymentObject topLevelObject = new DeploymentObject(type, id, name, true);
                topLevelObject.setDocumentIndex(i);
                Node typeNode = attributes.getNamedItem("PublicType");
                if (typeNode != null) {
                    topLevelObject.setLogicalObjectType(typeNode.getNodeValue());
                } else {
                    typeNode = attributes.getNamedItem("TemplateName");
                    if (typeNode != null) {
                        topLevelObject.setLogicalObjectType(typeNode.getNodeValue());
                    } else {
                        typeNode = attributes.getNamedItem("ExtractTemplate");
                        if (typeNode != null) {
                            topLevelObject.setLogicalObjectType(typeNode.getNodeValue());
                        }
                    }
                }
                if ("BIPTree".equals(topLevelObject.getLogicalObjectType())) {
                    topLevelObject.setLogicalObjectType("Folder");
                }
                if ((versionNode = attributes.getNamedItem("UsageVersion")) != null) {
                    topLevelObject.setUsageVersion(Double.parseDouble(versionNode.getNodeValue()));
                }
                if ((descNode = attributes.getNamedItem("Desc")) != null) {
                    topLevelObject.setDescription(descNode.getNodeValue());
                }
                if ((searchNode = attributes.getNamedItem("Search")) != null) {
                    topLevelObject.setSearchAttribute(searchNode.getNodeValue());
                }
                if ((idNode = attributes.getNamedItem("TLObjN")) != null) {
                    String sID = idNode.getNodeValue();
                    int topLevelID = Integer.parseInt(sID);
                    topLevelObject.setOrderNumber(topLevelID);
                    this._topLevelMap.put(sID, topLevelObject);
                }
                this._objectNodeMap.put(id, node);
                set.add(topLevelObject);
            }
            this._topLevelObjectsList.addAll(set);
        }
    }

    private void loadConnectionPoints(Node connectionsNode) {
        this._connectionNodeMap = new HashMap();
        this._connectionsList = new ArrayList();
        this._directConnectionsList = new ArrayList();
        if (connectionsNode != null) {
            NodeList nodes = connectionsNode.getChildNodes();
            int length = nodes.getLength();
            for (int i = 0; i < length; ++i) {
                Node directConnectionsNode;
                Node topLevelNode;
                Node activeNode;
                Node targetIDNode;
                Node autoMappedNode;
                Node actionNode;
                Node messageNode;
                Node searchNode;
                Node node = nodes.item(i);
                if (node.getNodeType() != 1) continue;
                NamedNodeMap attributes = node.getAttributes();
                String type = node.getNodeName();
                String id = attributes.getNamedItem("Id").getNodeValue();
                String name = attributes.getNamedItem("Name").getNodeValue();
                ConnectionPoint conn = new ConnectionPoint(type, id, name);
                conn.setDocumentIndex(i);
                Node descNode = attributes.getNamedItem("Desc");
                if (descNode != null) {
                    conn.setDescription(descNode.getNodeValue());
                }
                if ((searchNode = attributes.getNamedItem("Search")) != null) {
                    conn.setSearchAttribute(searchNode.getNodeValue());
                }
                if ((messageNode = attributes.getNamedItem("ConnectionMessage")) != null) {
                    conn.setConnectionMessage(messageNode.getNodeValue());
                }
                if ((actionNode = attributes.getNamedItem("ConnectionAction")) != null && actionNode.getNodeValue().length() > 0) {
                    conn.setConnectionAction(actionNode.getNodeValue().charAt(0));
                }
                if ((autoMappedNode = attributes.getNamedItem("AutoMap")) != null && autoMappedNode.getNodeValue().equalsIgnoreCase("Y")) {
                    conn.setConnectionAutoMapped(true);
                }
                if ((targetIDNode = attributes.getNamedItem("Deploy_Id")) != null && targetIDNode.getNodeValue().length() > 0) {
                    conn.setTargetObjectID(targetIDNode.getNodeValue());
                }
                if ((activeNode = attributes.getNamedItem("Deploy_Action")) != null && activeNode.getNodeValue().equalsIgnoreCase(IGNORE_IMPORT_ACTION)) {
                    conn.setActive(false);
                }
                if ((topLevelNode = attributes.getNamedItem("TLObjN")) != null && topLevelNode.getNodeValue().length() > 0) {
                    conn.addAssociatedObjects(this.getAssociatedObjects(topLevelNode.getNodeValue()));
                }
                if ((directConnectionsNode = attributes.getNamedItem("DirTLObjN")) != null) {
                    String nodeValue = directConnectionsNode.getNodeValue();
                    if (nodeValue.length() != 0) {
                        this._directConnectionsList.add(conn);
                    }
                } else {
                    this._directConnectionsList.add(conn);
                }
                this._connectionNodeMap.put(id, node);
                this._connectionsList.add(conn);
            }
        }
    }

    private void loadSubstitutions(Node substitutionsNode) {
        this._substitutionsList = new ArrayList();
        if (substitutionsNode != null) {
            NodeList nodes = substitutionsNode.getChildNodes();
            int length = nodes.getLength();
            for (int i = 0; i < length; ++i) {
                Node node = nodes.item(i);
                if (node.getNodeType() != 1) continue;
                NamedNodeMap attributes = node.getAttributes();
                Node idNode = attributes.getNamedItem("Id");
                Node nameNode = attributes.getNamedItem("Name");
                Node subAttr = this.getSubstitutionAttribute(attributes);
                if (subAttr == null || idNode == null || nameNode == null) continue;
                Node topLevelNode = attributes.getNamedItem("TLObjN");
                String id = idNode.getNodeValue();
                String name = nameNode.getNodeValue();
                Substitution sub = new Substitution(node.getNodeName(), id, name, subAttr.getNodeName(), subAttr.getNodeValue());
                sub.setDocumentIndex(i);
                if (topLevelNode != null) {
                    String num = topLevelNode.getNodeValue();
                    sub.setTopLevelObjectForSubstitution(this.getTopLevelObject(num));
                }
                this._substitutionsList.add(sub);
            }
        }
    }

    private Node getSubstitutionAttribute(NamedNodeMap attributes) {
        block5: {
            block4: {
                boolean namePresent;
                boolean topLevelIDPresent;
                boolean bl = topLevelIDPresent = attributes.getNamedItem("TLObjN") != null;
                if (topLevelIDPresent) break block4;
                boolean bl2 = namePresent = attributes.getNamedItem("Name") != null;
                if (namePresent) {
                    return attributes.getNamedItem("Name");
                }
                int numAttributes = attributes.getLength();
                for (int j = numAttributes - 1; j >= 0; --j) {
                    Node attr = attributes.item(j);
                    String attrName = attr.getNodeName();
                    if (attrName.equalsIgnoreCase("Id") || attrName.equalsIgnoreCase("Name")) continue;
                    return attr;
                }
                break block5;
            }
            int numAttributes = attributes.getLength();
            if (numAttributes == 3) {
                return attributes.getNamedItem("Name");
            }
            if (numAttributes <= 3) break block5;
            for (int j = numAttributes - 1; j >= 0; --j) {
                Node attr = attributes.item(j);
                String attrName = attr.getNodeName();
                if (attrName.equalsIgnoreCase("Id") || attrName.equalsIgnoreCase("Name") || attrName.equalsIgnoreCase("TLObjN")) continue;
                return attr;
            }
        }
        return null;
    }

    private void addNodeToDocument(BaseDeploymentObject obj, String parentNodeName) {
        NodeList list = this._deployDocument.getElementsByTagName(parentNodeName);
        if (list.getLength() > 0) {
            Node parentNode = list.item(0);
            if (obj instanceof ConnectionPoint) {
                ConnectionPoint conn = (ConnectionPoint)obj;
                Element element = this._deployDocument.createElement(conn.getType());
                element.setAttribute("Id", conn.getObjectID());
                element.setAttribute("Name", conn.getName());
                element.setAttribute("Desc", conn.getDescription());
                element.setAttribute("Search", conn.getSearchAttribute());
                if (conn.getConnectionAction() != 'D') {
                    element.setAttribute("ConnectionAction", String.valueOf(conn.getConnectionAction()));
                    element.setAttribute("ConnectionMessage", conn.getConnectionMessage());
                }
                parentNode.appendChild(element);
            } else if (obj instanceof Substitution) {
                Substitution sub = (Substitution)obj;
                Element element = this._deployDocument.createElement(sub.getType());
                element.setAttribute("Id", sub.getObjectID());
                element.setAttribute(sub.getAttribute(), sub.getAttributeValue());
                parentNode.appendChild(element);
            }
        }
    }

    private void removeNodeFromDocument(BaseDeploymentObject obj, String parentNodeName) {
        boolean isSubstitution = obj instanceof Substitution;
        NodeList list = this._deployDocument.getElementsByTagName(parentNodeName);
        if (list.getLength() > 0) {
            Node parentNode = list.item(0);
            NodeList nodes = parentNode.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                String id;
                NamedNodeMap attributes;
                Node childNode = nodes.item(i);
                if (childNode.getNodeType() != 1 || !childNode.getNodeName().equalsIgnoreCase(obj.getType()) || (attributes = childNode.getAttributes()) == null || !(id = attributes.getNamedItem("Id").getNodeValue()).equalsIgnoreCase(obj.getObjectID())) continue;
                if (!isSubstitution) {
                    parentNode.removeChild(childNode);
                }
                Substitution sub = (Substitution)obj;
                Node subAttr = this.getSubstitutionAttribute(attributes);
                if (subAttr == null || !sub.getAttribute().equals(subAttr.getNodeName())) continue;
                parentNode.removeChild(childNode);
            }
        }
    }

    private Node getNodeInDocument(BaseDeploymentObject object, String parentNodeName) {
        boolean isSubstitution = object instanceof Substitution;
        NodeList list = this._deployDocument.getElementsByTagName(parentNodeName);
        if (list.getLength() > 0) {
            Node parentNode = list.item(0);
            NodeList nodes = parentNode.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                String id;
                NamedNodeMap attributes;
                Node childNode = nodes.item(i);
                if (childNode.getNodeType() != 1 || !childNode.getNodeName().equalsIgnoreCase(object.getType()) || (attributes = childNode.getAttributes()) == null || !(id = attributes.getNamedItem("Id").getNodeValue()).equalsIgnoreCase(object.getObjectID())) continue;
                if (!isSubstitution) {
                    return childNode;
                }
                Substitution sub = (Substitution)object;
                Node subAttr = this.getSubstitutionAttribute(attributes);
                if (subAttr == null || !sub.getAttribute().equals(subAttr.getNodeName())) continue;
                return childNode;
            }
        }
        return null;
    }

    private List getAssociatedObjects(String topLevelNumbers) {
        ArrayList<DeploymentObject> associatedObjects = new ArrayList<DeploymentObject>();
        if (topLevelNumbers.indexOf(91) > -1) {
            String s = topLevelNumbers.substring(topLevelNumbers.indexOf(91) + 1, topLevelNumbers.indexOf(93));
            StringTokenizer st = new StringTokenizer(s, " ");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                DeploymentObject obj = (DeploymentObject)this._topLevelMap.get(token);
                if (obj == null) continue;
                associatedObjects.add(obj);
            }
        } else {
            DeploymentObject obj = (DeploymentObject)this._topLevelMap.get(topLevelNumbers);
            if (obj != null) {
                associatedObjects.add(obj);
            }
        }
        return associatedObjects;
    }

    private DeploymentObject getTopLevelObject(String topLevelNumber) {
        return (DeploymentObject)this._topLevelMap.get(topLevelNumber);
    }

    private String getDeployMapFromExtractFile() {
        int startIndex = this._extractXML.lastIndexOf("<DeployMap>");
        int endIndex = this._extractXML.lastIndexOf("</DeployMap>");
        if (startIndex > -1 && endIndex > startIndex) {
            return this._extractXML.substring(startIndex, endIndex + 12);
        }
        return null;
    }

    private void parseTemplate(DefaultHandler dh, String template) throws DeploymentException {
        try {
            if (template != null && template.length() > 0) {
                SAXParserFactory parserFactory = SAXParserFactory.newInstance();
                parserFactory.setNamespaceAware(false);
                parserFactory.setValidating(true);
                parserFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                parserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                SAXParser parser = parserFactory.newSAXParser();
                StringReader sr = new StringReader(template);
                InputSource is = new InputSource(sr);
                parser.parse(is, dh);
                parser = null;
            }
        }
        catch (Exception e) {
            throw new DeploymentException(e);
        }
    }

    private String getTargetRepositoryInfo(String reposInfo, boolean searchForName) throws DeploymentException {
        String targetRepos = null;
        String serverXML = MetadataUtility.getRepositories(this._factory, reposInfo, searchForName);
        Matcher m = AbstractDeployment.attributesPattern.matcher(serverXML);
        int count = 0;
        while (m.find()) {
            if (count > 0) {
                MessageUtil.printMessage(bundle.messageString("AbstractDeployment.Warning.MultipleRepositories.txt", (Object)reposInfo), 1);
                break;
            }
            targetRepos = searchForName ? m.group(2) : m.group(1);
            ++count;
        }
        if (count == 0) {
            MessageUtil.printMessage(bundle.messageString("AbstractDeployment.Warning.TargetReposNotFound.txt", (Object)reposInfo), 2);
            return null;
        }
        return targetRepos;
    }
}

