/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.deployment;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class DeployOutputParser {
    private Map _deployedObjectsMap = new HashMap();

    DeployOutputParser() {
    }

    public void parse(String deploymentXML) throws SAXException {
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setNamespaceAware(false);
            parserFactory.setValidating(true);
            parserFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            parserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            SAXParser parser = parserFactory.newSAXParser();
            if (deploymentXML != null && deploymentXML.length() > 0) {
                StringReader sr = new StringReader(deploymentXML);
                InputSource is = new InputSource(sr);
                parser.parse(is, (DefaultHandler)new OutputHandler());
                Object var3_5 = null;
            }
        }
        catch (ParserConfigurationException pce) {
            throw new SAXException(pce);
        }
        catch (IOException io) {
            throw new SAXException(io);
        }
    }

    public Map getDeployedObjectsMap() {
        return this._deployedObjectsMap;
    }

    protected class OutputHandler
    extends DefaultHandler {
        boolean _processingMetadata = false;
        boolean _processingTopLevelObjects = false;

        protected OutputHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this._processingTopLevelObjects) {
                if (attributes != null) {
                    String sourceID = attributes.getValue("Source_Id");
                    String targetID = attributes.getValue("Id");
                    DeployOutputParser.this._deployedObjectsMap.put(sourceID, targetID);
                }
            } else if (qName.equalsIgnoreCase("Metadata")) {
                this._processingMetadata = true;
            } else if (this._processingMetadata && qName.equalsIgnoreCase("Objects")) {
                this._processingTopLevelObjects = true;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this._processingTopLevelObjects && qName.equalsIgnoreCase("Objects")) {
                throw new SAXException("Finished Parsing");
            }
        }
    }
}

