/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.deployment;

import com.sas.management.deployment.AbstractDeployment;
import com.sas.management.deployment.DeploymentException;
import com.sas.management.deployment.MessageUtil;
import com.sas.management.deployment.MetadataUtility;
import com.sas.metadata.remote.MetadataResource;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class DeployFile {
    protected static MetadataResource bundle = new MetadataResource(DeployFile.class);
    String m_DeployFileString = "";
    StreamSource m_InputSource = null;
    String m_InputFileName = "";
    String m_FileName = null;

    public DeployFile(String InputFile) {
        this.m_InputSource = new StreamSource(InputFile);
        this.m_InputFileName = InputFile;
    }

    public DeployFile(String InputFile, String xmlSource) {
        this.m_InputSource = new StreamSource(new StringReader(xmlSource));
        this.m_InputFileName = InputFile;
    }

    public void createDeployFile() throws DeploymentException {
        String xslfile = "res/DeployFile.xsl";
        try {
            InputStream is = this.getClass().getResourceAsStream(xslfile);
            if (is == null) {
                throw new DeploymentException(bundle.getString("DeployFile.CouldNotFindFile.txt"));
            }
            StringWriter outWriter = new StringWriter();
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer(new StreamSource(is));
            transformer.transform(this.m_InputSource, new StreamResult(outWriter));
            this.m_DeployFileString = outWriter.toString();
            transformer = null;
            tFactory = null;
        }
        catch (TransformerConfigurationException e) {
            MessageUtil.printStackTrace(e);
            throw new DeploymentException(e);
        }
        catch (TransformerException e) {
            MessageUtil.printStackTrace(e);
            throw new DeploymentException(e);
        }
    }

    public void writeToFile() throws IOException {
        try {
            this.m_FileName = AbstractDeployment.getFileLocation() + this.createDeployFileName(this.m_InputFileName);
            FileOutputStream fs = new FileOutputStream(this.m_FileName);
            OutputStreamWriter ow = new OutputStreamWriter((OutputStream)fs, "UTF-8");
            BufferedWriter bw = new BufferedWriter(ow);
            String st = MetadataUtility.formatXML(this.m_DeployFileString);
            bw.write(st);
            bw.close();
        }
        catch (IOException e) {
            MessageUtil.printMessage(bundle.getString("DeployFile.WriteError.txt"), 2);
            MessageUtil.printStackTrace(e);
            throw e;
        }
    }

    public String createDeployFileName(String defaultName) {
        StringBuffer fileName = new StringBuffer(this.m_InputFileName);
        if (fileName.indexOf("_deployFile.xml") == -1 && fileName.indexOf("_DeployFile.xml") == -1) {
            int index;
            int i = fileName.indexOf("_extract");
            if (i > -1) {
                fileName.delete(i, i + 8);
            }
            if ((index = fileName.lastIndexOf(".")) < 0) {
                index = fileName.length();
            }
            fileName.insert(index, "_deployFile");
            index = fileName.lastIndexOf(".");
            if (index < 0) {
                fileName.append(".xml");
            } else {
                fileName.replace(index, fileName.length(), ".xml");
            }
        }
        return fileName.toString();
    }

    public String getDeployFileName() {
        return this.m_FileName;
    }
}

