/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.deployment;

import com.sas.management.deployment.AbstractDeployment;
import com.sas.management.deployment.DeployFile;
import com.sas.management.deployment.DeploymentException;
import com.sas.management.deployment.MessageUtil;
import com.sas.metadata.remote.MetadataResource;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DeployDocument {
    protected static MetadataResource bundle = new MetadataResource(DeployFile.class);
    File m_file = null;

    public DeployDocument(String inputFile) {
        this.m_file = new File(inputFile);
    }

    public Document getDocument() throws DeploymentException {
        Document doc = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            String xml = AbstractDeployment.getFileContents(this.m_file);
            StringReader sr = new StringReader(xml);
            InputSource is = new InputSource(sr);
            doc = db.parse(is);
        }
        catch (ParserConfigurationException e1) {
            MessageUtil.printStackTrace(e1);
            throw new DeploymentException(e1);
        }
        catch (IOException io) {
            MessageUtil.printStackTrace(io);
            throw new DeploymentException(io);
        }
        catch (SAXException se) {
            MessageUtil.printStackTrace(se);
            throw new DeploymentException(se);
        }
        finally {
            if (doc == null) {
                MessageUtil.printMessage(bundle.getString("DeployDocument.ParseError.txt"), 2);
            }
        }
        return doc;
    }
}

