/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.deployment;

import com.sas.management.deployment.AbstractDeployment;
import com.sas.management.deployment.DeploymentException;
import com.sas.management.deployment.MessageUtil;
import com.sas.management.deployment.MetadataUtility;
import com.sas.management.deployment.Report;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.workspace.WorkspaceFile;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DeleteMetadata
extends AbstractDeployment {
    private String m_DeletedXML;

    public DeleteMetadata(MdFactory factory) {
        super(factory);
    }

    public DeleteMetadata(WorkspaceFile file) throws RemoteException, MdException {
        this.m_WorkspaceFile = file;
    }

    public DeleteMetadata(String host, String port, String user, String password) throws RemoteException, MdException {
        this.m_Host = host;
        this.m_Port = port;
        this.m_User = user;
        this.m_Password = password;
    }

    public void initialize() throws DeploymentException, RemoteException {
        if (this.m_ConnectionHandle == null) {
            this.makeOMRConnection();
        }
    }

    public void delete(File extractXML, String repositoryName, String metadataType, String metadataSearch) throws DeploymentException, IOException {
        if (!(null != metadataSearch && metadataSearch.trim().length() != 0 || null != metadataType && metadataType.trim().length() != 0)) {
            this.xpathDelete(extractXML, repositoryName);
            return;
        }
        String reposId = null;
        try {
            reposId = this._factory.getRepositoryUtil().getRepositoryIDFromName(repositoryName);
        }
        catch (MdException e) {
            throw new DeploymentException(e);
        }
        String serverXML = MetadataUtility.getMetadataObjects(this._factory, metadataType, metadataSearch, reposId);
        if (serverXML.length() <= 10) {
            MessageUtil.printMessage(bundle.messageString("ExtractMetadata.Warning.ObjectsNotFound.txt", (Object)metadataType, (Object)metadataSearch), 1);
            this._rc |= 1;
        } else {
            String metadataId = null;
            int start = serverXML.indexOf("Id=\"");
            int end = serverXML.indexOf(34, start + 4);
            if (start > -1 && end > -1) {
                metadataId = serverXML.substring(start + 4, end);
            }
            String xml = DeleteMetadata.getFileContents(extractXML);
            String deleteXML = this.transformExtractedXML(xml, metadataType, metadataId, reposId);
            this.m_DeletedXML = MetadataUtility.DoRequest(this._factory, deleteXML);
        }
    }

    public void xpathDelete(File extractXML, String repositoryName) throws DeploymentException, IOException {
        String reposId = null;
        try {
            reposId = this._factory.getRepositoryUtil().getRepositoryIDFromName(repositoryName);
        }
        catch (MdException e) {
            throw new DeploymentException(e);
        }
        String xml = DeleteMetadata.getFileContents(extractXML);
        ArrayList<ExtractInformation> searchCriteria = new ArrayList<ExtractInformation>();
        ArrayList<DeleteInformation> searchIds = new ArrayList<DeleteInformation>();
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            String metadataType;
            InputSource is = new InputSource(new StringReader(xml));
            String xpathExpression = "/ExtractMetadata/Metadata/DeployMap/Objects/*";
            NodeList nodes = (NodeList)xpath.evaluate(xpathExpression, is, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node n = nodes.item(i);
                metadataType = n.getNodeName();
                String search = (String)xpath.evaluate("@Search", n, XPathConstants.STRING);
                if (null == search || search.trim().length() == 0) {
                    throw new DeploymentException("Unable to find Search attribute for node: " + n + ". The metadata file is incorrectly structured.");
                }
                String publicType = (String)xpath.evaluate("@PublicType", n, XPathConstants.STRING);
                String extractTemplate = (String)xpath.evaluate("@ExtractTemplate", n, XPathConstants.STRING);
                if (publicType != null && (null == extractTemplate || extractTemplate.trim().length() == 0)) {
                    throw new DeploymentException("Unable to find ExtractTemplate attribute for node: " + n + ". The metadata file is incorrectly structured.");
                }
                searchCriteria.add(new ExtractInformation(metadataType, publicType, search, extractTemplate));
            }
            for (ExtractInformation ei : searchCriteria) {
                metadataType = ei.getMetadataType();
                String publicType = ei.getPublicType();
                String search = ei.getSearch();
                String serverXML = MetadataUtility.getMetadataObjects(this._factory, metadataType, search, reposId);
                if (serverXML.length() <= "<Objects/>".length()) {
                    MessageUtil.printMessage(bundle.messageString("ExtractMetadata.Warning.ObjectsNotFound.txt", (Object)metadataType, (Object)search), 1);
                    this._rc |= 1;
                    continue;
                }
                InputSource is2 = new InputSource(new StringReader(serverXML));
                String id = (String)xpath.evaluate("/Objects/" + metadataType + "/@" + "Id", is2, XPathConstants.STRING);
                searchIds.add(new DeleteInformation(metadataType, publicType, id, ei.getTemplate()));
            }
        }
        catch (Exception e) {
            throw new DeploymentException(e);
        }
        String deleteXML = this.domTransformExtractedXML(xml, searchIds, reposId);
        this.m_DeletedXML = MetadataUtility.DoRequest(this._factory, deleteXML);
    }

    public void createReport() {
        this.createReport("delete_report.html");
    }

    public void createReport(String fileName) {
        if (this.m_DeletedXML != null) {
            Report rep = new Report(fileName, this.m_DeletedXML);
            rep.writeToFile();
        }
    }

    private String transformExtractedXML(String input, String metadataType, String metadataId, String reposId) {
        StringBuffer sb = new StringBuffer(input);
        int index = sb.indexOf("ExtractMetadata");
        if (index > -1) {
            sb.replace(index, index + "ExtractMetadata".length(), "DeleteMetadata");
            int lastIndex = sb.lastIndexOf("ExtractMetadata");
            if (lastIndex > index) {
                sb.replace(lastIndex, lastIndex + "ExtractMetadata".length(), "DeleteMetadata");
            }
        }
        int metadataStartIndex = sb.indexOf("<Metadata>");
        int metadataEndIndex = sb.indexOf("</Metadata>");
        if (metadataStartIndex > -1 && metadataEndIndex > -1) {
            int endExtractTemplateIndex;
            String templateName = null;
            String extractTemplateStartTagStr = "<ExtractTemplate ";
            int extractTemplateIndex = sb.indexOf(extractTemplateStartTagStr);
            if (extractTemplateIndex > -1 && (endExtractTemplateIndex = sb.indexOf(">", extractTemplateIndex + extractTemplateStartTagStr.length())) > -1) {
                String extractTemplateStartStr = sb.substring(extractTemplateIndex, endExtractTemplateIndex);
                int templateNameIndex = extractTemplateStartStr.indexOf("TemplateName");
                if (templateNameIndex == -1) {
                    templateNameIndex = extractTemplateStartStr.indexOf("Type");
                }
                if (templateNameIndex > -1) {
                    int firstQuoteIndex = extractTemplateStartStr.indexOf(34, templateNameIndex);
                    int secondQuoteIndex = extractTemplateStartStr.indexOf(34, firstQuoteIndex + 1);
                    if (firstQuoteIndex > -1 && secondQuoteIndex > -1) {
                        templateName = extractTemplateStartStr.substring(firstQuoteIndex + 1, secondQuoteIndex);
                    }
                }
            }
            String delStr = "<" + metadataType + " " + "Id" + "=\"" + metadataId + "\" " + (templateName == null ? "" : "TemplateName=\"" + templateName + "\" ") + "/>";
            sb.replace(metadataStartIndex += "<Metadata>".length(), metadataEndIndex, delStr);
        }
        int startReposIdIndex = sb.indexOf("<ReposId>");
        int endReposIdIndex = sb.indexOf("</ReposId>");
        if (startReposIdIndex > -1 && endReposIdIndex > -1) {
            sb.replace(startReposIdIndex += "<ReposId>".length(), endReposIdIndex, reposId);
        }
        int flags = 402654212;
        int startFlagsIndex = sb.indexOf("<Flags>");
        int endFlagsIndex = -1;
        if (startFlagsIndex == -1) {
            startFlagsIndex = sb.indexOf("<Flags/>");
            if (startFlagsIndex == -1) {
                startFlagsIndex = sb.indexOf("<Flags />");
                endFlagsIndex = startFlagsIndex + "<Flags />".length();
            } else {
                endFlagsIndex = startFlagsIndex + "<Flags/>".length();
            }
        } else {
            endFlagsIndex = sb.indexOf("</Flags>") + "</Flags>".length();
        }
        if (startFlagsIndex > -1 && endFlagsIndex > -1) {
            String flagsStr = "<Flags>" + flags + "</Flags>";
            sb.replace(startFlagsIndex, endFlagsIndex, flagsStr);
        }
        return sb.toString();
    }

    private String domTransformExtractedXML(String input, List<DeleteInformation> information, String reposId) throws DeploymentException, IOException {
        NodeList metadataChildren;
        Node metadataNode;
        Node flagsNode;
        Node extractMetadataNode;
        XPath xpath = XPathFactory.newInstance().newXPath();
        InputSource is = new InputSource(new StringReader(input));
        HashSet<String> templateNames = null;
        try {
            extractMetadataNode = (Node)xpath.evaluate("/ExtractMetadata", is, XPathConstants.NODE);
            flagsNode = (Node)xpath.evaluate("Flags", extractMetadataNode, XPathConstants.NODE);
            if (flagsNode == null) {
                flagsNode = (Node)xpath.evaluate("flags", extractMetadataNode, XPathConstants.NODE);
            }
            metadataNode = (Node)xpath.evaluate("Metadata", extractMetadataNode, XPathConstants.NODE);
            metadataChildren = (NodeList)xpath.evaluate("*", metadataNode, XPathConstants.NODESET);
            Node extractTemplates = (Node)xpath.evaluate("Options/ExtractTemplates", extractMetadataNode, XPathConstants.NODE);
            if (extractTemplates == null) {
                extractTemplates = (Node)xpath.evaluate("Options/Templates", extractMetadataNode, XPathConstants.NODE);
            }
            if (extractTemplates != null) {
                NodeList extractTemplateList = (NodeList)xpath.evaluate("ExtractTemplate", extractTemplates, XPathConstants.NODESET);
                if (extractTemplateList == null) {
                    extractTemplateList = (NodeList)xpath.evaluate("Template", extractTemplates, XPathConstants.NODESET);
                }
                if (extractTemplateList != null) {
                    templateNames = new HashSet<String>();
                    for (int i = 0; i < extractTemplateList.getLength(); ++i) {
                        NamedNodeMap attrs = extractTemplateList.item(i).getAttributes();
                        if (attrs == null) continue;
                        Object type = attrs.getNamedItem("Type");
                        if (type == null) {
                            type = attrs.getNamedItem("TemplateName");
                        }
                        if (type == null) continue;
                        templateNames.add(type.getNodeValue());
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Unable to properly parse xml via XPath", e);
        }
        Document d = metadataNode.getOwnerDocument();
        d.renameNode(extractMetadataNode, null, "DeleteMetadata");
        for (int i = 0; i < metadataChildren.getLength(); ++i) {
            metadataNode.removeChild(metadataChildren.item(i));
        }
        Collections.reverse(information);
        boolean templateFound = false;
        for (DeleteInformation info : information) {
            Element e = d.createElement(info.getMetadataType());
            e.setAttribute("Id", info.getId());
            String templateName = info.getTemplateName();
            if (templateName != null && templateNames != null && templateNames.contains(templateName)) {
                e.setAttribute("TemplateName", templateName);
                templateFound = true;
            }
            metadataNode.appendChild(e);
        }
        int flags = 402654208;
        if (templateFound) {
            flags |= 4;
        }
        flagsNode.setNodeValue(String.valueOf(flags));
        flagsNode.setTextContent(String.valueOf(flags));
        StringWriter sw = new StringWriter();
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(d);
            StreamResult result = new StreamResult(sw);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw new DeploymentException(e);
        }
        return sw.toString();
    }

    class ExtractInformation {
        private String metadataType;
        private String publicType;
        private String search;
        private String template;

        public ExtractInformation(String metadataType, String publicType, String search, String template) {
            this.metadataType = metadataType;
            this.publicType = publicType;
            this.search = search;
            this.template = template;
        }

        public String getMetadataType() {
            return this.metadataType;
        }

        public String getPublicType() {
            return this.publicType;
        }

        public String getSearch() {
            return this.search;
        }

        public String getTemplate() {
            return this.template;
        }
    }

    class DeleteInformation {
        private String metadataType;
        private String publicType;
        private String id;
        private String template;

        public DeleteInformation(String metadataType, String publicType, String id, String template) {
            this.metadataType = metadataType;
            this.publicType = publicType;
            this.id = id;
            this.template = template;
        }

        public String getMetadataType() {
            return this.metadataType;
        }

        public String getPublicType() {
            return this.publicType;
        }

        public String getId() {
            return this.id;
        }

        public String getTemplateName() {
            return this.template;
        }
    }
}

