/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.jta;

import com.atomikos.datasource.RecoverableResource;
import com.atomikos.datasource.ResourceException;
import com.atomikos.datasource.TransactionalResource;
import com.atomikos.datasource.xa.XAResourceTransaction;
import com.atomikos.datasource.xa.XATransactionalResource;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.Synchronization;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TimeoutException;
import com.atomikos.icatch.config.Configuration;
import com.atomikos.icatch.jta.ExtendedSystemException;
import com.atomikos.icatch.jta.Sync2Sync;
import com.atomikos.icatch.jta.XAResourceKey;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.recovery.TxState;
import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;

class TransactionImp
implements Transaction {
    private static final Logger LOGGER = LoggerFactory.createLogger(TransactionImp.class);
    private CompositeTransaction compositeTransaction;
    private Map<XAResourceKey, XAResourceTransaction> xaResourceToResourceTransactionMap_;
    private Map<Object, Object> transactionSynchronizationRegistryMap;
    private List<jakarta.transaction.Synchronization> interposedSynchronizations;

    private static void rethrowAsJtaRollbackException(String msg, Throwable cause) throws jakarta.transaction.RollbackException {
        jakarta.transaction.RollbackException ret = new jakarta.transaction.RollbackException(msg);
        ret.initCause(cause);
        throw ret;
    }

    private static void rethrowAsJtaHeuristicMixedException(String msg, Throwable cause) throws HeuristicMixedException {
        HeuristicMixedException ret = new HeuristicMixedException(msg);
        ret.initCause(cause);
        throw ret;
    }

    private static void rethrowAsJtaHeuristicRollbackException(String msg, Throwable cause) throws HeuristicRollbackException {
        HeuristicRollbackException ret = new HeuristicRollbackException(msg);
        ret.initCause(cause);
        throw ret;
    }

    TransactionImp(CompositeTransaction ct) {
        this.compositeTransaction = ct;
        this.xaResourceToResourceTransactionMap_ = new HashMap<XAResourceKey, XAResourceTransaction>();
        this.interposedSynchronizations = new ArrayList<jakarta.transaction.Synchronization>();
        this.transactionSynchronizationRegistryMap = new HashMap<Object, Object>();
    }

    CompositeTransaction getCT() {
        return this.compositeTransaction;
    }

    private synchronized void addXAResourceTransaction(XAResourceTransaction restx, XAResource xares) {
        this.xaResourceToResourceTransactionMap_.put(new XAResourceKey(xares), restx);
    }

    private void assertActiveOrSuspended(XAResourceTransaction restx) {
        if (!restx.isActive() && !restx.isXaSuspended()) {
            LOGGER.logWarning("Unexpected resource transaction state for " + restx);
        }
    }

    private synchronized XAResourceTransaction findXAResourceTransaction(XAResource xares) {
        XAResourceTransaction ret = null;
        ret = this.xaResourceToResourceTransactionMap_.get(new XAResourceKey(xares));
        if (ret != null) {
            this.assertActiveOrSuspended(ret);
        }
        return ret;
    }

    private synchronized void removeXAResourceTransaction(XAResource xares) {
        this.xaResourceToResourceTransactionMap_.remove(new XAResourceKey(xares));
    }

    public void registerSynchronization(jakarta.transaction.Synchronization s) throws IllegalStateException, SystemException {
        try {
            Sync2Sync adaptor = new Sync2Sync(s);
            this.compositeTransaction.registerSynchronization((Synchronization)adaptor);
        }
        catch (SysException se) {
            String msg = "Unexpected error during registerSynchronization";
            LOGGER.logWarning(msg, (Throwable)se);
            throw new ExtendedSystemException(msg, se);
        }
    }

    public int getStatus() {
        TxState state = this.compositeTransaction.getState();
        switch (state) {
            case IN_DOUBT: {
                return 2;
            }
            case PREPARING: {
                return 7;
            }
            case ACTIVE: {
                return 0;
            }
            case MARKED_ABORT: {
                return 1;
            }
            case COMMITTING: {
                return 8;
            }
            case ABORTING: {
                return 9;
            }
            case COMMITTED: {
                return 3;
            }
            case ABORTED: {
                return 4;
            }
        }
        return 5;
    }

    public void commit() throws jakarta.transaction.RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException, SecurityException {
        this.registerInterposedSynchronizations();
        try {
            this.compositeTransaction.commit();
        }
        catch (HeurHazardException hh) {
            TransactionImp.rethrowAsJtaHeuristicMixedException(hh.getMessage(), hh);
        }
        catch (HeurMixedException hm) {
            TransactionImp.rethrowAsJtaHeuristicMixedException(hm.getMessage(), hm);
        }
        catch (SysException se) {
            LOGGER.logError(se.getMessage(), (Throwable)se);
            throw new ExtendedSystemException(se.getMessage(), se);
        }
        catch (TimeoutException to) {
            this.rethrowAsJtaTimeoutException(to.getMessage());
        }
        catch (RollbackException rb) {
            String msg = rb.getMessage();
            Throwable cause = rb.getCause();
            if (cause == null) {
                cause = rb;
            }
            TransactionImp.rethrowAsJtaRollbackException(msg, cause);
        }
    }

    private void rethrowAsJtaTimeoutException(String msg) throws com.atomikos.icatch.jta.TimeoutException {
        throw new com.atomikos.icatch.jta.TimeoutException(msg);
    }

    public void rollback() throws IllegalStateException, SystemException {
        try {
            this.compositeTransaction.rollback();
        }
        catch (SysException se) {
            LOGGER.logError(se.getMessage(), (Throwable)se);
            throw new ExtendedSystemException(se.getMessage(), se);
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.compositeTransaction.setRollbackOnly();
    }

    public boolean enlistResource(XAResource xares) throws jakarta.transaction.RollbackException, SystemException, IllegalStateException {
        TransactionalResource res = null;
        XAResourceTransaction restx = null;
        int status = this.getStatus();
        switch (status) {
            case 1: 
            case 4: 
            case 9: {
                String msg = "Transaction rollback - enlisting more resources is useless.";
                LOGGER.logWarning(msg);
                throw new jakarta.transaction.RollbackException(msg);
            }
            case 2: 
            case 3: 
            case 5: {
                String msg = "Enlisting more resources is no longer permitted: transaction is in state " + this.compositeTransaction.getState();
                LOGGER.logWarning(msg);
                throw new IllegalStateException(msg);
            }
        }
        XAResourceTransaction suspendedXAResourceTransaction = this.findXAResourceTransaction(xares);
        if (suspendedXAResourceTransaction != null) {
            if (!suspendedXAResourceTransaction.isXaSuspended()) {
                String msg = "The given XAResource instance is being enlisted a second time without delist in between?";
                LOGGER.logWarning(msg);
                throw new IllegalStateException(msg);
            }
            try {
                suspendedXAResourceTransaction.setXAResource(xares);
                suspendedXAResourceTransaction.xaResume();
            }
            catch (XAException xaerr) {
                if (100 <= xaerr.errorCode && xaerr.errorCode <= 107) {
                    TransactionImp.rethrowAsJtaRollbackException("Transaction was already rolled back inside the back-end resource. Further enlists are useless.", xaerr);
                }
                throw new ExtendedSystemException("Unexpected error during enlist", xaerr);
            }
        }
        res = this.findRecoverableResourceForXaResource(xares);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug("enlistResource ( " + xares + " ) with transaction " + this.toString());
        }
        if (res == null) {
            String msg = "There is no registered resource that can recover the given XAResource instance. \nPlease register a corresponding resource first.";
            LOGGER.logWarning(msg);
            throw new SystemException(msg);
        }
        try {
            restx = (XAResourceTransaction)res.getResourceTransaction(this.compositeTransaction);
            restx.setXAResource(xares);
            restx.resume();
        }
        catch (ResourceException re) {
            throw new ExtendedSystemException("Unexpected error during enlist", re);
        }
        catch (RuntimeException e) {
            throw e;
        }
        this.addXAResourceTransaction(restx, xares);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransactionalResource findRecoverableResourceForXaResource(XAResource xares) {
        XATransactionalResource ret = null;
        Class<Configuration> clazz = Configuration.class;
        synchronized (Configuration.class) {
            Collection resources = Configuration.getResources();
            for (RecoverableResource rres : resources) {
                XATransactionalResource xatxres;
                if (!(rres instanceof XATransactionalResource) || !(xatxres = (XATransactionalResource)rres).usesXAResource(xares)) continue;
                ret = xatxres;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return ret;
        }
    }

    public boolean delistResource(XAResource xares, int flag) throws IllegalStateException, SystemException {
        XAResourceTransaction active;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug("delistResource ( " + xares + " ) with transaction " + this.toString());
        }
        if ((active = this.findXAResourceTransaction(xares)) == null) {
            String msg = "Illegal attempt to delist an XAResource instance that was not previously enlisted.";
            LOGGER.logWarning(msg);
            throw new IllegalStateException(msg);
        }
        if (flag == 0x4000000 || flag == 0x20000000) {
            try {
                active.suspend();
            }
            catch (ResourceException re) {
                throw new ExtendedSystemException("Error in delisting the given XAResource", re);
            }
            this.removeXAResourceTransaction(xares);
            if (flag == 0x20000000) {
                this.setRollbackOnly();
            }
        } else if (flag == 0x2000000) {
            try {
                active.xaSuspend();
            }
            catch (XAException xaerr) {
                throw new ExtendedSystemException("Error in delisting the given XAResource", xaerr);
            }
        } else {
            String msg = "Unknown delist flag: " + flag;
            LOGGER.logWarning(msg);
            throw new SystemException(msg);
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof TransactionImp)) {
            return false;
        }
        TransactionImp other = (TransactionImp)o;
        return this.compositeTransaction.isSameTransaction(other.compositeTransaction);
    }

    public int hashCode() {
        return this.compositeTransaction.hashCode();
    }

    public String toString() {
        return this.compositeTransaction.getTid().toString();
    }

    void suspendEnlistedXaResources() throws ExtendedSystemException {
        for (XAResourceTransaction resTx : this.xaResourceToResourceTransactionMap_.values()) {
            try {
                resTx.xaSuspend();
            }
            catch (XAException e) {
                throw new ExtendedSystemException("Error in suspending the given XAResource", e);
            }
        }
    }

    void resumeEnlistedXaReources() throws ExtendedSystemException {
        Iterator<XAResourceTransaction> xaResourceTransactions = this.xaResourceToResourceTransactionMap_.values().iterator();
        while (xaResourceTransactions.hasNext()) {
            XAResourceTransaction resTx = xaResourceTransactions.next();
            try {
                resTx.xaResume();
                xaResourceTransactions.remove();
            }
            catch (XAException e) {
                throw new ExtendedSystemException("Error in resuming the given XAResource", e);
            }
        }
    }

    public void registerInterposedSynchronization(jakarta.transaction.Synchronization s) throws IllegalStateException, SystemException {
        this.interposedSynchronizations.add(s);
    }

    private void registerInterposedSynchronizations() throws IllegalStateException, SystemException {
        for (jakarta.transaction.Synchronization s : this.interposedSynchronizations) {
            this.registerSynchronization(s);
        }
    }

    public void putResource(Object key, Object value) {
        this.transactionSynchronizationRegistryMap.put(key, value);
    }

    public Object getResource(Object key) {
        return this.transactionSynchronizationRegistryMap.get(key);
    }
}

