/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa.session;

import com.atomikos.datasource.pool.event.PooledConnectionReusedAcrossTransactionBoundaryEvent;
import com.atomikos.datasource.xa.XATransactionalResource;
import com.atomikos.datasource.xa.session.InvalidSessionHandleStateException;
import com.atomikos.datasource.xa.session.SessionHandleStateChangeListener;
import com.atomikos.datasource.xa.session.TransactionContext;
import com.atomikos.datasource.xa.session.UnexpectedTransactionContextException;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.event.Event;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.logging.StackTrace;
import com.atomikos.publish.EventPublisher;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.transaction.xa.XAResource;

public class SessionHandleState {
    private static final Logger LOGGER = LoggerFactory.createLogger(SessionHandleState.class);
    private TransactionContext currentContext;
    private Set<TransactionContext> allContexts;
    private XATransactionalResource resource;
    private XAResource xaResource;
    private boolean erroneous;
    private boolean closed;
    private boolean supportsTmJoin;
    private List<SessionHandleStateChangeListener> sessionHandleStateChangeListeners = new ArrayList<SessionHandleStateChangeListener>();

    public SessionHandleState(XATransactionalResource resource, XAResource xaResource, boolean supportsTmJoin) {
        this.resource = resource;
        this.xaResource = xaResource;
        this.allContexts = new HashSet<TransactionContext>();
        this.erroneous = false;
        this.closed = true;
        this.supportsTmJoin = supportsTmJoin;
    }

    public synchronized boolean isTerminated() {
        boolean terminated = true;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace("isTerminated: checking " + this.allContexts.size() + " contexts...");
        }
        Iterator<TransactionContext> it = this.allContexts.iterator();
        while (it.hasNext()) {
            TransactionContext b = it.next();
            if (b.isTerminated()) {
                it.remove();
                continue;
            }
            terminated = false;
        }
        if (terminated) {
            this.currentContext = null;
        }
        return terminated;
    }

    public synchronized void notifySessionBorrowed() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": notifySessionBorrowed");
        }
        if (!this.reuseCurrentContext()) {
            this.currentContext = new TransactionContext(this.resource, this.xaResource);
            this.allContexts.add(this.currentContext);
        }
        this.closed = false;
    }

    private boolean reuseCurrentContext() {
        boolean ret = false;
        if (!this.supportsTmJoin && this.currentContext != null) {
            ret = true;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySessionClosed() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": entering notifySessionClosed");
        }
        boolean notifyOfClosedEvent = false;
        SessionHandleState sessionHandleState = this;
        synchronized (sessionHandleState) {
            boolean alreadyTerminated = this.isTerminated();
            for (TransactionContext b : this.allContexts) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.logTrace("delegating session close to " + b);
                }
                b.sessionClosed(this.supportsTmJoin);
            }
            this.closed = true;
            if (this.isTerminated() && !alreadyTerminated) {
                notifyOfClosedEvent = true;
            }
        }
        if (notifyOfClosedEvent) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace(this + ": all contexts terminated, firing TerminatedEvent");
            }
            this.fireTerminatedEvent();
        }
    }

    public synchronized void notifyBeforeUse(CompositeTransaction ct) throws InvalidSessionHandleStateException {
        block13: {
            if (this.closed && !this.isActiveInTransaction(ct)) {
                throw new InvalidSessionHandleStateException("The underlying XA session is closed");
            }
            try {
                TransactionContext suspended = null;
                if (ct != null) {
                    Iterator<TransactionContext> it = this.allContexts.iterator();
                    while (it.hasNext() && suspended == null) {
                        TransactionContext b = it.next();
                        if (!b.isSuspendedInTransaction(ct)) continue;
                        suspended = b;
                    }
                }
                if (suspended != null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.logDebug(this + ": resuming suspended XA context for transaction " + ct.getTid());
                    }
                    this.currentContext = suspended;
                    this.currentContext.transactionResumed();
                    break block13;
                }
                try {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.logTrace(this + ": checking XA context for transaction " + ct);
                    }
                    this.currentContext.checkEnlistBeforeUse(ct);
                }
                catch (UnexpectedTransactionContextException txBoundaryPassed) {
                    EventPublisher.INSTANCE.publish((Event)new PooledConnectionReusedAcrossTransactionBoundaryEvent(this.resource.getName(), StackTrace.toString((StackTraceElement[])txBoundaryPassed.getStackTrace())));
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.logDebug(this + ": suspending existing XA context and creating a new one for transaction " + ct);
                    }
                    this.currentContext.transactionSuspended();
                    this.currentContext = new TransactionContext(this.resource, this.xaResource);
                    this.allContexts.add(this.currentContext);
                    try {
                        this.currentContext.checkEnlistBeforeUse(ct);
                    }
                    catch (UnexpectedTransactionContextException e) {
                        String msg = "Unexpected error in session handle";
                        LOGGER.logError(msg, (Throwable)e);
                        throw new InvalidSessionHandleStateException(msg);
                    }
                }
            }
            catch (InvalidSessionHandleStateException e) {
                this.notifySessionErrorOccurred();
                throw e;
            }
        }
    }

    public boolean isErroneous() {
        return this.erroneous;
    }

    public void notifySessionErrorOccurred() {
        this.erroneous = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTransactionTerminated(CompositeTransaction ct) {
        boolean notifyOfTerminatedEvent = false;
        SessionHandleState sessionHandleState = this;
        synchronized (sessionHandleState) {
            boolean alreadyTerminated = this.isTerminated();
            for (TransactionContext b : this.allContexts) {
                b.transactionTerminated(ct);
            }
            if (this.isTerminated() && !alreadyTerminated) {
                notifyOfTerminatedEvent = true;
            }
        }
        if (notifyOfTerminatedEvent) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace(this + ": all contexts terminated, firing TerminatedEvent for " + this);
            }
            this.fireTerminatedEvent();
        }
    }

    public void registerSessionHandleStateChangeListener(SessionHandleStateChangeListener listener) {
        this.sessionHandleStateChangeListeners.add(listener);
    }

    public void unregisterSessionHandleStateChangeListener(SessionHandleStateChangeListener listener) {
        this.sessionHandleStateChangeListeners.remove(listener);
    }

    private void fireTerminatedEvent() {
        for (int i = 0; i < this.sessionHandleStateChangeListeners.size(); ++i) {
            SessionHandleStateChangeListener listener = this.sessionHandleStateChangeListeners.get(i);
            listener.onTerminated();
        }
    }

    public String toString() {
        return "sessionHandleState (" + this.allContexts.size() + " context(s), isTerminated = " + this.isTerminated() + ") for resource " + this.resource.getName();
    }

    public synchronized boolean isActiveInTransaction(CompositeTransaction tx) {
        boolean ret = false;
        if (this.currentContext != null && tx != null) {
            ret = this.currentContext.isInTransaction(tx);
        }
        return ret;
    }

    public synchronized boolean isInactiveInTransaction(CompositeTransaction tx) {
        boolean ret = false;
        if (this.closed && this.currentContext != null && tx != null) {
            ret = this.currentContext.isInactiveInTransaction(tx);
        }
        return ret;
    }
}

