/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa;

import com.atomikos.datasource.xa.XID;

public class XidUtils {
    private static final byte[] HEX_CHAR_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};

    static String byteArrayToHexString(byte[] raw) {
        byte[] hex = new byte[2 * raw.length];
        int index = 0;
        for (byte b : raw) {
            int v = b & 0xFF;
            hex[index++] = HEX_CHAR_TABLE[v >>> 4];
            hex[index++] = HEX_CHAR_TABLE[v & 0xF];
        }
        return new String(hex);
    }

    static byte[] hexStringToByteArray(String hexValue) {
        if (hexValue.length() % 2 != 0) {
            throw new IllegalArgumentException("Not a hex-encoded XID: the supplied part \"" + hexValue + "\" must have an even number of characters");
        }
        byte[] ret = new byte[hexValue.length() / 2];
        try {
            for (int i = 0; i < ret.length; ++i) {
                int c = Integer.parseInt(hexValue.substring(2 * i, 2 * i + 2), 16);
                ret[i] = (byte)c;
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Not a hex-encoded XID: the supplied part \"" + hexValue + "\" contains non-hex characters");
        }
        return ret;
    }

    public static String decodeHexString(String hexValue) {
        if (hexValue.indexOf(":") <= 0) {
            throw new IllegalArgumentException("Not a hex-encoded XID: the supplied value \"" + hexValue + "\" does not contain 2 parts separated by \":\"");
        }
        String[] parts = hexValue.split(":");
        String globalTransactionId = new String(XidUtils.hexStringToByteArray(parts[0]));
        String branchQualifier = new String(XidUtils.hexStringToByteArray(parts[1]));
        return globalTransactionId + ":" + branchQualifier;
    }

    public static String toHexString(XID xid) {
        return XidUtils.byteArrayToHexString(xid.getGlobalTransactionId()) + ":" + XidUtils.byteArrayToHexString(xid.getBranchQualifier());
    }
}

