/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa;

import java.io.Serializable;
import javax.transaction.xa.Xid;

public class XID
implements Serializable,
Xid {
    public static final int BYTES_PER_XID = 132;
    private static final long serialVersionUID = 4796496938014754464L;
    private static final int DEFAULT_FORMAT = 1096044365;
    private String cachedToStringForPerformance;
    private final int formatId;
    private final byte[] branchQualifier;
    private final byte[] globalTransactionId;
    private final String coordinatorId;
    private final String uniqueResourceName;
    private final String branchQualifierAsString;
    private static final byte[] HEX_CHAR_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};

    public XID(String tid, String branchQualifier, String uniqueResourceName) {
        this.formatId = 1096044365;
        this.uniqueResourceName = uniqueResourceName;
        this.coordinatorId = tid;
        this.globalTransactionId = tid.getBytes();
        if (this.globalTransactionId.length > 64) {
            throw new RuntimeException("Max global tid length exceeded: " + this.globalTransactionId.length + " whereas max. allowed: " + 64 + " for supplied tid: " + tid);
        }
        this.branchQualifierAsString = new String(branchQualifier);
        this.branchQualifier = branchQualifier.getBytes();
        if (this.branchQualifier.length > 64) {
            throw new RuntimeException("Max branch qualifier length exceeded; " + this.branchQualifier.length + " whereas max. allowed: " + 64 + " for supplied branch qualifier: " + branchQualifier);
        }
    }

    public XID(Xid xid) {
        this(xid, null);
    }

    public XID(Xid xid, String uniqueResourceName) {
        this.formatId = xid.getFormatId();
        this.globalTransactionId = xid.getGlobalTransactionId();
        this.branchQualifier = xid.getBranchQualifier();
        this.coordinatorId = new String(xid.getGlobalTransactionId());
        this.branchQualifierAsString = new String(xid.getBranchQualifier());
        this.uniqueResourceName = uniqueResourceName;
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.branchQualifier;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.globalTransactionId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof XID) {
            XID xid = (XID)obj;
            return this.toString().equals(xid.toString());
        }
        return false;
    }

    public String toString() {
        if (this.cachedToStringForPerformance == null) {
            String gtrid = XID.byteArrayToHexString(this.getGlobalTransactionId());
            String bqual = XID.byteArrayToHexString(this.getBranchQualifier());
            this.cachedToStringForPerformance = "xid://" + gtrid + ":" + bqual;
        }
        return this.cachedToStringForPerformance;
    }

    private static String byteArrayToHexString(byte[] raw) {
        byte[] hex = new byte[2 * raw.length];
        int index = 0;
        for (byte b : raw) {
            int v = b & 0xFF;
            hex[index++] = HEX_CHAR_TABLE[v >>> 4];
            hex[index++] = HEX_CHAR_TABLE[v & 0xF];
        }
        return new String(hex);
    }

    public String getUri() {
        return this.toString();
    }

    public String getBranchQualifierAsString() {
        return this.branchQualifierAsString;
    }

    public String getCoordinatorId() {
        return this.coordinatorId;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String getUniqueResourceName() {
        return this.uniqueResourceName;
    }
}

