/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa;

import com.atomikos.datasource.ResourceException;
import com.atomikos.datasource.ResourceTransaction;
import com.atomikos.datasource.xa.XAExceptionHelper;
import com.atomikos.datasource.xa.XATransactionalResource;
import com.atomikos.datasource.xa.XID;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.SysException;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.recovery.TxState;
import com.atomikos.util.Assert;
import java.util.Map;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;

public class XAResourceTransaction
implements ResourceTransaction,
Participant {
    private static final Logger LOGGER = LoggerFactory.createLogger(XAResourceTransaction.class);
    static final long serialVersionUID = -8227293322090019196L;
    private String tid;
    private String root;
    private boolean isXaSuspended;
    private TxState state;
    private String resourcename;
    private final transient XID xid;
    private final transient XATransactionalResource resource;
    private transient XAResource xaresource;
    private transient boolean knownInResource;
    private transient int timeout;

    private static String interpretErrorCode(String resourceName, String opCode, XID xid, int errorCode) {
        String msg = XAExceptionHelper.convertErrorCodeToVerboseMessage(errorCode);
        return "XA resource '" + resourceName + "': " + opCode + " for XID '" + xid + "' raised " + errorCode + ": " + msg;
    }

    XAResourceTransaction(XATransactionalResource resource, CompositeTransaction transaction, String root) {
        Assert.notNull((String)"resource cannot be null", (Object)resource);
        this.resource = resource;
        this.timeout = (int)transaction.getTimeout() / 1000;
        this.tid = transaction.getCompositeCoordinator().getCoordinatorId();
        this.root = root;
        this.resourcename = resource.getName();
        this.xid = this.resource.createXid(this.tid);
        this.setState(TxState.ACTIVE);
        this.isXaSuspended = false;
        this.knownInResource = false;
    }

    void setState(TxState state) {
        if (state.isHeuristic()) {
            String msg = "Heuristic termination of " + this.toString() + " with state " + state;
            LOGGER.logDebug(msg);
        }
        this.state = state;
    }

    protected void testOrRefreshXAResourceFor2PC() throws ResourceException {
        block6: {
            try {
                if (this.state == TxState.HEUR_HAZARD) {
                    this.forceRefreshXAConnection();
                } else if (this.xaresource != null) {
                    this.assertConnectionIsStillAlive();
                }
            }
            catch (XAException xa) {
                if (!LOGGER.isTraceEnabled()) break block6;
                LOGGER.logTrace(this.resourcename + ": XAResource needs refresh?", (Throwable)xa);
            }
        }
        if (this.xaresource == null) {
            this.xaresource = this.resource.getXAResource();
        }
    }

    private void assertConnectionIsStillAlive() throws XAException {
        this.xaresource.isSameRM(this.xaresource);
    }

    private void forceRefreshXAConnection() throws XAException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this.resourcename + ": forcing refresh of XAConnection...");
        }
        try {
            this.xaresource = this.resource.refreshXAConnection();
        }
        catch (ResourceException re) {
            LOGGER.logWarning(this.resourcename + ": could not refresh XAConnection", (Throwable)re);
        }
    }

    private void terminateInResource() {
        if (this.resource != null) {
            this.resource.removeSiblingMap(this.root);
        }
    }

    public String getTid() {
        return this.tid;
    }

    public synchronized void suspend() throws ResourceException {
        if (this.state.equals((Object)TxState.ACTIVE)) {
            int flags = this.getEndFlags();
            String logFlag = this.getEndLogFlag(flags);
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.logDebug("XAResource.end ( " + this.xid + " , " + logFlag + " ) on resource " + this.resourcename + " represented by XAResource instance " + this.xaresource);
                }
                this.xaresource.end(this.xid, flags);
                this.setState(TxState.LOCALLY_DONE);
            }
            catch (XAException xaerr) {
                String msg = XAResourceTransaction.interpretErrorCode(this.resourcename, "end", this.xid, xaerr.errorCode);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.logTrace(msg, (Throwable)xaerr);
                }
                this.setState(TxState.MARKED_ABORT);
            }
        }
    }

    boolean supportsTmJoin() {
        return this.resource.supportsTmJoin() && !this.isActive();
    }

    private String getEndLogFlag(int flags) {
        String ret = "XAResource.TMSUCCESS";
        if (flags != 0x4000000) {
            ret = Integer.toString(flags);
        }
        return ret;
    }

    private int getEndFlags() {
        return this.resource.getEndExistingXaBranchFlags();
    }

    private String getStartNewXaBranchLogFlag(int flags) {
        String ret = "XAResource.TMNOFLAGS";
        if (flags != 0) {
            ret = Integer.toString(flags);
        }
        return ret;
    }

    public synchronized void resume() throws ResourceException {
        int flag = 0;
        String logFlag = "";
        if (this.state.equals((Object)TxState.LOCALLY_DONE)) {
            flag = this.getJoinExistingXaBranchFlags();
            logFlag = this.getJoinExistingXaBranchLogFlag(flag);
        } else if (!this.knownInResource) {
            flag = this.getStartNewXaBranchFlags();
            logFlag = this.getStartNewXaBranchLogFlag(flag);
        } else {
            throw new IllegalStateException("Wrong state for resume: " + this.state);
        }
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug("XAResource.start ( " + this.xid + " , " + logFlag + " ) on resource " + this.resourcename + " represented by XAResource instance " + this.xaresource);
            }
            this.xaresource.start(this.xid, flag);
        }
        catch (XAException xaerr) {
            String msg = XAResourceTransaction.interpretErrorCode(this.resourcename, "resume", this.xid, xaerr.errorCode);
            LOGGER.logWarning(msg, (Throwable)xaerr);
            throw new ResourceException(msg, (Throwable)xaerr);
        }
        this.setState(TxState.ACTIVE);
        this.knownInResource = true;
    }

    private String getJoinExistingXaBranchLogFlag(int flag) {
        String ret = "XAResource.TMJOIN";
        if (flag != 0x200000) {
            ret = Integer.toString(flag);
        }
        return ret;
    }

    private int getJoinExistingXaBranchFlags() {
        return this.resource.getJoinExistingXaBranchFlags();
    }

    private int getStartNewXaBranchFlags() {
        return this.resource.getStartNewXaBranchFlags();
    }

    public void setCascadeList(Map<String, Integer> allParticipants) throws SysException {
    }

    public Object getState() {
        return this.state;
    }

    private boolean beforePrepare() {
        return TxState.ACTIVE.equals((Object)this.state) || TxState.LOCALLY_DONE.equals((Object)this.state);
    }

    public void setGlobalSiblingCount(int count) {
    }

    public synchronized void forget() {
        this.terminateInResource();
        try {
            if (this.xaresource != null) {
                this.xaresource.forget(this.xid);
            }
        }
        catch (Exception err) {
            LOGGER.logTrace("Error forgetting xid: " + this.xid, (Throwable)err);
        }
        this.setState(TxState.TERMINATED);
    }

    public synchronized int prepare() throws RollbackException, HeurHazardException, HeurMixedException, SysException {
        int ret = 0;
        this.terminateInResource();
        if (TxState.ACTIVE == this.state) {
            this.suspend();
        }
        if (this.state == TxState.IN_DOUBT) {
            return 0;
        }
        if (this.state != TxState.LOCALLY_DONE) {
            throw new SysException("Wrong state for prepare: " + this.state);
        }
        try {
            this.testOrRefreshXAResourceFor2PC();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace("About to call prepare on XAResource instance: " + this.xaresource);
            }
            ret = this.xaresource.prepare(this.xid);
        }
        catch (XAException xaerr) {
            String msg = XAResourceTransaction.interpretErrorCode(this.resourcename, "prepare", this.xid, xaerr.errorCode);
            if (100 <= xaerr.errorCode && xaerr.errorCode <= 107) {
                LOGGER.logDebug(msg, (Throwable)xaerr);
                throw new RollbackException(msg, (Throwable)xaerr);
            }
            LOGGER.logWarning(msg, (Throwable)xaerr);
            throw new HeurHazardException();
        }
        this.setState(TxState.IN_DOUBT);
        if (ret == 3) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug("XAResource.prepare ( " + this.xid + " ) returning XAResource.XA_RDONLY on resource " + this.resourcename + " represented by XAResource instance " + this.xaresource);
            }
            return 0;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug("XAResource.prepare ( " + this.xid + " ) returning OK on resource " + this.resourcename + " represented by XAResource instance " + this.xaresource);
        }
        return 1;
    }

    XAResource getXAResource() {
        return this.xaresource;
    }

    public synchronized void rollback() throws HeurCommitException, HeurMixedException, HeurHazardException, SysException {
        this.terminateInResource();
        if (this.rollbackShouldDoNothing()) {
            return;
        }
        if (this.state.equals((Object)TxState.TERMINATED)) {
            return;
        }
        if (this.state.equals((Object)TxState.HEUR_MIXED)) {
            throw new HeurMixedException();
        }
        if (this.state.equals((Object)TxState.HEUR_COMMITTED)) {
            throw new HeurCommitException();
        }
        try {
            if (this.state.equals((Object)TxState.ACTIVE)) {
                this.suspend();
            }
            this.testOrRefreshXAResourceFor2PC();
            if (this.xaresource == null) {
                throw new HeurHazardException("XAResourceTransaction " + this.getXid() + ": no XAResource to rollback?");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug("XAResource.rollback ( " + this.xid + " ) on resource " + this.resourcename + " represented by XAResource instance " + this.xaresource);
            }
            this.xaresource.rollback(this.xid);
        }
        catch (ResourceException resErr) {
            throw new SysException("Error in rollback: " + resErr.getMessage(), (Throwable)resErr);
        }
        catch (XAException xaerr) {
            String msg = XAResourceTransaction.interpretErrorCode(this.resourcename, "rollback", this.xid, xaerr.errorCode);
            if (100 <= xaerr.errorCode && xaerr.errorCode <= 107) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.logTrace(msg);
                }
            }
            switch (xaerr.errorCode) {
                case 8: {
                    LOGGER.logWarning(msg, (Throwable)xaerr);
                    this.setState(TxState.HEUR_HAZARD);
                    throw new HeurHazardException();
                }
                case 5: {
                    LOGGER.logWarning(msg, (Throwable)xaerr);
                    this.setState(TxState.HEUR_MIXED);
                    throw new HeurMixedException();
                }
                case 7: {
                    LOGGER.logWarning(msg, (Throwable)xaerr);
                    this.setState(TxState.HEUR_COMMITTED);
                    throw new HeurCommitException();
                }
                case 6: {
                    LOGGER.logWarning(msg, (Throwable)xaerr);
                    this.forget();
                    break;
                }
                case -6: 
                case -4: {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.logTrace(msg, (Throwable)xaerr);
                        LOGGER.logTrace("Rollback rejected by resource - XID already rolled back in resource?");
                    }
                    this.setState(TxState.TERMINATED);
                    break;
                }
                default: {
                    LOGGER.logWarning(msg, (Throwable)xaerr);
                    this.setState(TxState.HEUR_HAZARD);
                    throw new HeurHazardException();
                }
            }
        }
        this.setState(TxState.TERMINATED);
    }

    private boolean rollbackShouldDoNothing() {
        return !this.knownInResource && this.beforePrepare();
    }

    public synchronized void commit(boolean onePhase) throws HeurRollbackException, HeurHazardException, HeurMixedException, RollbackException, SysException {
        this.terminateInResource();
        if (this.state.equals((Object)TxState.TERMINATED)) {
            return;
        }
        if (this.state.equals((Object)TxState.HEUR_MIXED)) {
            throw new HeurMixedException();
        }
        if (this.state.equals((Object)TxState.HEUR_ABORTED)) {
            throw new HeurRollbackException();
        }
        if (this.state.equals((Object)TxState.MARKED_ABORT)) {
            throw new RollbackException();
        }
        if (onePhase) {
            if (this.xaresource == null) {
                throw new RollbackException(this.toString() + ": no XAResource to commit");
            }
            try {
                if (TxState.ACTIVE.equals((Object)this.state)) {
                    this.suspend();
                }
            }
            catch (ResourceException re) {
                throw new RollbackException(re.getMessage());
            }
        }
        try {
            if (!onePhase) {
                this.testOrRefreshXAResourceFor2PC();
                if (this.xaresource == null) {
                    String msg = this.toString() + ": no XAResource to commit - recovery will handle this in the background...";
                    LOGGER.logWarning(msg);
                    throw new HeurHazardException(msg);
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug("XAResource.commit ( " + this.xid + " , " + onePhase + " ) on resource " + this.resourcename + " represented by XAResource instance " + this.xaresource);
            }
            this.xaresource.commit(this.xid, onePhase);
        }
        catch (XAException xaerr) {
            String msg = XAResourceTransaction.interpretErrorCode(this.resourcename, "commit", this.xid, xaerr.errorCode);
            if (100 <= xaerr.errorCode && xaerr.errorCode <= 107) {
                if (!onePhase) {
                    throw new SysException(msg, (Throwable)xaerr);
                }
                LOGGER.logDebug(msg, (Throwable)xaerr);
                throw new RollbackException("Already rolled back in resource.", (Throwable)xaerr);
            }
            switch (xaerr.errorCode) {
                case 8: {
                    LOGGER.logWarning(msg, (Throwable)xaerr);
                    this.setState(TxState.HEUR_HAZARD);
                    throw new HeurHazardException();
                }
                case 5: {
                    LOGGER.logWarning(msg, (Throwable)xaerr);
                    this.setState(TxState.HEUR_MIXED);
                    throw new HeurMixedException();
                }
                case 7: {
                    LOGGER.logWarning(msg, (Throwable)xaerr);
                    this.forget();
                    break;
                }
                case 6: {
                    LOGGER.logWarning(msg, (Throwable)xaerr);
                    this.setState(TxState.HEUR_ABORTED);
                    throw new HeurRollbackException();
                }
                case -6: 
                case -4: {
                    if (!onePhase) {
                        LOGGER.logDebug(msg, (Throwable)xaerr);
                        LOGGER.logDebug("Commit rejected by resource - XID already committed in resource?");
                        this.setState(TxState.TERMINATED);
                        break;
                    }
                    LOGGER.logDebug(msg, (Throwable)xaerr);
                    throw new RollbackException("Commit rejected by resource - XID will timeout and rollback inside the resource", (Throwable)xaerr);
                }
                default: {
                    LOGGER.logWarning(msg, (Throwable)xaerr);
                    this.setState(TxState.HEUR_HAZARD);
                    throw new HeurHazardException();
                }
            }
        }
        this.setState(TxState.TERMINATED);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof XAResourceTransaction)) {
            return false;
        }
        XAResourceTransaction other = (XAResourceTransaction)o;
        return this.xid.equals(other.xid);
    }

    public int hashCode() {
        return this.xid.hashCode();
    }

    public String toString() {
        return "XAResourceTransaction: " + this.xid;
    }

    public XID getXid() {
        return this.xid;
    }

    public void setXAResource(XAResource xaresource) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": about to switch to XAResource " + xaresource);
        }
        this.xaresource = xaresource;
        this.propagateJtaTimeoutIfDesired();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace("XAResourceTransaction " + this.getXid() + ": switched to XAResource " + xaresource);
        }
    }

    private void propagateJtaTimeoutIfDesired() {
        if (this.resource != null && this.resource.propagateJtaTimeoutToXaResource()) {
            try {
                this.xaresource.setTransactionTimeout(this.timeout);
            }
            catch (XAException e) {
                String msg = XAResourceTransaction.interpretErrorCode(this.resourcename, "setTransactionTimeout", this.xid, e.errorCode);
                LOGGER.logWarning(msg, (Throwable)e);
            }
        }
    }

    public void xaSuspend() throws XAException {
        if (!this.isXaSuspended) {
            int flags = this.getSuspendFlags();
            String logFlag = this.getSuspendLogFlag(flags);
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.logDebug("XAResource.suspend ( " + this.xid + " , " + logFlag + " ) on resource " + this.resourcename + " represented by XAResource instance " + this.xaresource);
                }
                this.xaresource.end(this.xid, flags);
                this.isXaSuspended = true;
            }
            catch (XAException xaerr) {
                String msg = XAResourceTransaction.interpretErrorCode(this.resourcename, "suspend", this.xid, xaerr.errorCode);
                LOGGER.logWarning(msg, (Throwable)xaerr);
                throw xaerr;
            }
        }
    }

    private String getSuspendLogFlag(int flags) {
        String ret = "XAResource.TMSUSPEND";
        if (flags != 0x2000000) {
            ret = Integer.toString(flags);
        }
        return ret;
    }

    private int getSuspendFlags() {
        return this.resource.getSuspendExistingXaBranchFlags();
    }

    public void xaResume() throws XAException {
        int flag = this.getResumeExistingXaBranchFlags();
        String logFlag = this.getResumeExistingXaBranchLogFlag(flag);
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug("XAResource.start ( " + this.xid + " , " + logFlag + ") on resource " + this.resourcename + " represented by XAResource instance " + this.xaresource);
            }
            this.xaresource.start(this.xid, flag);
            this.isXaSuspended = false;
        }
        catch (XAException xaerr) {
            String msg = XAResourceTransaction.interpretErrorCode(this.resourcename, "resume", this.xid, xaerr.errorCode);
            LOGGER.logWarning(msg, (Throwable)xaerr);
            throw xaerr;
        }
    }

    private String getResumeExistingXaBranchLogFlag(int flag) {
        String ret = "XAResource.TMRESUME";
        if (flag != 0x8000000) {
            ret = Integer.toString(flag);
        }
        return ret;
    }

    private int getResumeExistingXaBranchFlags() {
        return this.resource.getResumeExistingXaBranchFlags();
    }

    public boolean isXaSuspended() {
        return this.isXaSuspended;
    }

    public boolean isActive() {
        return this.state.equals((Object)TxState.ACTIVE);
    }

    public String getURI() {
        return this.xid.getUri();
    }

    public String getResourceName() {
        return this.resourcename;
    }
}

