/*
 * Decompiled with CFR 0.152.
 */
package com.sas.app;

import com.sas.app.SDSDestTraversalPath;
import com.sas.app.SDSTraversalPath;
import com.sas.app.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Stack;

class SDSSyncTraversalPath {
    private static final int RETRY_SOURCE_COUNT = 5;
    private static final int[] RETRY_SOURCE_DELAY_MILLIS = new int[]{2000, 10000, 30000};
    private SDSTraversalPath m_source;
    private SDSDestTraversalPath m_dest;
    private boolean m_enableDestDeletion = true;
    private boolean m_debug;
    private long m_latestSourceFileMod = Long.MIN_VALUE;
    private boolean m_anyChanges = false;
    private boolean m_anyCopies = false;
    private Stack m_unprocessedNames = new Stack();

    SDSSyncTraversalPath(SDSTraversalPath source, SDSDestTraversalPath dest) {
        this(source, dest, false);
    }

    SDSSyncTraversalPath(SDSTraversalPath source, SDSDestTraversalPath dest, boolean debug) {
        if (source == null) {
            throw Util.illegalNull("source");
        }
        if (dest == null) {
            throw Util.illegalNull("dest");
        }
        this.m_source = source;
        this.m_dest = dest;
        this.m_debug = debug;
    }

    String run() {
        this.m_latestSourceFileMod = Long.MIN_VALUE;
        this.m_anyChanges = false;
        this.m_anyCopies = false;
        this.m_unprocessedNames = new Stack();
        String error = this.processFirst();
        if (error != null) {
            return error;
        }
        while (!this.m_unprocessedNames.isEmpty()) {
            error = this.process();
            if (error == null) continue;
            return error;
        }
        return null;
    }

    long getLatestSourceMod() {
        return this.m_latestSourceFileMod;
    }

    boolean anyChanges() {
        return this.m_anyChanges;
    }

    boolean anyCopies() {
        return this.m_anyCopies;
    }

    private String processFirst() {
        if (!this.m_source.exists() && this.m_enableDestDeletion && !this.m_dest.delete()) {
            return "Unable to delete local " + this.m_dest.getPath();
        }
        return this.processNewName();
    }

    private String process() {
        Iterator names = (Iterator)this.m_unprocessedNames.peek();
        if (!names.hasNext()) {
            this.m_unprocessedNames.pop();
            if (!this.m_unprocessedNames.isEmpty()) {
                this.m_source.pop();
                this.m_dest.pop();
            }
            return null;
        }
        String name = (String)names.next();
        this.m_source.push(name);
        this.m_dest.push(name);
        return this.processNewName();
    }

    private String processNewName() {
        for (int retries = 0; retries < 5; ++retries) {
            if (this.m_source.isDirectory()) {
                return this.processDir();
            }
            if (this.m_source.isFile()) {
                try {
                    String string = this.processFile();
                    return string;
                }
                finally {
                    this.m_source.pop();
                    this.m_dest.pop();
                }
            }
            long sleepMillis = RETRY_SOURCE_DELAY_MILLIS[Math.min(retries, RETRY_SOURCE_DELAY_MILLIS.length - 1)];
            try {
                Thread.sleep(sleepMillis);
                continue;
            }
            catch (InterruptedException e) {
                return "unknown source type (not dir or file) for " + this.m_source.getPath() + ", m_source.exists? " + this.m_source.exists() + " (retry " + (retries + 1) + " interrupted)";
            }
        }
        return "unknown source type (not dir or file) for " + this.m_source.getPath() + ", m_source.exists? " + this.m_source.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String processDir() {
        String[] localNames;
        int i;
        Object[] sourceNames;
        if (!this.m_dest.isDirectory()) {
            this.m_anyChanges = true;
            this.m_dest.delete();
            this.m_dest.mkdirs();
            if (!this.m_dest.isDirectory()) {
                return "Unable to create local directory " + this.m_dest.getPath();
            }
        }
        if ((sourceNames = this.m_source.list()) == null) {
            return "Unable to list source (null listing) " + this.m_source.getPath();
        }
        Arrays.sort(sourceNames);
        LinkedHashSet<Object> names = new LinkedHashSet<Object>();
        for (i = 0; i < sourceNames.length; ++i) {
            names.add(sourceNames[i]);
        }
        if (this.m_enableDestDeletion && (localNames = this.m_dest.list()) != null) {
            for (i = 0; i < localNames.length; ++i) {
                String name = localNames[i];
                if (names.contains(name)) continue;
                this.m_anyChanges = true;
                this.m_dest.push(name);
                try {
                    if (this.m_dest.delete()) continue;
                    String string = "Unable to delete local " + this.m_dest.getPath();
                    return string;
                }
                finally {
                    this.m_dest.pop();
                }
            }
        }
        this.m_unprocessedNames.add(names.iterator());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String processFile() {
        String n22;
        long mod = this.m_source.lastModified();
        this.m_latestSourceFileMod = Math.max(this.m_latestSourceFileMod, mod);
        if (this.m_dest.isDirectory()) {
            this.m_anyChanges = true;
            if (!this.m_dest.delete()) {
                return "Unable to delete local directory " + this.m_dest.getPath();
            }
        } else if (this.m_dest.isFile()) {
            long destMod = this.m_dest.lastModified();
            long len = this.m_source.length();
            long destLen = this.m_dest.length();
            if (destMod == mod && destLen == len) {
                return null;
            }
        }
        this.m_anyChanges = true;
        this.m_anyCopies = true;
        if (this.m_debug) {
            System.out.println("copying " + this.m_source.getRelPath());
        }
        byte[] buffer = new byte[8192];
        InputStream is = null;
        OutputStream os = null;
        boolean success = false;
        try {
            int n22;
            is = this.m_source.openSource();
            os = this.m_dest.openDest();
            while ((n22 = is.read(buffer)) >= 0) {
                if (n22 <= 0) continue;
                os.write(buffer, 0, n22);
            }
            os.flush();
            Util.close(os);
            os = null;
            this.m_dest.setLastModified(mod);
            if (this.m_dest.lastModified() != mod) assert (false);
            success = true;
            n22 = null;
        }
        catch (IOException e) {
            String string;
            try {
                string = "unable to copy " + this.m_source.getPath() + " to " + this.m_dest.getPath() + ": " + e.getMessage();
            }
            catch (Throwable throwable) {
                Util.close(os);
                Util.close(is);
                if (!success) {
                    this.m_dest.delete();
                }
                throw throwable;
            }
            Util.close(os);
            Util.close(is);
            if (!success) {
                this.m_dest.delete();
            }
            return string;
        }
        Util.close(os);
        Util.close(is);
        if (!success) {
            this.m_dest.delete();
        }
        return n22;
    }
}

