/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.objecttype.client;

import com.sas.svcs.content.objecttype.client.ObjectType;
import com.sas.svcs.content.objecttype.client.ObjectTypeService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class ObjectTypeClient {
    private static ObjectTypeService typeService;
    private static List<ObjectType> typeList;
    private static Map<String, ObjectType> mapByName;
    private static Map<Long, ObjectType> mapByType;

    public static void setObjectTypeService(ObjectTypeService objectTypeService) {
        if (typeService != null) {
            return;
        }
        typeService = objectTypeService;
        if (typeList == null) {
            ObjectTypeClient.loadTypes();
        }
    }

    public static ObjectType getTypeById(long id) {
        ObjectType type;
        if (mapByType == null) {
            ObjectTypeClient.loadTypes();
        }
        if ((type = mapByType.get(id)) == null && (type = typeService.getTypeById(id)) != null) {
            mapByName.put(type.getName(), type);
            mapByType.put(type.getId(), type);
        }
        return type;
    }

    public static ObjectType getTypeByName(String string) {
        ObjectType type;
        if (mapByName == null) {
            ObjectTypeClient.loadTypes();
        }
        if ((type = mapByName.get(string)) == null && (type = typeService.getTypeByName(string)) != null) {
            mapByName.put(type.getName(), type);
            mapByType.put(type.getId(), type);
        }
        return type;
    }

    public static List<ObjectType> getAllTypes() {
        if (typeList == null) {
            throw new IllegalStateException();
        }
        return typeList;
    }

    private static void loadTypes() {
        typeList = typeService.getAllTypes();
        ObjectTypeClient.loadNameMap();
        ObjectTypeClient.loadTypeMap();
    }

    private static void loadNameMap() {
        mapByName = new HashMap<String, ObjectType>();
        for (ObjectType objectType : typeList) {
            mapByName.put(objectType.getName(), objectType);
        }
    }

    private static void loadTypeMap() {
        mapByType = new HashMap<Long, ObjectType>();
        for (ObjectType objectType : typeList) {
            mapByType.put(objectType.getId(), objectType);
        }
    }

    static {
        typeList = null;
        mapByName = null;
        mapByType = null;
    }
}

