/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.client.util;

import com.sas.svcs.common.client.Assignable;
import com.sas.svcs.common.client.ContentFilterCriteria;
import com.sas.svcs.common.client.ContentMatchType;
import com.sas.svcs.common.client.FolderContentFilterCriteria;
import com.sas.svcs.common.client.Keyable;
import com.sas.svcs.common.client.Responsibility;
import com.sas.svcs.content.client.util.FolderTypeUtil;
import com.sas.svcs.content.framework.client.ContentComponent;
import com.sas.svcs.content.framework.client.ContentNode;
import java.util.Date;
import java.util.List;

public class ContentFilterUtils {
    public static boolean isFilterMatch(ContentFilterCriteria filter, ContentComponent content, boolean passFolders) {
        if (content == null) {
            return false;
        }
        long longType = content.getObjectType();
        if (passFolders && FolderTypeUtil.isFolderType(longType)) {
            return true;
        }
        boolean result = false;
        result = ContentFilterUtils.isNameMatch(filter.getName(), filter.getNameTypeMatch(), filter.isIncludeDescription(), content);
        if (!result) {
            return false;
        }
        result = ContentFilterUtils.isDateMatch(filter.getBefore(), filter.getSince(), filter.isUseModifiedDate(), content);
        if (!result) {
            return false;
        }
        result = ContentFilterUtils.isTypesMatch(filter.getTypes(), passFolders, content);
        if (!result) {
            return false;
        }
        result = ContentFilterUtils.isKeywordMatch(filter.getKeywords(), content);
        if (!result) {
            return false;
        }
        result = ContentFilterUtils.isResponsibilityMatch(filter.getResponsibilityUser(), filter.getResponsibilityRole(), content);
        if (!result) {
            return false;
        }
        if (filter instanceof FolderContentFilterCriteria && content instanceof ContentNode) {
            FolderContentFilterCriteria folderFilter = (FolderContentFilterCriteria)filter;
            result = ContentFilterUtils.isFolderPathMatch(folderFilter.getFolder(), folderFilter.isSearchingSubfolders(), (ContentNode)content);
        }
        return result;
    }

    public static boolean isNameMatch(String name, ContentMatchType matchType, boolean includeDescription, ContentComponent content) {
        if (name == null) {
            return true;
        }
        boolean result = false;
        if (matchType == null) {
            matchType = ContentMatchType.MATCH_EQUALS;
        }
        switch (matchType) {
            case MATCH_EQUALS: {
                result = ContentFilterUtils.equalsMatch(name, content.getName());
                if (result || !includeDescription) break;
                result = ContentFilterUtils.equalsMatch(name, content.getDescription());
                break;
            }
            case MATCH_CONTAINS: {
                result = ContentFilterUtils.containsMatch(name, content.getName());
                if (result || !includeDescription) break;
                result = ContentFilterUtils.containsMatch(name, content.getDescription());
                break;
            }
            case MATCH_STARTSWITH: {
                result = ContentFilterUtils.startswithMatch(name, content.getName());
                if (result || !includeDescription) break;
                result = ContentFilterUtils.startswithMatch(name, content.getDescription());
            }
        }
        return result;
    }

    public static boolean isDateMatch(Date before, Date since, boolean useModifiedDate, ContentComponent content) {
        if (before == null && since == null) {
            return true;
        }
        Date contentDate = null;
        contentDate = useModifiedDate ? content.getModifiedDate() : content.getCreationDate();
        if (contentDate == null) {
            return false;
        }
        if (before != null && before.before(contentDate)) {
            return false;
        }
        return since == null || !since.after(contentDate);
    }

    public static boolean isTypesMatch(List<String> typesList, boolean passFolders, ContentComponent content) {
        return ContentFilterUtils.isTypesMatch(typesList, true, passFolders, content);
    }

    public static boolean isTypesMatch(List<String> typesList, boolean includeUnknownTypes, boolean passFolders, ContentComponent content) {
        long longType = content.getObjectType();
        if (!includeUnknownTypes && -1L == longType) {
            return false;
        }
        if (typesList == null) {
            return true;
        }
        if (typesList.size() == 0) {
            return true;
        }
        if (passFolders && FolderTypeUtil.isFolderType(longType)) {
            return true;
        }
        String contentType = content.getObjectTypeName();
        int index = contentType.indexOf(".");
        String abbrevType = null;
        if (index > -1) {
            abbrevType = contentType.substring(0, index);
        }
        for (String nextTypeString : typesList) {
            if (contentType.equalsIgnoreCase(nextTypeString)) {
                return true;
            }
            if (abbrevType == null || !abbrevType.equalsIgnoreCase(nextTypeString)) continue;
            return true;
        }
        return false;
    }

    public static boolean isKeywordMatch(List<String> keywords, ContentComponent content) {
        if (keywords == null || keywords.size() == 0) {
            return true;
        }
        if (content instanceof Keyable) {
            Keyable keyableContent = (Keyable)((Object)content);
            List<String> contentKeywords = keyableContent.getKeywords();
            if (contentKeywords == null || contentKeywords.size() == 0) {
                return false;
            }
            for (String filterKeyword : keywords) {
                for (String contentKeyword : contentKeywords) {
                    if (!contentKeyword.equalsIgnoreCase(filterKeyword)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isResponsibilityMatch(String responsibilityUser, String responsibilityRole, ContentComponent content) {
        if (responsibilityUser == null) {
            return true;
        }
        if (content instanceof Assignable) {
            Assignable assignableContent = (Assignable)((Object)content);
            List<Responsibility> responsibilityList = assignableContent.getResponsibilities();
            if (responsibilityList == null || responsibilityList.size() == 0) {
                return false;
            }
            for (Responsibility nextResponsibility : responsibilityList) {
                if (!nextResponsibility.getUsername().equalsIgnoreCase(responsibilityUser)) continue;
                if (responsibilityRole != null) {
                    if (!nextResponsibility.getRole().equalsIgnoreCase(responsibilityRole)) continue;
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean isFolderPathMatch(String folderPath, boolean isSearchingSubfolders, ContentNode content) {
        if (folderPath == null) {
            return true;
        }
        String contentPath = content.getPath();
        int index = contentPath.lastIndexOf(47);
        if (index > -1) {
            String parentPath = contentPath.substring(0, index);
            if (parentPath.equalsIgnoreCase(folderPath)) {
                return true;
            }
            if (isSearchingSubfolders && parentPath.startsWith(folderPath)) {
                return true;
            }
        }
        return false;
    }

    private static boolean equalsMatch(String string1, String string2) {
        if (string1 == string2) {
            return true;
        }
        if (string1 == null && string2 == null) {
            return true;
        }
        if (string1 == null || string2 == null) {
            return false;
        }
        return string1.trim().equalsIgnoreCase(string2.trim());
    }

    private static boolean containsMatch(String string1, String string2) {
        if (string1 == string2) {
            return true;
        }
        if (string1 == null && string2 == null) {
            return true;
        }
        if (string1.length() > string2.length()) {
            return false;
        }
        String lower1 = string1.toLowerCase();
        String lower2 = string2.toLowerCase();
        int index = lower2.indexOf(lower1);
        return index > -1;
    }

    private static boolean startswithMatch(String string1, String string2) {
        if (string1 == string2) {
            return true;
        }
        if (string1 == null && string2 == null) {
            return true;
        }
        if (string1.length() > string2.length()) {
            return false;
        }
        String lower1 = string1.toLowerCase();
        String lower2 = string2.toLowerCase();
        return lower2.startsWith(lower1);
    }
}

