/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.common.client;

import com.sas.svcs.common.client.PropertyList;
import com.sas.svcs.common.client.PropertyMap;
import com.sas.svcs.common.client.RB;
import com.sas.text.Message;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SectionedPropertyMap {
    protected Map<String, PropertyMap> sections = new LinkedHashMap<String, PropertyMap>();
    private static final Logger logger = LogManager.getLogger(SectionedPropertyMap.class);
    private static final String RB_KEY = "SectionedPropertyMap.";

    public int load(Reader reader) throws IOException {
        int errorCount = 0;
        LineNumberReader myreader = reader instanceof LineNumberReader ? (LineNumberReader)reader : new LineNumberReader(reader);
        while (true) {
            int firstLine = myreader.getLineNumber() + 1;
            PropertyMap section = new PropertyMap();
            int sectionErrorCount = section.load(myreader, true);
            if (sectionErrorCount == -1) break;
            errorCount += sectionErrorCount;
            String name = section.sectionName;
            if (name == null) {
                name = "";
            }
            if (this.containsSection(name)) {
                ++errorCount;
                logger.error(Message.format((String)RB.getStringResource(RB_KEY, "DuplicateSectionIgnored.fmt.log"), (Object)PropertyList.escapeString(null, null, name, 5), (Object)new Integer(firstLine)));
                continue;
            }
            this.sections.put(name, section);
        }
        return errorCount;
    }

    public boolean containsSection(String name) {
        return this.sections.containsKey(name);
    }

    public PropertyMap getSection(String name) {
        return this.sections.get(name);
    }

    public void removeSection(String name) {
        this.sections.remove(name);
    }

    public void setSection(String name, PropertyMap map) {
        this.sections.put(name, map);
    }

    public Collection<String> getSections() {
        return this.sections.keySet();
    }
}

