/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.common.client;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class SASObjUri {
    private String repositoryKey = null;
    private List<String> path = null;
    private String name = null;
    private String type = null;
    private String componentXPath = null;

    public SASObjUri(String uriString) {
        this.parse(uriString);
    }

    SASObjUri(String repositoryKey, List<String> path, String name, String type, String componentXPath) {
        this.repositoryKey = repositoryKey;
        if (path != null) {
            this.path = new ArrayList<String>(path);
        }
        this.name = name;
        this.type = type;
        this.componentXPath = componentXPath;
    }

    public SASObjUri(SASObjUri parent, String name, String type) {
        this.repositoryKey = parent.getRepositoryKey();
        this.path = parent.getPath();
        String parentName = parent.getName();
        if (this.path == null && parentName != null) {
            this.path = new ArrayList<String>();
            this.path.add(parent.getName());
        }
        this.name = name;
        this.type = type;
    }

    private void parse(String uriString) {
        if (!uriString.startsWith("sasobj:/")) {
            throw new IllegalArgumentException("String " + uriString + " is not a valid SASObjUri.  It does not start with sasobj:/");
        }
        String substring = uriString.substring(8);
        int index = substring.indexOf(63);
        if (index < 0) {
            throw new IllegalArgumentException("String " + uriString + " is not valid because the type is missing.");
        }
        String pathNameString = substring.substring(0, index);
        String typeXPathString = substring.substring(index + 1);
        StringTokenizer st = new StringTokenizer(pathNameString, "/");
        this.repositoryKey = st.nextToken();
        while (st.hasMoreTokens()) {
            String nextToken = st.nextToken();
            if (st.hasMoreTokens()) {
                if (this.path == null) {
                    this.path = new ArrayList<String>();
                }
                this.path.add(SASObjUri.decodeString(nextToken));
                continue;
            }
            this.name = SASObjUri.decodeString(nextToken);
        }
        String typeKeyString = typeXPathString.toLowerCase();
        if (!typeKeyString.startsWith("type=")) {
            throw new IllegalArgumentException("String " + uriString + " is not a valid SASObjURI.  The type key is invalid.");
        }
        index = typeKeyString.indexOf("#");
        String typeKeyValue = null;
        if (index < 0) {
            typeKeyValue = typeXPathString;
        } else {
            typeKeyValue = typeXPathString.substring(0, index);
            this.componentXPath = typeXPathString.substring(index + 1);
        }
        String typeValue = typeKeyValue.substring(5);
        this.type = typeValue.substring(1, typeValue.length() - 1);
    }

    public final SASObjUri getParentUri() {
        if (this.name == null || this.name.trim().length() == 0) {
            return null;
        }
        SASObjUri result = null;
        if (this.componentXPath != null) {
            result = new SASObjUri(this.repositoryKey, this.path, this.name, this.type, null);
        } else if (this.path == null) {
            result = new SASObjUri(this.repositoryKey, null, null, "ServerRootFolder", null);
        } else {
            String parentNameString = this.path.get(this.path.size() - 1);
            ArrayList<String> parentPath = new ArrayList<String>(this.path);
            parentPath.remove(parentPath.size() - 1);
            if (parentPath.size() == 0) {
                parentPath = null;
            }
            result = new SASObjUri(this.repositoryKey, parentPath, parentNameString, "Folder", null);
        }
        return result;
    }

    public final String getRepositoryKey() {
        return this.repositoryKey;
    }

    public final List<String> getPath() {
        if (this.path == null) {
            return null;
        }
        return new ArrayList<String>(this.path);
    }

    public final String getName() {
        return this.name;
    }

    public final String getType() {
        return this.type;
    }

    public final String getComponentXPath() {
        return this.componentXPath;
    }

    public String toString() {
        if (this.repositoryKey == null || this.type == null) {
            throw new IllegalStateException();
        }
        StringBuffer buffer = new StringBuffer("sasobj:/");
        buffer.append(this.repositoryKey);
        if (this.path != null || this.name != null) {
            buffer.append("/");
        }
        if (this.path != null && this.path.size() > 0) {
            for (String folderString : this.path) {
                buffer.append(SASObjUri.encodeString(folderString) + "/");
            }
        }
        if (this.name != null) {
            buffer.append(SASObjUri.encodeString(this.name));
        }
        buffer.append("?Type=\"" + this.type + "\"");
        if (this.componentXPath != null) {
            buffer.append("#" + this.componentXPath);
        }
        return buffer.toString();
    }

    public static String encodeString(String origString) {
        if (origString == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(origString.length());
        char[] charArray = origString.toCharArray();
        block9: for (int i = 0; i < charArray.length; ++i) {
            char nextChar = charArray[i];
            switch (nextChar) {
                case '#': {
                    buffer.append("%23");
                    continue block9;
                }
                case '%': {
                    buffer.append("%25");
                    continue block9;
                }
                case '/': {
                    buffer.append("%2F");
                    continue block9;
                }
                case '(': {
                    buffer.append("%28");
                    continue block9;
                }
                case ')': {
                    buffer.append("%29");
                    continue block9;
                }
                case '\\': {
                    buffer.append("%5C");
                    continue block9;
                }
                case '?': {
                    buffer.append("%3F");
                    continue block9;
                }
                default: {
                    buffer.append(nextChar);
                }
            }
        }
        return buffer.toString();
    }

    public static String decodeString(String origString) {
        if (origString == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(origString.length());
        char[] charArray = origString.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            char nextChar = charArray[i];
            if (i < charArray.length - 2 && nextChar == '%') {
                StringBuffer buf = new StringBuffer(3);
                buf.append(charArray[i + 1]);
                buf.append(charArray[i + 2]);
                try {
                    char blah = (char)Integer.parseInt(buf.toString(), 16);
                    if (blah < '\u001f' || blah >= '\u007f') {
                        buffer.append(nextChar);
                        continue;
                    }
                    buffer.append(blah);
                    i += 2;
                }
                catch (NumberFormatException ex) {
                    buffer.append(nextChar);
                }
                continue;
            }
            buffer.append(nextChar);
        }
        return buffer.toString();
    }

    public static void main(String[] args) {
        SASObjUri uri1 = new SASObjUri("sasobj:/SAS Folders/path1/path2/path3/name?Type=\"TEST\"");
        SASObjUri.printSASObjUri(uri1);
        SASObjUri uri11 = uri1.getParentUri();
        SASObjUri.printSASObjUri(uri11);
        SASObjUri uri2 = new SASObjUri("sasobj:/SAS Folders/name?Type=\"TEST2\"");
        SASObjUri.printSASObjUri(uri2);
        SASObjUri uri21 = uri2.getParentUri();
        SASObjUri.printSASObjUri(uri21);
        SASObjUri uri3 = new SASObjUri("sasobj:/SAS Folders/path1/path2/path%2F3/name%3Fwho?Type=\"TEST3\"");
        SASObjUri.printSASObjUri(uri3);
        try {
            SASObjUri uri4 = new SASObjUri("sasobj:/SAS Folders/path1/path2/path3/name");
            SASObjUri.printSASObjUri(uri4);
        }
        catch (Throwable t) {
            System.out.println(t.getClass().getName() + " - " + t.getMessage());
            System.out.println("Got expected exception from missing type.");
            System.out.println("---");
        }
        try {
            SASObjUri uri5 = new SASObjUri("sasboj:/SAS Folders/path1/path2/path3/name?Type=\"TEST\"");
            SASObjUri.printSASObjUri(uri5);
        }
        catch (Throwable t) {
            System.out.println(t.getClass().getName() + " - " + t.getMessage());
            System.out.println("Got expected exception from bad protocol.");
            System.out.println("---");
        }
        try {
            SASObjUri uri6 = new SASObjUri("sasobj:/SAS Folders/path1/path2/path3/name?TEST");
            SASObjUri.printSASObjUri(uri6);
        }
        catch (Throwable t) {
            System.out.println(t.getClass().getName() + " - " + t.getMessage());
            System.out.println("Got expected exception from bad protocol.");
            System.out.println("---");
        }
        SASObjUri uri7 = new SASObjUri("sasobj:/SAS Folders/path1/path2/path3/name?Type=\"TEST7\"#subcomponents/@Name='Thing1'");
        SASObjUri.printSASObjUri(uri7);
        SASObjUri uri8 = new SASObjUri("sasobj:/SAS Folders?Type=\"Folder\"");
        SASObjUri.printSASObjUri(uri8);
        SASObjUri uri81 = uri8.getParentUri();
        SASObjUri.printSASObjUri(uri81);
    }

    public static void printSASObjUri(SASObjUri auri) {
        if (auri == null) {
            System.out.println("The uri was null");
            return;
        }
        System.out.println(auri.toString());
        System.out.println(auri.getRepositoryKey());
        List<String> path = auri.getPath();
        if (path != null && path.size() > 0) {
            for (String folderName : path) {
                System.out.print("(" + folderName + ")/");
            }
        }
        System.out.println(auri.getName());
        System.out.println("Type=" + auri.getType());
        String xpath = auri.getComponentXPath();
        if (xpath != null) {
            System.out.println(xpath);
        }
        System.out.println("---");
    }
}

