/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.common.client;

import com.sas.svcs.common.client.PropertyList;
import com.sas.svcs.common.client.RB;
import com.sas.text.Message;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PropertyMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LogManager.getLogger(PropertyMap.class);
    private static final String RB_KEY = "PropertyMap.";
    Map<String, String> map = new LinkedHashMap<String, String>();
    protected String sectionName = null;
    protected static final int COMMENT = 1;
    protected static final int PROPERTY_NAME = 2;
    protected static final int PROPERTY_VALUE = 3;
    protected static final int SECTION_NAME = 5;
    protected static final int BLANK_LINE = 6;

    public int load(Reader reader) throws IOException {
        return this.load(reader, false);
    }

    protected int load(Reader reader, boolean parseSection) throws IOException {
        int errorCount = 0;
        boolean firstPass = true;
        LineNumberReader myreader = reader instanceof LineNumberReader ? (LineNumberReader)reader : new LineNumberReader(reader);
        while (true) {
            int i;
            String line;
            if (parseSection) {
                myreader.mark(1028);
            }
            if ((line = myreader.readLine()) == null) {
                if (!firstPass) break;
                errorCount = -1;
                break;
            }
            char c = '\u0000';
            for (i = 0; i < line.length() && ((c = line.charAt(i)) == ' ' || c == '\t'); ++i) {
            }
            int state = 2;
            if (i >= line.length()) {
                state = 6;
            } else if (c == '!' || c == '#') {
                state = 1;
            } else if (parseSection && c == '[') {
                if (firstPass) {
                    state = 5;
                } else {
                    myreader.reset();
                    break;
                }
            }
            StringBuffer buffer = new StringBuffer();
            String propname = null;
            while (i < line.length()) {
                c = line.charAt(i);
                if (c == '\\') {
                    if (++i < line.length()) {
                        c = line.charAt(i);
                    } else {
                        ++errorCount;
                        logger.error(Message.format((String)RB.getStringResource(RB_KEY, "IncompleteEscape.fmt.log"), (Object)new Integer(myreader.getLineNumber())));
                    }
                    if (c == 'r') {
                        buffer.append('\r');
                    } else if (c == 'n') {
                        buffer.append('\n');
                    } else if (c == 't') {
                        buffer.append('\t');
                    } else if (c == 'u') {
                        if (i + 4 < line.length()) {
                            int cval = 0;
                            for (int j = 0; j < 4; ++j) {
                                int d;
                                if ((d = Character.digit(line.charAt(++i), 16)) < 0) {
                                    ++errorCount;
                                    cval = -1;
                                    String badEscape = line.substring(i - j - 2, i);
                                    --i;
                                    buffer.append(badEscape);
                                    logger.error(Message.format((String)RB.getStringResource(RB_KEY, "IncompleteUnicodeEscape.fmt.log"), (Object)new Integer(myreader.getLineNumber()), (Object)badEscape));
                                    break;
                                }
                                cval = cval * 16 + d;
                            }
                            if (cval >= 0) {
                                buffer.append((char)cval);
                            }
                        } else {
                            ++errorCount;
                            String badEscape = line.substring(i - 1);
                            i = line.length() - 1;
                            buffer.append(badEscape);
                            logger.error(Message.format((String)RB.getStringResource(RB_KEY, "IncompleteUnicodeEscape.fmt.log"), (Object)new Integer(myreader.getLineNumber()), (Object)badEscape));
                        }
                    } else {
                        buffer.append(c);
                    }
                } else if (state == 2 && c == '=') {
                    propname = buffer.toString();
                    state = 3;
                    buffer.setLength(0);
                } else {
                    if (state == 5 && c == ']') break;
                    buffer.append(c);
                }
                ++i;
            }
            if (state != 6 && state != 1) {
                if (state == 3) {
                    if (this.containsProperty(propname)) {
                        ++errorCount;
                        logger.error(Message.format((String)RB.getStringResource(RB_KEY, "DuplicatePropertyIgnored.fmt.log"), (Object)PropertyList.escapeString(null, null, propname, 4), (Object)new Integer(myreader.getLineNumber())));
                    } else {
                        this.setProperty(propname, buffer.toString());
                    }
                } else if (state == 5) {
                    this.sectionName = buffer.substring(1);
                } else {
                    ++errorCount;
                    logger.error(Message.format((String)RB.getStringResource(RB_KEY, "InvalidLineIgnored.fmt.log"), (Object)new Integer(myreader.getLineNumber())));
                }
            }
            firstPass = false;
        }
        return errorCount;
    }

    public String getProperty(String name) {
        return this.map.get(name);
    }

    public String getProperty(String name, int index) {
        return this.map.get(PropertyMap.makeIndexedPropertyName(name, index));
    }

    public PropertyMap getNestedProperties(String name) {
        String prefix = name + ".";
        int prefixLength = prefix.length();
        PropertyMap nested = new PropertyMap();
        for (String propname : this.map.keySet()) {
            if (!propname.startsWith(prefix)) continue;
            nested.setProperty(propname.substring(prefixLength), this.map.get(propname));
        }
        if (nested.map.isEmpty()) {
            return null;
        }
        return nested;
    }

    public PropertyMap getNestedProperties(String name, int index) {
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        return this.getNestedProperties(PropertyMap.makeIndexedPropertyName(name, index));
    }

    public int[] getPropertyIndexes(String name) {
        int[] indexes = new int[100];
        Pattern p = Pattern.compile("\\Q" + name + "\\E\\[(0|[1-9][0-9]*)\\]");
        int count = 0;
        for (String propname : this.map.keySet()) {
            Matcher m = p.matcher(propname);
            if (!m.matches()) continue;
            if (count >= indexes.length) {
                int[] newIndexes = new int[indexes.length + 100];
                int i = 0;
                while (i < count) {
                    newIndexes[i] = indexes[i];
                    ++count;
                }
                indexes = newIndexes;
            }
            indexes[count] = Integer.parseInt(m.group(1));
            ++count;
        }
        if (count == 0) {
            return null;
        }
        int[] newIndexes = new int[count];
        for (int i = 0; i < count; ++i) {
            newIndexes[i] = indexes[i];
        }
        return newIndexes;
    }

    public int[] getNestedPropertyIndexes(String name) {
        Pattern p = Pattern.compile("\\Q" + name + "\\E\\[(0|[1-9][0-9]*)\\]\\..+");
        HashSet<Integer> indexSet = new HashSet<Integer>();
        for (String propname : this.map.keySet()) {
            Matcher m = p.matcher(propname);
            if (!m.matches()) continue;
            indexSet.add(new Integer(m.group(1)));
        }
        if (indexSet.size() == 0) {
            return null;
        }
        int[] indexes = new int[indexSet.size()];
        int i = 0;
        for (Integer index : indexSet) {
            indexes[i++] = index;
        }
        return indexes;
    }

    public boolean containsProperty(String name) {
        return this.map.containsKey(name);
    }

    public boolean containsIndexedProperty(String name) {
        Pattern p = Pattern.compile("\\Q" + name + "\\E\\[(0|[1-9][0-9]*)\\]");
        for (String propname : this.map.keySet()) {
            Matcher m = p.matcher(propname);
            if (!m.matches()) continue;
            return true;
        }
        return false;
    }

    public boolean containsIndexedProperty(String name, int index) {
        return this.map.containsKey(name + "[" + Integer.toString(index) + "]");
    }

    public boolean containsNestedProperty(String name) {
        String prefix = name + ".";
        for (String propname : this.map.keySet()) {
            if (!propname.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public boolean containsIndexedNestedProperty(String name) {
        Pattern p = Pattern.compile("\\Q" + name + "\\E\\[(0|[1-9][0-9]*)\\]\\..+");
        for (String propname : this.map.keySet()) {
            Matcher m = p.matcher(propname);
            if (!m.matches()) continue;
            return true;
        }
        return false;
    }

    public boolean containsIndexedNestedProperty(String name, int index) {
        return this.containsNestedProperty(PropertyMap.makeIndexedPropertyName(name, index));
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public String[] getPropertiesBySuffix(String suffix) {
        String pattern = "((.*\\.)?\\Q" + suffix + "\\E(\\[[0-9]+\\])?)";
        Pattern p = Pattern.compile(pattern);
        HashSet<String> indexSet = new HashSet<String>();
        for (String propname : this.map.keySet()) {
            Matcher m = p.matcher(propname);
            if (!m.matches()) continue;
            indexSet.add(m.group(1));
        }
        if (indexSet.size() == 0) {
            return null;
        }
        String[] names = new String[indexSet.size()];
        int i = 0;
        for (String propname : indexSet) {
            names[i++] = propname;
        }
        return names;
    }

    public static String makeIndexedPropertyName(String name, int index) {
        return name + "[" + Integer.toString(index) + "]";
    }

    public Iterator<String> getPropertyIterator() {
        return this.map.keySet().iterator();
    }

    public void removeProperty(String name) {
        this.map.remove(name);
    }

    public void setProperty(String name, String value) {
        this.map.put(name, value);
    }
}

