/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.common.client;

import com.sas.svcs.commons.ObjectIdentity;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.util.regex.Pattern;

public class ObjectIdentityAdapter
extends XmlAdapter<String, ObjectIdentity> {
    private static final String TYPE_ID_STR = "ObjectTypeId";
    private static final String OBJECT_ID_STR = "ObjectId";

    public ObjectIdentity unmarshal(String value) {
        String valueNoBraces = value.replaceAll("[{\\s][\\s}]", "");
        Pattern pattern = Pattern.compile(",\\s");
        String[] arr = pattern.split(valueNoBraces);
        long objectTypeId = Long.parseLong(arr[0].replaceFirst("ObjectId:\\s", ""));
        String objectId = arr[1].replaceFirst("ObjectId:\\s", "");
        return new ObjectIdentity(objectTypeId, objectId);
    }

    public String marshal(ObjectIdentity value) {
        StringBuffer ret = new StringBuffer("{ ObjectTypeId: ");
        ret.append(value.getObjectType());
        ret.append(", ObjectId: ");
        ret.append(value.getId());
        ret.append(" }");
        return ret.toString();
    }
}

