/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.common.client;

import com.sas.svcs.common.client.FieldMapper;
import java.text.MessageFormat;

public class AttributeMapper
implements FieldMapper {
    private String fieldName;
    private String attributeName;
    private String[] alternateAttributeNames;
    private String valueFormat;

    public AttributeMapper(String fieldName, String attributeName) {
        this.fieldName = fieldName;
        this.attributeName = attributeName;
    }

    public AttributeMapper(String fieldName, String attributeName, String ... alternateAttributeNames) {
        this(fieldName, attributeName);
        this.alternateAttributeNames = alternateAttributeNames;
    }

    public AttributeMapper(String fieldName, String attributeName, String valueFormat) {
        this(fieldName, attributeName);
        this.valueFormat = valueFormat;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String[] getAlternateAttributeNames() {
        return this.alternateAttributeNames;
    }

    public void setValueFormat(String valueFormat) {
        this.valueFormat = valueFormat;
    }

    public String getValueFormat() {
        return this.valueFormat;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    public String getValue(String valueString) {
        if (this.valueFormat == null) {
            return "'" + valueString + "'";
        }
        return MessageFormat.format(this.valueFormat, valueString);
    }
}

