/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal.locator.wan;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.cache.client.internal.locator.ServerLocationRequest;
import org.apache.geode.internal.admin.remote.DistributionLocatorId;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public class LocatorJoinMessage
extends ServerLocationRequest {
    private DistributionLocatorId locator;
    private int distributedSystemId;
    private DistributionLocatorId sourceLocator;

    public LocatorJoinMessage() {
    }

    public LocatorJoinMessage(int distributedSystemId, DistributionLocatorId locator, DistributionLocatorId sourceLocator, String serverGroup) {
        super(serverGroup);
        this.locator = locator;
        this.distributedSystemId = distributedSystemId;
        this.sourceLocator = sourceLocator;
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.locator = (DistributionLocatorId)context.getDeserializer().readObject(in);
        this.distributedSystemId = in.readInt();
        this.sourceLocator = (DistributionLocatorId)context.getDeserializer().readObject(in);
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        context.getSerializer().writeObject(this.locator, out);
        out.writeInt(this.distributedSystemId);
        context.getSerializer().writeObject(this.sourceLocator, out);
    }

    public DistributionLocatorId getLocator() {
        return this.locator;
    }

    public int getDistributedSystemId() {
        return this.distributedSystemId;
    }

    public DistributionLocatorId getSourceLocator() {
        return this.sourceLocator;
    }

    @Override
    public int getDSFID() {
        return 2139;
    }

    public String toString() {
        return "LocatorJoinMessage{distributedSystemId=" + this.distributedSystemId + " locators=" + String.valueOf(this.locator) + " Source Locator : " + String.valueOf(this.sourceLocator) + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LocatorJoinMessage)) {
            return false;
        }
        LocatorJoinMessage myObject = (LocatorJoinMessage)obj;
        return this.distributedSystemId == myObject.getDistributedSystemId() && this.locator.equals(myObject.getLocator());
    }

    public int hashCode() {
        if (this.locator == null) {
            return 0;
        }
        return this.locator.hashCode();
    }
}

