/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.crypto.rsa;

import com.rsa.jsafe.FIPS140Context;
import com.rsa.jsafe.JSAFE_KeyPair;
import com.sas.net.crypto.CipherInterface;
import com.sas.net.crypto.Crypto;
import com.sas.net.crypto.CryptoException;
import com.sas.net.crypto.rsa.RsaCipher;
import com.sas.net.crypto.rsa.RsaLocalizedError;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.security.SecureRandom;
import java.util.Hashtable;
import java.util.Properties;

public final class RsaCrypto
extends Crypto {
    private static final Hashtable GHTQ = new Hashtable();
    protected String I;
    protected String currentTimeMillis;
    protected int Z;
    protected String C;
    protected String B;
    protected String D;
    protected String F;
    protected int J;
    protected int S;
    protected int A;
    private SecureRandom equals;
    private byte[] generate = new byte[8];
    private static ByteArrayOutputStream generateInit;
    private static DataOutputStream get;
    private String getInstance;

    public RsaCrypto(Properties properties) {
        this.I = properties.getProperty("encryptionDevice", "Java");
        this.currentTimeMillis = properties.getProperty("prngAlgorithm", "MD5Random");
        this.Z = Integer.parseInt(properties.getProperty("pkcsExponent", "65537"));
        this.C = properties.getProperty("pkcsPadding", "PKCS1Block02Pad");
        this.B = properties.getProperty("hashAlgorithm", "MD5");
        this.D = properties.getProperty("feedbackMode", "CBC");
        this.F = properties.getProperty("skcsPadding", "PKCS5Padding");
        String string = properties.getProperty("encryptionMode", "strong");
        if (string.equals("global")) {
            this.J = 512;
            this.S = 40;
            this.A = 128;
            this.getInstance = "RC2,RC4";
        } else if (string.equals("strong")) {
            this.J = 1024;
            this.S = 128;
            this.A = 128;
            this.getInstance = "RC2,RC4,DES,TRIPLEDES,AES";
        } else {
            String string2 = "crypto.rsa.R07.ex.fmt";
            Object[] objectArray = new Object[]{string2, string};
            String string3 = RsaLocalizedError.I("{0}: Bad value for encryptionMode option: {1}.", objectArray);
            throw new CryptoException(string3);
        }
    }

    public final String getSupportedNames() {
        return this.getInstance;
    }

    public final CipherInterface openCipher() {
        RsaCipher rsaCipher = new RsaCipher(this);
        return rsaCipher;
    }

    protected final void I(byte[] byArray, int n, int n2) {
        SecureRandom secureRandom = this.I();
        int n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            secureRandom.nextBytes(this.generate);
            for (int i = 0; i < 8 && n4 < n3; ++n4, ++i) {
                byArray[n4] = this.generate[i];
            }
        }
    }

    protected final synchronized SecureRandom I() {
        if (this.equals == null) {
            this.equals = new SecureRandom();
        }
        this.equals.setSeed(RsaCrypto.GHTQ());
        return this.equals;
    }

    protected final synchronized JSAFE_KeyPair I(int n, FIPS140Context fIPS140Context) {
        Integer n2 = new Integer(n);
        JSAFE_KeyPair jSAFE_KeyPair = (JSAFE_KeyPair)GHTQ.get(n2);
        if (jSAFE_KeyPair == null) {
            jSAFE_KeyPair = RsaCrypto.currentTimeMillis("RSA", this.I, fIPS140Context);
            SecureRandom secureRandom = this.I();
            int[] nArray = new int[]{n, this.Z};
            jSAFE_KeyPair.generateInit(null, nArray, secureRandom);
            jSAFE_KeyPair.generate();
            GHTQ.put(n2, jSAFE_KeyPair);
        }
        return jSAFE_KeyPair;
    }

    protected final void I(RsaCipher rsaCipher) {
    }

    private static synchronized byte[] GHTQ() {
        try {
            if (generateInit == null) {
                generateInit = new ByteArrayOutputStream(8);
                get = new DataOutputStream(generateInit);
            } else {
                generateInit.reset();
            }
            get.writeLong(System.currentTimeMillis());
            return generateInit.toByteArray();
        }
        catch (Exception exception) {
            return new byte[8];
        }
    }

    private static JSAFE_KeyPair currentTimeMillis(String string, String string2, FIPS140Context fIPS140Context) {
        JSAFE_KeyPair jSAFE_KeyPair = fIPS140Context != null ? JSAFE_KeyPair.getInstance((String)string, (String)string2, (FIPS140Context)fIPS140Context) : JSAFE_KeyPair.getInstance((String)string, (String)string2);
        return jSAFE_KeyPair;
    }
}

