/*
 * Decompiled with CFR 0.152.
 */
package com.sas.app;

import com.sas.app.Util;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

final class Stringy
implements DataOutput,
DataInput {
    private final DataOutput m_out;
    private boolean m_collecting;
    private Map m_stringMap;
    private final DataInput m_in;
    private String[] m_strings;

    public Stringy(DataOutput delegate) {
        if (delegate == null) {
            throw Util.illegalNull("delegate");
        }
        this.m_out = delegate;
        this.m_collecting = true;
        this.m_in = null;
    }

    public Stringy(DataInput delegate) {
        if (delegate == null) {
            throw Util.illegalNull("delegate");
        }
        this.m_out = null;
        this.m_in = delegate;
    }

    @Override
    public void write(byte[] arg0, int arg1, int arg2) throws IOException {
        if (!this.m_collecting) {
            this.m_out.write(arg0, arg1, arg2);
        }
    }

    @Override
    public void write(byte[] arg0) throws IOException {
        if (!this.m_collecting) {
            this.m_out.write(arg0);
        }
    }

    @Override
    public void write(int arg0) throws IOException {
        if (!this.m_collecting) {
            this.m_out.write(arg0);
        }
    }

    @Override
    public void writeBoolean(boolean arg0) throws IOException {
        if (!this.m_collecting) {
            this.m_out.writeBoolean(arg0);
        }
    }

    @Override
    public void writeByte(int arg0) throws IOException {
        if (!this.m_collecting) {
            this.m_out.writeByte(arg0);
        }
    }

    @Override
    public void writeBytes(String arg0) throws IOException {
        if (!this.m_collecting) {
            this.m_out.writeBytes(arg0);
        }
    }

    @Override
    public void writeChar(int arg0) throws IOException {
        if (!this.m_collecting) {
            this.m_out.writeChar(arg0);
        }
    }

    @Override
    public void writeChars(String arg0) throws IOException {
        if (!this.m_collecting) {
            this.m_out.writeChars(arg0);
        }
    }

    @Override
    public void writeDouble(double arg0) throws IOException {
        if (!this.m_collecting) {
            this.m_out.writeDouble(arg0);
        }
    }

    @Override
    public void writeFloat(float arg0) throws IOException {
        if (!this.m_collecting) {
            this.m_out.writeFloat(arg0);
        }
    }

    @Override
    public void writeInt(int arg0) throws IOException {
        if (!this.m_collecting) {
            this.m_out.writeInt(arg0);
        }
    }

    @Override
    public void writeLong(long arg0) throws IOException {
        if (!this.m_collecting) {
            this.m_out.writeLong(arg0);
        }
    }

    @Override
    public void writeShort(int arg0) throws IOException {
        if (!this.m_collecting) {
            this.m_out.writeShort(arg0);
        }
    }

    @Override
    public void writeUTF(String arg0) throws IOException {
        if (this.m_collecting) {
            if (arg0 == null) {
                return;
            }
            int n = arg0.length();
            if (n <= 0 || n > 16000) {
                return;
            }
            if (this.m_stringMap == null) {
                this.m_stringMap = new HashMap();
            }
            this.m_stringMap.put(arg0, null);
            return;
        }
        if (arg0 == null) {
            this.m_out.writeInt(0);
        } else if (arg0.length() <= 0) {
            this.m_out.writeInt(1);
        } else {
            Integer i;
            Integer n = i = this.m_stringMap != null ? (Integer)this.m_stringMap.get(arg0) : null;
            if (i != null) {
                this.m_out.writeInt(i);
            } else {
                this.m_out.writeInt(-1);
                this.m_out.writeUTF(arg0);
            }
        }
    }

    void finishGathering() {
        if (!this.m_collecting) {
            throw new IllegalStateException();
        }
        this.m_collecting = false;
    }

    void writeStringTable() throws IOException {
        if (this.m_stringMap == null) {
            this.m_out.writeInt(0);
            return;
        }
        Map m = this.m_stringMap;
        int n = m.size();
        Object[] array = m.keySet().toArray(new String[n]);
        Arrays.sort(array);
        this.m_out.writeInt(n);
        Object prev = null;
        for (int i = 0; i < n; ++i) {
            Object temp = array[i];
            m.put(temp, new Integer(i + 2));
            int cpl = 0;
            if (prev != null) {
                int max = 255;
                int a = ((String)prev).length();
                if (a < max) {
                    max = a;
                }
                if ((a = ((String)temp).length()) < max) {
                    max = a;
                }
                while (cpl < max && ((String)prev).charAt(cpl) == ((String)temp).charAt(cpl)) {
                    ++cpl;
                }
                this.m_out.writeByte(cpl & 0xFF);
            }
            this.m_out.writeUTF((String)(cpl > 0 ? ((String)temp).substring(cpl) : temp));
            prev = temp;
        }
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.m_in.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.m_in.readByte();
    }

    @Override
    public char readChar() throws IOException {
        return this.m_in.readChar();
    }

    @Override
    public double readDouble() throws IOException {
        return this.m_in.readDouble();
    }

    @Override
    public float readFloat() throws IOException {
        return this.m_in.readFloat();
    }

    @Override
    public void readFully(byte[] arg0, int arg1, int arg2) throws IOException {
        this.m_in.readFully(arg0, arg1, arg2);
    }

    @Override
    public void readFully(byte[] arg0) throws IOException {
        this.m_in.readFully(arg0);
    }

    @Override
    public int readInt() throws IOException {
        return this.m_in.readInt();
    }

    @Override
    public String readLine() throws IOException {
        return this.m_in.readLine();
    }

    @Override
    public long readLong() throws IOException {
        return this.m_in.readLong();
    }

    @Override
    public short readShort() throws IOException {
        return this.m_in.readShort();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.m_in.readUnsignedByte();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.m_in.readUnsignedShort();
    }

    @Override
    public String readUTF() throws IOException {
        int i = this.m_in.readInt();
        if (i == -1) {
            return this.m_in.readUTF();
        }
        if (i < 0 || i >= this.m_strings.length) {
            throw new IOException(Util.format("Stringy.stringTable.index.ex.fmt.txt", new Integer(i), new Integer(this.m_strings.length)));
        }
        return this.m_strings[i];
    }

    @Override
    public int skipBytes(int arg0) throws IOException {
        return this.m_in.skipBytes(arg0);
    }

    void readStringTable() throws IOException {
        int n = this.m_in.readInt();
        if (n < 0) {
            throw new IOException(Util.format("Stringy.stringTable.size.ex.fmt.txt", new Integer(n)));
        }
        String[] array = new String[n + 2];
        array[1] = "";
        String prev = null;
        for (int i = 0; i < n; ++i) {
            int cpl = 0;
            if (prev != null) {
                cpl = this.m_in.readUnsignedByte();
            }
            String temp = this.m_in.readUTF();
            assert (prev != null || cpl == 0);
            prev = cpl > 0 && prev != null ? prev.substring(0, cpl) + temp : temp;
            array[i + 2] = prev;
        }
        this.m_strings = array;
    }
}

