/*
 * Decompiled with CFR 0.152.
 */
package com.sas.app;

import com.sas.app.OSGiTokenizer;
import com.sas.app.RepositoryException;
import com.sas.app.Util;
import com.sas.app.VersionSpec;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class PluginRequest
implements Serializable {
    private static final long serialVersionUID = 7723702483415313419L;
    static final PluginRequest[] ZERO_REQUESTS = new PluginRequest[0];
    private static final String ATTR_BUNDLE_VERSION = "bundle-version";
    private static final String DIR_RESOLUTION = "resolution";
    private static final String VALUE_OPTIONAL = "optional";
    private static final byte E_NORMAL = 0;
    static final byte E_EXCLUDE = 1;
    static final byte E_OPTIONAL = 2;
    private final String m_name;
    private final VersionSpec m_range;
    private final byte m_type;

    static PluginRequest parsePickListSection(BufferedReader r, int pickListFormatVersion) throws IOException, RepositoryException {
        VersionSpec v;
        String line;
        String[] lines = new String[5];
        boolean first = true;
        block7: while ((line = r.readLine()) != null) {
            int p;
            int index;
            String prefix;
            int len = (line = line.trim()).length();
            if (len <= 0) {
                if (first) continue;
                break;
            }
            char c = line.charAt(0);
            if (c == '#') continue;
            first = false;
            switch (c) {
                case 'n': {
                    prefix = "name";
                    index = 0;
                    break;
                }
                case 'r': {
                    prefix = "range";
                    index = 1;
                    break;
                }
                case 'v': {
                    prefix = "version";
                    index = 2;
                    break;
                }
                case 'e': {
                    prefix = "exclude";
                    index = 3;
                    break;
                }
                case 'o': {
                    prefix = VALUE_OPTIONAL;
                    index = 4;
                    break;
                }
                default: {
                    continue block7;
                }
            }
            if (!line.startsWith(prefix)) continue;
            for (p = prefix.length(); p < len && Character.isWhitespace(line.charAt(p)); ++p) {
            }
            if (p >= len || line.charAt(p) != '=') continue;
            String suffix = line.substring(++p).trim();
            if (lines[index] != null) {
                throw PluginRequest.dupLine(prefix, lines[index], suffix);
            }
            lines[index] = suffix;
        }
        if (first) {
            assert (line == null);
            return null;
        }
        String name = lines[0];
        if (name == null) {
            throw new RepositoryException(Util.format("PluginRequest.parse.name.missing.ex.txt"));
        }
        if (name.trim().length() <= 0) {
            throw new RepositoryException(Util.format("PluginRequest.parse.name.illegal.ex.fmt.txt", name));
        }
        String range = lines[1];
        String version = lines[2];
        if (version != null && range != null) {
            throw new RepositoryException(Util.format("PluginRequest.parse.versionAndRange.ex.fmt.txt", name, version, range));
        }
        if (range != null) {
            v = VersionSpec.parseRange(range);
            if (v == null) {
                throw new RepositoryException(Util.format("PluginRequest.parse.range.ex.fmt.txt", name, range));
            }
        } else if (version != null) {
            VersionSpec versionSpec = v = pickListFormatVersion < 1 ? VersionSpec.parseRange(version) : VersionSpec.parseVersion(version);
            if (v == null) {
                throw new RepositoryException(Util.format("PluginRequest.parse.version.ex.fmt.txt", name, version));
            }
        } else {
            v = VersionSpec.ANY;
        }
        boolean exclude = Boolean.valueOf(lines[3]);
        boolean optional = Boolean.valueOf(lines[4]);
        if (optional && exclude) {
            throw new RepositoryException(Util.format("PluginRequest.parse.optionalExclude.ex.txt"));
        }
        byte type = exclude ? (byte)1 : (optional ? (byte)2 : 0);
        return new PluginRequest(name, v, type);
    }

    static RepositoryException dupLine(String nameOfLine, Object value1, String value2) {
        if (nameOfLine == null) {
            throw Util.illegalNull("nameOfLine");
        }
        return new RepositoryException(Util.format("PluginRequest.parse.dupLine.ex.fmt.txt", nameOfLine, value1, value2));
    }

    static PluginRequest[] parseRequireBundle(String requireBundleAttrValue) throws IllegalArgumentException {
        int n;
        ArrayList<PluginRequest> rc;
        block18: {
            if (requireBundleAttrValue == null) {
                throw Util.illegalNull("requireBundleAttrValue");
            }
            if (requireBundleAttrValue.trim().length() <= 0) {
                return ZERO_REQUESTS;
            }
            rc = new ArrayList<PluginRequest>();
            OSGiTokenizer tok = new OSGiTokenizer(requireBundleAttrValue);
            do {
                tok.skipSpaces();
                if (!tok.hasMore()) break block18;
                String name = tok.symbolicName();
                if (name == null) {
                    return null;
                }
                VersionSpec v = null;
                String resolution = null;
                tok.skipSpaces();
                while (tok.maybe(';')) {
                    tok.skipSpaces();
                    String parameterName = tok.token();
                    if (parameterName == null) {
                        return null;
                    }
                    tok.skipSpaces();
                    boolean directive = tok.maybe(':');
                    if (!tok.maybe('=')) {
                        return null;
                    }
                    tok.skipSpaces();
                    if (parameterName.equals(directive ? DIR_RESOLUTION : ATTR_BUNDLE_VERSION)) {
                        String argument = tok.argument();
                        if (argument == null) {
                            return null;
                        }
                        if (directive) {
                            if (resolution != null) {
                                return null;
                            }
                            resolution = argument;
                        } else {
                            if (v != null) {
                                return null;
                            }
                            v = VersionSpec.parseRange(argument);
                            if (v == null) {
                                return null;
                            }
                        }
                    } else if (!tok.scanArgument()) {
                        return null;
                    }
                    tok.skipSpaces();
                }
                if (v == null) {
                    v = VersionSpec.ANY;
                }
                boolean optional = resolution != null && VALUE_OPTIONAL.equals(resolution);
                rc.add(new PluginRequest(name, v, optional ? (byte)2 : 0));
                tok.skipSpaces();
                if (!tok.hasMore()) break block18;
            } while (tok.maybe(','));
            return null;
        }
        if ((n = rc.size()) <= 0) {
            return ZERO_REQUESTS;
        }
        return rc.toArray(new PluginRequest[n]);
    }

    public PluginRequest(String name, VersionSpec range) throws IllegalArgumentException {
        this(name, range, 0);
    }

    PluginRequest(String name, VersionSpec range, byte type) throws IllegalArgumentException {
        if (name == null) {
            throw Util.illegalNull("name");
        }
        if (name.length() <= 0) {
            throw Util.illegalArgument("name", name);
        }
        if (type == 1) {
            this.m_name = name;
            this.m_range = range == null ? VersionSpec.ANY : range;
            this.m_type = type;
            return;
        }
        if (range == null) {
            throw Util.illegalNull("range");
        }
        if (type != 0 && type != 2) {
            throw Util.illegalArgument("type", new Integer(type));
        }
        this.m_name = name;
        this.m_range = range;
        this.m_type = type;
    }

    public String getName() {
        return this.m_name;
    }

    public VersionSpec getRange() {
        return this.m_range;
    }

    boolean isOptional() {
        return this.m_type == 2;
    }

    boolean isExclude() {
        return this.m_type == 1;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof PluginRequest)) {
            return false;
        }
        PluginRequest r = (PluginRequest)o;
        return !(this.m_type != r.m_type || this.m_name != r.m_name && !this.m_name.equals(r.m_name) || this.m_range != r.m_range && !this.m_range.equals(r.m_range));
    }

    public int hashCode() {
        return this.m_name.hashCode() + this.m_range.hashCode() + this.m_type;
    }

    PluginRequest merge(PluginRequest r) throws IllegalArgumentException {
        boolean roptional;
        if (r == null) {
            throw Util.illegalNull("r");
        }
        if (!this.m_name.equals(r.m_name)) {
            throw Util.illegalArgument("r.getName()", r.m_name);
        }
        if (this.m_type == 1) {
            throw new IllegalStateException();
        }
        if (r.m_type == 1) {
            throw new IllegalStateException();
        }
        boolean optional = this.isOptional();
        if (optional != (roptional = r.isOptional())) {
            return optional ? r : this;
        }
        VersionSpec v = r.m_range;
        VersionSpec isect = this.m_range.intersect(v);
        if (isect == null) {
            return null;
        }
        if (isect.equals(this.m_range)) {
            return this;
        }
        if (isect.equals(v)) {
            return r;
        }
        return new PluginRequest(this.m_name, isect);
    }

    void writePickListSection(Writer s) throws IOException {
        s.write("name=");
        s.write(this.m_name);
        s.write(10);
        if (!VersionSpec.ANY.equals(this.m_range)) {
            if (this.m_range.isRange()) {
                s.write("range=");
                s.write(this.m_range.toRangeString(false));
            } else {
                s.write("version=");
                s.write(this.m_range.toVersionString());
            }
            s.write(10);
        }
        switch (this.m_type) {
            case 0: {
                break;
            }
            case 1: {
                s.write("exclude=true\n");
                break;
            }
            case 2: {
                s.write("optional=true\n");
                break;
            }
            default: {
                assert (false);
                throw new IllegalStateException();
            }
        }
        s.write(10);
    }

    void writeRequireBundle(StringBuffer b) throws IllegalArgumentException, IllegalStateException {
        if (b == null) {
            throw Util.illegalNull("b");
        }
        if (this.isExclude()) {
            throw new IllegalStateException();
        }
        if (b.length() > 0) {
            b.append(',');
        }
        b.append(this.m_name);
        if (!VersionSpec.ANY.equals(this.m_range)) {
            b.append(';').append(ATTR_BUNDLE_VERSION).append('=').append('\"').append(this.m_range.toRangeString(false)).append('\"');
        }
        if (this.isOptional()) {
            b.append(';').append(DIR_RESOLUTION).append(':').append('=').append(VALUE_OPTIONAL);
        }
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("PluginRequest ");
        b.append(this.m_name);
        b.append(' ');
        if (VersionSpec.ANY.equals(this.m_range)) {
            b.append("[any version]");
        } else if (this.m_range.isRange()) {
            b.append(this.m_range.toRangeString(false));
        } else {
            b.append(this.m_range.toVersionString());
        }
        if (this.isExclude()) {
            b.append(" (EXCLUDE)");
        } else if (this.isOptional()) {
            b.append(" (OPTIONAL)");
        }
        return b.toString();
    }

    static final class Merger {
        private Set m_mergeFailureNames = null;
        private Map m_mergedRequests = new LinkedHashMap();
        private Map m_requestHistory = new HashMap();

        Merger() {
        }

        void add(PluginRequest r) throws IllegalArgumentException {
            if (r == null) {
                return;
            }
            if (r.isExclude()) {
                throw Util.illegalArgument("r.isExclude()", r);
            }
            String name = r.getName();
            Object hist = this.m_requestHistory.get(name);
            if (hist == null) {
                this.m_requestHistory.put(name, r);
            } else if (hist instanceof PluginRequest) {
                PluginRequest r2 = (PluginRequest)hist;
                if (r.equals(r2)) {
                    return;
                }
                HashSet<PluginRequest> set = new HashSet<PluginRequest>();
                set.add(r);
                set.add(r2);
                this.m_requestHistory.put(name, set);
            } else {
                ((Set)hist).add(r);
            }
            if (this.m_mergeFailureNames != null && this.m_mergeFailureNames.contains(name)) {
                return;
            }
            PluginRequest old = (PluginRequest)this.m_mergedRequests.get(name);
            if (old != null) {
                PluginRequest merged = r.merge(old);
                if (merged == null) {
                    this.m_mergedRequests.remove(name);
                    if (this.m_mergeFailureNames == null) {
                        this.m_mergeFailureNames = new HashSet();
                    }
                    this.m_mergeFailureNames.add(name);
                } else {
                    this.m_mergedRequests.put(name, merged);
                }
            } else {
                this.m_mergedRequests.put(name, r);
            }
        }

        void add(PluginRequest[] requests) throws IllegalArgumentException {
            if (requests == null) {
                return;
            }
            for (int i = 0; i < requests.length; ++i) {
                PluginRequest r = requests[i];
                if (r == null) continue;
                this.add(r);
            }
        }

        void add(Collection requests) throws IllegalArgumentException, ClassCastException {
            if (requests == null) {
                return;
            }
            for (PluginRequest r : requests) {
                if (r == null) continue;
                this.add(r);
            }
        }

        PluginRequest[] finish() throws RepositoryException {
            if (this.m_mergeFailureNames == null) {
                int n = this.m_mergedRequests.size();
                return n <= 0 ? ZERO_REQUESTS : this.m_mergedRequests.values().toArray(new PluginRequest[n]);
            }
            ArrayList list = new ArrayList();
            for (String name : new TreeSet(this.m_mergeFailureNames)) {
                Object o = this.m_requestHistory.get(name);
                if (o instanceof PluginRequest) {
                    list.add(o);
                    continue;
                }
                list.addAll((Set)o);
            }
            throw new RepositoryException(Util.format("Repository.lookup.collision.ex.txt"), list);
        }
    }
}

