/*
 * Decompiled with CFR 0.152.
 */
package com.sas.app;

import com.sas.app.Filter;
import com.sas.app.FrameworkProps;
import com.sas.app.OSGiTokenizer;
import com.sas.app.RepositoryException;
import com.sas.app.Util;
import com.sas.app.VersionSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

class BundleNativeCode {
    private final List m_clauses;
    private final boolean m_optional;

    static Map calcSelectedNativeLibs(String attrValue) throws RepositoryException {
        String[] selectedPaths;
        BundleNativeCode nc = new BundleNativeCode(attrValue);
        try {
            selectedPaths = nc.select(FrameworkProps.getFrameworkProps());
        }
        catch (RepositoryException e) {
            throw new RepositoryException(Util.format("BundleNativeCode.select.ex.fmt.txt", attrValue), e);
        }
        if (selectedPaths == null || selectedPaths.length <= 0) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String> rc = new HashMap<String, String>();
        for (int i = 0; i < selectedPaths.length; ++i) {
            String base;
            int n;
            String path = selectedPaths[i];
            if (path == null) {
                assert (false);
                continue;
            }
            if ("/".equals(path.trim())) {
                assert (false);
                throw new RepositoryException(Util.format("BundleNativeCode.Clause.rootPath.ex.fmt.txt", new Integer(-1), attrValue));
            }
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            String filename = (n = path.lastIndexOf(47)) >= 0 ? path.substring(n + 1) : path;
            n = filename.lastIndexOf(46);
            String string = base = n > 0 ? filename.substring(0, n) : filename;
            if (rc.containsKey(base)) {
                throw new RepositoryException(Util.format("BundleNativeCode.select.collision.ex.fmt.txt", base, rc.get(base), path));
            }
            rc.put(base, path);
        }
        return rc;
    }

    private BundleNativeCode(String attrValue) throws RepositoryException {
        OSGiTokenizer tok = new OSGiTokenizer(attrValue);
        tok.skipSpaces();
        int sequenceNumber = 0;
        boolean optional = false;
        ArrayList<Clause> clauses = new ArrayList<Clause>();
        clauses.add(new Clause(tok, sequenceNumber++, attrValue));
        while (true) {
            tok.skipSpaces();
            if (!tok.hasMore()) break;
            int mark = tok.getPos();
            if (!tok.maybe(',')) {
                throw new RepositoryException(Util.format("BundleNativeCode.comma.ex.fmt.txt", new Integer(mark), attrValue));
            }
            tok.skipSpaces();
            mark = tok.getPos();
            if (tok.maybe('*')) {
                tok.skipSpaces();
                if (!tok.hasMore()) {
                    optional = true;
                    break;
                }
            }
            tok.setPos(mark);
            clauses.add(new Clause(tok, sequenceNumber++, attrValue));
        }
        this.m_clauses = clauses;
        this.m_optional = optional;
    }

    boolean isOptional() {
        return this.m_optional;
    }

    String[] select(Map frameworkProps) throws RepositoryException {
        assert (this.m_clauses != null);
        assert (this.m_clauses.size() > 0);
        for (Clause c : this.m_clauses) {
            if (!c.matches(frameworkProps)) continue;
            return c.getPaths();
        }
        return Util.ZERO_STRINGS;
    }

    private static class Clause
    implements Comparable {
        private static final String ATTR_PROCESSOR = "processor";
        private static final String ATTR_OS_NAME = "osname";
        private static final String ATTR_OS_VERSION = "osversion";
        private static final String ATTR_LANGUAGE = "language";
        private static final String ATTR_SELECTION_FILTER = "selection-filter";
        private final int m_clauseNumber;
        private final String[] m_paths;
        private final String[] m_processors;
        private final String[] m_osnames;
        private final VersionSpec[] m_osversions;
        private final String[] m_languages;
        private final String[] m_selectionFilters;

        private static VersionSpec[] normalize(VersionSpec[] ranges) {
            if (ranges == null || ranges.length <= 0) {
                return null;
            }
            if (ranges.length == 1) {
                return ranges;
            }
            Arrays.sort(ranges);
            int a = 0;
            for (int i = 0; i < ranges.length; ++i) {
                VersionSpec b = ranges[i];
                VersionSpec u = ranges[a].union(b);
                if (u == null) {
                    ranges[++a] = b;
                    continue;
                }
                ranges[a] = u;
            }
            if (++a == ranges.length) {
                return ranges;
            }
            VersionSpec[] rc = new VersionSpec[a];
            System.arraycopy(ranges, 0, rc, 0, a);
            return rc;
        }

        private static String[] normalize(String[] values, boolean lowerCase) {
            if (values == null || values.length <= 0) {
                return null;
            }
            LinkedHashSet<String> rc = new LinkedHashSet<String>();
            for (int i = 0; i < values.length; ++i) {
                String s = values[i];
                if (s == null || (s = s.trim()).length() <= 0) continue;
                rc.add(lowerCase ? s.toLowerCase() : s);
            }
            int n = rc.size();
            return n > 0 ? rc.toArray(new String[n]) : null;
        }

        private static String[] normalizeStrings(List strings, boolean lowerCase) {
            if (strings == null) {
                return null;
            }
            return Clause.normalize(strings.toArray(new String[strings.size()]), lowerCase);
        }

        /*
         * Unable to fully structure code
         */
        Clause(OSGiTokenizer tok, int clauseNumber, String attrValue) throws RepositoryException, IllegalArgumentException {
            super();
            if (tok == null) {
                throw Util.illegalNull("tok");
            }
            if (clauseNumber < 0) {
                throw Util.illegalNegative("clauseNumber", clauseNumber);
            }
            if (attrValue == null) {
                throw Util.illegalNull("attrValue");
            }
            tok.skipSpaces();
            start = tok.getPos();
            path = tok.path();
            if (path == null) {
                throw new RepositoryException(Util.format("BundleNativeCode.Clause.path.ex.fmt.txt", new Integer(start), attrValue));
            }
            if ("/".equals(path = path.trim())) {
                throw new RepositoryException(Util.format("BundleNativeCode.Clause.rootPath.ex.fmt.txt", new Integer(start), attrValue));
            }
            paths = new ArrayList<String>();
            paths.add(path);
            tok.skipSpaces();
            attributes = new HashMap<String, ArrayList<String>>();
            inParameters = false;
            while (tok.maybe(';')) {
                tok.skipSpaces();
                mark = tok.getPos();
                pname = tok.token();
                if (pname == null) ** GOTO lbl-1000
                tok.skipSpaces();
                directive = tok.maybe(':');
                if (tok.maybe('=')) {
                    inParameters = true;
                    tok.skipSpaces();
                    argStart = tok.getPos();
                    arg = tok.lenientArgument();
                    if (arg == null) {
                        throw new RepositoryException(Util.format("BundleNativeCode.Clause.missingArg.ex.fmt.txt", pname, new Integer(argStart), attrValue));
                    }
                    if (directive) {
                        throw new RepositoryException(Util.format("BundleNativeCode.Clause.directive.ex.fmt.txt", pname, new Integer(mark), attrValue));
                    }
                    arg = arg.trim();
                    values = (ArrayList<String>)attributes.get(pname);
                    if (values == null) {
                        values = new ArrayList<String>();
                        attributes.put(pname, values);
                    }
                    if ("osversion".equals(pname)) {
                        v = VersionSpec.parseRange(arg);
                        if (v == null) {
                            throw new RepositoryException(Util.format("BundleNativeCode.Clause.osVersion.ex.fmt.txt", new Integer(argStart), attrValue));
                        }
                        values.add((String)v);
                    } else {
                        values.add(arg);
                    }
                } else lbl-1000:
                // 2 sources

                {
                    if (inParameters) {
                        throw new RepositoryException(Util.format("BundleNativeCode.Clause.parameter.ex.fmt.txt", new Integer(mark), attrValue));
                    }
                    tok.setPos(mark);
                    path = tok.path();
                    if (path == null) {
                        throw new RepositoryException(Util.format("BundleNativeCode.Clause.path.ex.fmt.txt", new Integer(mark), attrValue));
                    }
                    if ("/".equals(path = path.trim())) {
                        throw new RepositoryException(Util.format("BundleNativeCode.Clause.rootPath.ex.fmt.txt", new Integer(mark), attrValue));
                    }
                    paths.add(path);
                }
                tok.skipSpaces();
            }
            processor = (List)attributes.remove("processor");
            osname = (List)attributes.remove("osname");
            vlist = (List)attributes.remove("osversion");
            language = (List)attributes.remove("language");
            selectionFilter = (List)attributes.remove("selection-filter");
            if (osname == null || processor == null) {
                throw new RuntimeException(Util.format("BundleNativeCode.Clause.requiredAttr.ex.fmt.txt", new Integer(start), attrValue));
            }
            osversions = vlist != null && (n = vlist.size()) > 0 ? vlist.toArray(new VersionSpec[n]) : null;
            this.m_clauseNumber = clauseNumber;
            this.m_paths = Clause.normalizeStrings(paths, false);
            this.m_processors = Clause.normalizeStrings(processor, true);
            this.m_osnames = Clause.normalizeStrings(osname, true);
            this.m_osversions = Clause.normalize(osversions);
            this.m_languages = Clause.normalizeStrings(language, true);
            this.m_selectionFilters = Clause.normalizeStrings(selectionFilter, false);
        }

        String[] getPaths() {
            if (this.m_paths == null || this.m_paths.length <= 0) {
                return Util.ZERO_STRINGS;
            }
            String[] rc = new String[this.m_paths.length];
            System.arraycopy(this.m_paths, 0, rc, 0, rc.length);
            return rc;
        }

        public int compareTo(Object o) throws ClassCastException {
            boolean langA;
            int c;
            VersionSpec fa;
            Clause a = (Clause)o;
            if (this == a) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            VersionSpec fThis = this.m_osversions != null ? this.m_osversions[0] : null;
            VersionSpec versionSpec = fa = a.m_osversions != null ? a.m_osversions[0] : null;
            if (fThis == null) {
                if (fa != null) {
                    return 1;
                }
            } else if (fa == null) {
                return -1;
            }
            if ((c = VersionSpec.compareVersionStarts(fThis, fa)) != 0) {
                return -c;
            }
            boolean langThis = this.m_languages != null;
            boolean bl = langA = a.m_languages != null;
            if (langThis != langA) {
                return langThis ? -1 : 1;
            }
            c = this.m_clauseNumber - a.m_clauseNumber;
            if (c != 0) {
                return c;
            }
            assert (false);
            throw new IllegalStateException();
        }

        boolean matches(Map frameworkProps) throws RepositoryException {
            String[] versionStrings;
            if (!FrameworkProps.matchesProcessor(this.m_processors, frameworkProps) || !FrameworkProps.matchesOsName(this.m_osnames, frameworkProps)) {
                return false;
            }
            if (this.m_osversions != null && !Clause.osMatch(this.m_osversions, versionStrings = FrameworkProps.getStringArray("org.osgi.framework.os.version", frameworkProps))) {
                return false;
            }
            if (this.m_languages != null) {
                String[] langStrings = Clause.normalize(FrameworkProps.getStringArray("org.osgi.framework.language", frameworkProps), true);
                if (langStrings == null) {
                    return false;
                }
                HashSet<String> set = new HashSet<String>();
                for (int i = 0; i < langStrings.length; ++i) {
                    String langString = langStrings[i];
                    if (langString == null) continue;
                    set.add(langString.toLowerCase());
                }
                boolean match = false;
                for (int i = 0; i < this.m_languages.length; ++i) {
                    String s = this.m_languages[i];
                    if (s == null || !set.contains(s)) continue;
                    match = true;
                    break;
                }
                if (!match) {
                    return false;
                }
            }
            if (this.m_selectionFilters != null) {
                boolean match = false;
                for (int i = 0; i < this.m_selectionFilters.length; ++i) {
                    String s = this.m_selectionFilters[i];
                    if (s == null) continue;
                    Filter f = Filter.parse(s);
                    if (f == null) {
                        throw new RepositoryException(Util.format("BundleNativeCode.Clause.filter.ex.fmt.txt", s));
                    }
                    if (!f.matches(frameworkProps)) continue;
                    match = true;
                    break;
                }
                if (!match) {
                    return false;
                }
            }
            return true;
        }

        private static boolean osMatch(VersionSpec[] osVersions, String[] versionStrings) {
            if (versionStrings == null) {
                return false;
            }
            for (int i = 0; i < versionStrings.length; ++i) {
                VersionSpec v = VersionSpec.parseVersion(versionStrings[i]);
                if (v == null) continue;
                for (int j = 0; j < osVersions.length; ++j) {
                    if (!osVersions[j].includes(v)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

