#!/bin/ksh
##################################################
LANG=C; export LANG

cmd=saxcheck
ver='SAS 9.4'

problem=no

emit() {
   echo $cmd: "$@" >&2
}

# this is for print out current and minimum version information
stdoutmsg() {
   echo "$@" >&1
}

PATH=$PATH:/usr/sbin
export PATH

un=`uname`
case "$un" in
SunOS*);;
*)   emit "The uname command reports \"$un\", not \"SunOS\""
     emit "Is this a Solaris system?"
#     problem=yes
     exit 1;
esac

if [ `uname -p` = "i386" -a `isainfo -b`  = "64" ]                       

then
   :
else
   emit "$ver requires a 64-bit Intel64-compatible CPU architecture"
#   problem=yes
   exit 1
fi

#test release

solver=`uname -r | sed 's/^5\.//'`

if expr "$solver" '=' '11' >/dev/null
then
   solupd=`uname -v | cut -f2 -d.`
else
   solupd=0
fi


os="Solaris $solver update $solupd"
minos="Solaris 11 update 4"

if expr "$solver" '<' '11' > /dev/null
then
   emit "$ver requires a minimum of $minos"
   emit "Your machine appears to be $os".
   problem=yes
fi

if expr "$solver" '=' '11' > /dev/null && expr "$solupd" '<' '4' >/dev/null
then
   emit "$ver requires a minimum of $minos"
   emit "Your machine appears to be $os".
   problem=yes
fi
   
case $problem in
no)  
   stdoutmsg "$os"
   emit "Checker for $ver finished, with no detected problems"
   exit 0;;
yes) 
   stdoutmsg "$os"
   stdoutmsg "$minos"
   emit "Checker for $ver finished, with problems"
   exit 1;;
esac
