#!/bin/ksh
##################################################
LANG=C; export LANG

cmd=s64check
ver='SAS 9.4'

problem=no

emit() {
   echo $cmd: "$@" >&2
}

# this is for print out current and minimum version information
stdoutmsg() {
   echo "$@" >&1
}

error_out () {
   stdoutmsg "$os"
   stdoutmsg "$minos"
   emit "Checker for $ver finished, with problems"
   exit 1
}

PATH=$PATH:/usr/sbin
export PATH

un=`uname`
case "$un" in
SunOS*);;
*)   emit "The uname command reports \"$un\", not \"SunOS\""
     emit "Is this a Solaris system?"
     exit 1;;
esac

if [ `uname -p` != "sparc" ]
then
   emit "$ver requires the SPARCV9 CPU architecture"
   problem=yes
   exit 1
fi

#test release
solver=`uname -r | sed 's/^5\.//'`

if expr "$solver" '<' '11' > /dev/null
then
   emit "$ver requires a minimum of 11.4"
   emit "Your machine appears to be $solver".
   error_out
fi
solupd=`uname -v | sed 's/^11\.//'`
os="Solaris $solver update $solupd"
minos="Solaris 11 update 4"
   
if expr "$solupd" '<' '4' > /dev/null
then
   emit "$ver requires a minimum of $minos"
   emit "Your machine appears to be $solver.$solupd".
   error_out
fi

stdoutmsg "$os"
emit "Checker for $ver finished, with no detected problems"
exit 0


