#!/bin/sh -p

# check system requirements for SAS on AIX
LANG=C; export LANG

cmd=r64check
ver='SAS 9.4'

minos=7.2.0.0
mintechlevel=05

problem=no

emit() {
   echo $cmd: "$@" >&2
}

# this is for print out current and minimum version information
stdoutmsg() {
   echo "$@" >&1
}

un=`uname`
case "$un" in
AIX*);;
*)   emit "The uname command reports \"$un\", not \"AIX\""
     emit "Is this an AIX system?"
     problem=yes
esac

# REQUIREMENTS "release 7.2 TL5"
os=`oslevel`
if expr "$os" '<' $minos > /dev/null
then
   emit "Your AIX oslevel is $os, but the minimum for $ver is $minos"
   problem=yes
fi

if expr "$os" '==' $minos > /dev/null
then
    # test for TL (Technology Level)
    tl=`oslevel -r`
    tlver=${tl##*-}
    if expr "$tlver" '>=' $mintechlevel > /dev/null 
    then
        emit "Technology Level (TL) acceptable"
    else
	    emit "You must apply technology level $mintechlevel, or later. This program detected $tl"
        problem=yes
    fi
fi

# REQUIREMENT "In addition, for all versions of AIX, you must apply the runtime package.
#              V11.1.0.4, or later"
rte=`lslpp -L |grep -i xlc|grep -i runtime`

rte1=`echo $rte|grep 6.1`
rte2=`echo $rte|grep xlC.rte`

####################################################
# trimming of rte output
####################################################

rte1=${rte1%%6.1*}
rte1=${rte1##*xlC.aix61.rte}
rte1=${rte1## }
rte1=${rte1## }
rte1=${rte1%% *}


rte2=${rte2%%7.1*}
rte2=${rte2##*xlC.rte}
rte2=${rte2## }
rte2=${rte2## }
rte2=${rte2%% *}

runtime=""
minruntime=""
kernel=""
minkernel=""

if expr "$rte1" '>=' '11.1.0.4' > /dev/null ||expr "$rte2" '>=' '11.1.0.4' > /dev/null
then
   emit "Runtime acceptable"
   minruntime="Runtime package xlC.rte 11.1.04."
   runtime=$rte2
else
   emit "For all versions of AIX, you must apply the runtime package,
V11.1.04, or later. This program detected $rte1 $rte2"
   if [ x"$rte2" = x ]
   then
      runtime="Runtime package xlC.rte $rte1."
   else
      runtime="Runtime package xlC.rte $rte1."
   fi
   minruntime="Runtime package xlC.rte 11.1.04."
   problem=yes
fi


# RECOMMENDATION "the 64-bit kernel is recommended"
kt=`/usr/sbin/lsconf  -k`
case "$kt" in
'Kernel Type: 32-bit')
    emit "You are running a 32-bit kernel, but a 64-bit kernel is recommended"
    emit "Please consult the XXX system requirements documentation for more information"
    # XXX can this kernel run a 64-bit binary, which SAS is?  Not sure how to tell
   kernel="Running a 32-bit kernel."
   minkernel="64-bit kernel"
   problem=yes
    ;;
'Kernel Type: 64-bit')
	kernel="64-bit kernel"
	minkernel="64-bit kernel"
    ;;
*)
    emit "Unknown kernel type \"$kt\", expected either 32-bit or (recommended) 64-bit"
    minkernel="Unknown kernel type."
    problem=yes
esac

# output
case $problem in
no)
   stdoutmsg "$os"
   emit "Checker for $ver finished, with no detected problems"
   exit 0;;
 
yes)
   stdoutmsg "$os, TL-$tlver, Runtime package x1C.rte $runtime, $kernel"
   stdoutmsg "$minos, TL-$mintechlevel, $minruntime, $minkernel"
   emit "Checker for $ver finished, with problems"
   exit 1;;
esac
