#!/bin/ksh
##################################################
LANG=C; export LANG

cmd=h6icheck
ver='SAS 9.4'

minun=B.11.31
minqpk=B.11.31.1109.367a
minqpk_dsp='HP-UX 11i version 3 update 9 (September 2011)'

problem=no

emit() {
   echo $cmd: "$@" >&2
}

# this is for print out current and minimum version information
stdoutmsg() {
   echo "$@" >&1
}

PATH=$PATH:/usr/sbin
export PATH

un=`uname`
case "$un" in
HP-UX*);;
*)   emit "The uname command reports \"$un\", not \"HP-UX\""
     emit "Is this an HP-UX system?"
     problem=yes
     exit 1;
esac


un=`uname -m`
case "$un" in
ia64*);;
*)   emit "The uname -m command reports \"$un\", not \"$minun\""
     emit "Is this an Itanium system?"
     problem=yes
     #exit 1;
esac

un=`uname -r`
unmodified="$un"
un=`echo "$un" | sed -e 's/^\([0-9][-.]\)/0\1/' -e 's/\([-.]\)\([0-9][-.]\)/\10\2/g' -e 's/\([-.]\)\([0-9]\)$/\10\2/'`
un=`echo "$un" | sed -e 's/^\([0-9][-.]\)/0\1/' -e 's/\([-.]\)\([0-9][-.]\)/\10\2/g' -e 's/\([-.]\)\([0-9]\)$/\10\2/'`
if expr "$un" '<' '$minver' > /dev/null
then
   emit "The operating system must be $minqpk_dsp ($minqpk) or higher"
   emit "The version detected was $unmodified"
   problem=yes
fi

qpk=`swlist -l bundle QPKBASE | grep QPKBASE | awk '{print $2}'`
if expr "$qpk" '<' 'B.11.31.1109.367a' > /dev/null
then
   emit "The operating system must be $minqpk_dsp ($minqpk) or higher"
   emit "The QPKBASE bundle detected was $qpk"
   problem=yes
fi

# the Atomic APIs product B.11.31.0803.01 is required.
if swlist | grep AtomicLib > /dev/null
then
    atomiclib=''
else
    emit "The Atomic APIs product B.11.31.0803.01 is required."
    min_atomiclib='Atomic APIs product B.11.31.0803.01 is required,'
    problem=yes
fi

# HP Streams needs to be enabled
if /usr/sbin/kctune streampipes | grep -w '^ *streampipes  *1  *1 *$' > /dev/null
then
    streampipes=''
else
    emit "HP-UX streampipes does not appear to be enabled"
    emit "This will enable the kernel variable:"
    emit "     /usr/sbin/kctune  streampipes=1"
    min_streampipes='HP-UX streampipes is enable'
    problem=yes
fi

# XXX Your operating system ideally should have the PHKL_41967 - 11.31 fs_select cumulative patch or later applied.

case $problem in
no)  
    stdoutmsg "$qpk"
    emit "Checker for $ver finished, with no detected problems"
    exit 0
    ;;
yes)
    stdoutmsg "$qpk $atomiclib $streampipes"
    stdoutmsg "$minqpk $min_atomiclib $min_streampipes"
    emit "Checker for $ver finished, with problems"
    exit 1;;
esac
