%macro STARTLASRSERVER	( TYPE=MPP, HOST=, PORT=, INST=/opt/TKGrid, SIGNER=, PATH=/tmp/, NODES=ALL
						, FORCE=, VERBOSE=, LIFETIME=, TABLEMEM=, EXTERNALMEM=
						, LOGGING=, LOGGINGPATH=, MAXFILESIZE=, MAXROLLNUM=, KEEPLOG=, LOGADDITIONAL=
						);

	%IF (&TYPE. eq MPP) %THEN 		%LET TYPEMSG=%str(distributed);
	%ELSE %IF (&TYPE. eq SMP) %THEN %LET TYPEMSG=%str(single machine);
	%ELSE %RETURN;

	%IF ("&NODES." eq "") %THEN %LET NODES=ALL;

	%IF ("&SIGNER." ne "") %THEN %LET SIGNERMSG=%str(signed);
	%ELSE %LET SIGNERMSG=%str(unsigned);
			
	%msg( msg=%str(Starting &TYPEMSG. &SIGNERMSG. LASR Server &HOST.:&PORT. ), LEVEL=ACTION);

	%setoption(on,fullstimer);
	%setoption(on,source);
	%IF ( &TYPE. eq SMP ) %THEN
		%DO;
			%IF (%SYMEXIST(SMPSERVERMODE)) %THEN %DO;

				/* Become the SMP Server */

				%put BECOMING THE SMP SERVER;

				LIBNAME LASRSERV SASIOLA STARTSERVER=(path="&PATH.")
				HOST="&HOST." PORT=&PORT.
				%IF ("&SIGNER." ne "") %THEN %DO;
					SIGNER="&SIGNER."
				%END;
				;

				proc vasmp;
	            	serverwait port=&PORT.;
	         	quit;

				/* Cleanup PID file */
				%DeleteProcessIDFile;

				endsas;

			%END;
			%ELSE %DO;

				/* Launch separate SAS process to become the SMP server */
				%let workDir = %sysfunc(getoption(work));  /* work dir, temp dir */                                                                     

				/* Create the task name */
				%let TRANSHOST=&HOST.;
				%let pos=%kindex(&HOST.,.);
				%if (&pos. gt 0) %then %let TRANSHOST=%KSUBSTR(&HOST.,1,%eval(&pos.-1));
				%let taskName=smp_&transHost._&PORT.;

				/* Kill any pre-existing task with this name */
				systask kill "&taskName.";

				/* Build options for initializing the SMP launch session */
				%let PIDLOC=&AL_AUTOLOAD_LOGS_DIR.&OSSLASH.&taskName..pid;
				%if %SYMEXIST(AL_MONITORING_PATH) %then 
					%let PIDLOC=&AL_MONITORING_PATH.&OSSLASH.PIDs&OSSLASH.&taskName..pid;
				%let LOGLOC=&AL_AUTOLOAD_LOGS_DIR.&OSSLASH.&taskName..log;
				%let LSTLOC=&AL_AUTOLOAD_LOGS_DIR.&OSSLASH.&taskName..lst;

				/* Here we assume that this process already includes the location of autoload.sas on the command line */
				%let defaultArgs=%nrstr(-initstmt %'%global SMPSERVERMODE; %let) %str(TASKNAME=&TASKNAME.;) %nrstr(%let) %str(PIDFILE=&PIDLOC.;%') %str(-log %"&LOGLOC.%") %str(-print %"&LSTLOC.%");
				/*-rsasuser -macro -nocardimage -noterminal -noxcmd;*/

				%global CommandLine;
				%getCommandLine;

				%let CommandLine=%StripUnneededSASArgs(COMMAND=&CommandLine.);
				%let serverCmd=&CommandLine. &defaultArgs.;

				/* Replace double quotes with single quotes */
				option notes;
				%global quoteServerCmd;
				data _null_;
				   format original $32767.;
				   format modified $32767.;
				   original=symget("serverCmd");
				   original=ktrim(original);
				   modified=tranwrd(original,'"',"'");
				   call symput("quoteServerCmd",ktrim(modified));
				run;
				option nonotes;

				%PUT NOTE: LAUNCHING NEW SAS PROCESS TO BECOME THE SMP SERVER;
				%PUT NOTE: COMMAND: [&quoteserverCmd.];

				/* Start the new task */
				%let serverRC = ' ';                                                                                                                    
/*				systask command " &serverCmd " taskname="&taskName." nowait status = serverRC;*/
				systask command " %superq(quoteServerCmd) " taskname="&taskName." nowait status = serverRC;

				%if &sysrc ^= 0 %then                                                                                                                   
				%do;                                                                                                                                    
				  %put ERROR: SAS SMP SERVER PROCESS COULD NOT BE LAUNCHED: &sysrc;
				%end;          
				%else %do;
					%put NOTE: PROCESS STATUS = &serverRC.;
					%put NOTE: WAITING 10 SECONDS FOR SERVER STARTUP...;
					%sleep(10); /* Sleep 10 seconds to allow task to start up */
					%put NOTE: PROCESS STATUS = &serverRC.;
				%end; 

			%END;

		%END;
	%ELSE /* Distributed server */
		%DO;
			proc lasr create port=&PORT. 
			   &VERBOSE.
			   &FORCE. 
			   path="&PATH."
			   %IF ("&LIFETIME." ne "") %THEN %DO;
				 lifetime=&LIFETIME.
			   %END;
			   %IF ("&SIGNER." ne "") %THEN %DO;
				 signer="&SIGNER."
			   %END;
			   %IF ("&TABLEMEM." ne "") %THEN %DO;
			     tablemem=&TABLEMEM.
			   %END;
			   %IF ("&EXTERNALMEM." ne "") %THEN %DO;
			     externalmem=&EXTERNALMEM.
			   %END;
			   %IF ("&LOGGING." ne "") %THEN %DO;
			   	&LOGGING.
					(
						%IF ("&LOGGINGPATH." ne "") %THEN %DO;
							PATH="&LOGGINGPATH."
						%END;
						%IF ("&MAXFILESIZE." ne "") %THEN %DO;
							MAXFILESIZE=&MAXFILESIZE.
						%END;
						%IF ("&MAXROLLNUM." ne "") %THEN %DO;
							MAXROLLNUM=&MAXROLLNUM.
						%END;
						&KEEPLOG.
						&LOGADDITIONAL.
					)
			   %END;
				;
			   performance
			   host="&HOST."
			   install="&INST."
			   nodes=&NODES.
			   ;
			run;
		%END;
		%setoption(restore,source);
		%setoption(restore,fullstimer);

%mend;
