/*
 * Messages
 *
 * Purpose:
 * This file contains macros used to output messages in various forms.
 *
 */

/* 
 * Msg
 * 
 * Purpose: Outputs a message to the console
 * 
 * Parms:
 *		type=	Set to NOTE, ERROR, WARNING, or OTHER.  Defaults to NOTE
 *		msg=	The message to output
 *		level=	The level to pass to logging
 *
 */
%macro msg( type=NOTE, msg=, level=INFO );
	
	%let TYPE=%upcase(&TYPE.):;

	%if (&type. eq OTHER: ) %then %let TYPE=;

	%PUT &TYPE. &MSG.;
	%TimeStamp( %str(&MSG.), LEVEL=&LEVEL. );
 
%mend msg;

/*
 * DumpError
 *
 * Dumps error information to the SAS log as well as to the autoload log
 */
%macro DumpError;
   %msg( TYPE=ERROR, LEVEL=ERROR, msg=%bquote(&SYSERR.: &SYSERRORTEXT.));
%mend;
