/*
 * LoadTableToLASR
 *
 * Purpose: Loads a table to a LASR library
 *
 * Parameters:
 *
 *		data=		The source data to load to the target library
 * 		libref=		The already-assigned libref into which to load the table
 *      dsopts=		Additional data set options for performing the load
 *
 */ 
%macro LoadTableToLASR	( data=
						, libref=
						, dsopts=
						);
	/* Compute date string label for load */
	%GetDateTimeString(var=DTSTRING);

	%let tablepart 	= %SplitLibTable(data=%nrbquote(&data.), part=TABLE);
	%let libpart	= %SplitLibTable(data=%nrbquote(&data.), part=LIBRARY);
	%let tablepart 	= %NLITERAL(&tablepart.);
	%setoption(on,fullstimer);
	%setoption(on,source);
	data &libref..&tablepart. (&dsopts. label="Auto loaded &DTSTRING.");;
		set &libpart..&tablepart.;
	run;
	%setoption(restore,source);
	%setoption(restore,fullstimer);
%mend;
						
