/*
 * ImportExcel
 *
 * Purpose: Imports a spreadsheet to a SAS Data Set
 *
 * Parameters:
 *
 *		excel=		The source excel file (full path) to load to the target library
 *		table=		The target table name (pre-processed for eliminating special/prohibited characters)
 * 		libref=		The already-assigned libref into which to load the table
 *		getnames=	If YES, column names will be retrieved from first row.  Defaults to YES
 *		additionalopts= Additional options to use during import operation
 *
 */
%macro ImportExcel		( excel=
                        , table=
						, libref=
						, getnames=YES
						, additionalopts=
						);

	%let excel=%superq(excel);
	%let table=%superq(table);

	data _null_;
		length extension $1024;
		extension=upcase(scan("&excel.",-1,'.'));
		call symput ('DBMS',strip(extension));
	run;

	%if ( &DBMS. eq XLSB or &DBMS. eq XLSM ) %then %let DBMS=EXCEL;
	
	/* Convert Excel spreadsheet into SAS dataset */
	%setoption(on,fullstimer);
	%setoption(on,mprint);
	filename impfile "&excel.";
    PROC IMPORT
      DATAFILE="impfile"
      OUT=&libref.."%unquote(&table.)"n
      REPLACE
      DBMS=&DBMS;
	  &ADDITIONALOPTS.
      GETNAMES=&GETNAMES.;
    RUN;
	%setoption(restore,mprint);
	%setoption(restore,fullstimer);
	filename impfile clear;

%mend;


