/*
 * GetTablesListFromLibrary()
 * 
 * Purpose: Given a libref, returns the list of members in that library.  Defaults to 
 *			tables list, unless type is specified.
 *
 * Parms:
 * 		data=     The output data set to create.  If unspecified, defaults to work.tablelist.
 *      inlibref= The libref assigned to the source library to list.
 *		type=     The member type to list.  Defaults to DATA, but CATALOG can also be specified.
 */ 
%macro GetTablesListFromLibrary( data=WORK.tablelist, inlibref=, type=DATA, RENAME=NO );
	%setoption(off,notes);
	%if ("&inlibref." eq "" ) %then %do;
	   %put ERROR: Source library must be specified with INLIBREF=;
	   %return;
	%end;

	/* Redirect output */
	ods listing close;
	ods results off;
	ods output members=&DATA.; 

	/* Get Tables List */
	PROC DATASETS LIBRARY=&INLIBREF. MEMTYPE=&TYPE. nowarn;
	quit;
	%LET LISTCREATED=&SYSERR.;

	/* Restore output */
	ods results on;
	ods listing;

	%IF ( &RENAME. = YES ) %THEN %DO;
		%RenameColumnByIndex(data=&DATA., COLINDEX=4, NEWCOLNAME=FileSize);
		%RenameColumnByIndex(data=&DATA., COLINDEX=5, NEWCOLNAME=LastModified);
	%END;

	/* Add libref */
	data &data.;
		length fullref 
				$256;
		length name $128;
		format mdate NLDATMS27.;
		call missing(mdate);

		%IF "&LISTCREATED." eq "0" %THEN %DO;
			set &data.;
			fullref=kupcase("&inlibref.." || name);
			if kupcase(MemType) eq "&TYPE.";
		%END;
		%ELSE %DO;
		    call missing( fullref, name );
			delete;
		%END;
	run;

	%setoption(restore,notes);
%mend;
